/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.elonen;

import fi.iki.elonen.ChunkedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.nio.charset.StandardCharsets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public class ChunkedInputStreamTest {
    @Test
    @DisplayName(value="Simple decoding test")
    public void testChunkedInput() throws IOException {
        int n;
        String data = "4\r\nWiki\r\n7\r\npedia i\r\nB;1h\ra\nllo\r\nn \r\nchunks.\r\n0\r\n\r\n";
        String expected = "Wikipedia in \r\nchunks.";
        ChunkedInputStream stream = new ChunkedInputStream((InputStream)new StringBufferInputStream(data));
        StringBuilder sb = new StringBuilder();
        byte[] buf = new byte[6];
        while ((n = stream.read(buf)) > 0) {
            sb.append(new String(buf, 0, n, StandardCharsets.US_ASCII));
        }
        Assertions.assertEquals((Object)sb.toString(), (Object)expected);
    }
}

