/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.firmware;

import java.io.File;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.openslx.firmware.FirmwareTarget;
import org.openslx.firmware.QemuFirmware;
import org.openslx.firmware.QemuFirmwareTestResources;

public class QemuFirmwareTest {
    @Test
    @DisplayName(value="Test parsing of valid QEMU firmware specification file")
    public void testQemuFirmwareFromFwSpecValid() {
        File fwSpecFile = QemuFirmwareTestResources.getQemuFirmwareSpecFile("60-edk2-x86_64.json");
        QemuFirmware firmware = QemuFirmware.fromFwSpec((File)fwSpecFile);
        Assertions.assertNotNull((Object)firmware);
        Assertions.assertEquals((Object)"UEFI firmware for x86_64", (Object)firmware.getDescription());
        Assertions.assertEquals((int)1, (int)firmware.getInterfaceTypes().size());
        Assertions.assertEquals((Object)"uefi", firmware.getInterfaceTypes().get(0));
        Assertions.assertEquals((Object)"/usr/share/qemu/edk2-x86_64-code.fd", (Object)firmware.getMapping().getExecutable().getFileName());
        Assertions.assertEquals((Object)"/usr/share/qemu/edk2-i386-vars.fd", (Object)firmware.getMapping().getNvramTemplate().getFileName());
        Assertions.assertEquals((int)1, (int)firmware.getTargets().size());
        Assertions.assertEquals((Object)"x86_64", (Object)((FirmwareTarget)firmware.getTargets().get(0)).getArchitecture());
        Assertions.assertEquals((int)2, (int)((FirmwareTarget)firmware.getTargets().get(0)).getMachines().size());
        Assertions.assertEquals((Object)"pc-i440fx-*", ((FirmwareTarget)firmware.getTargets().get(0)).getMachines().get(0));
        Assertions.assertEquals((Object)"pc-q35-*", ((FirmwareTarget)firmware.getTargets().get(0)).getMachines().get(1));
        Assertions.assertEquals((int)3, (int)firmware.getFeatures().size());
        Assertions.assertEquals((int)0, (int)firmware.getTags().size());
    }

    @Test
    @DisplayName(value="Test parsing of invalid QEMU firmware specification file")
    public void testQemuFirmwareFromFwSpecInvalid() {
        QemuFirmware firmware = QemuFirmware.fromFwSpec(null);
        Assertions.assertNull((Object)firmware);
    }
}

