/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.firmware;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;

public class QemuFirmwareTestResources {
    private static final String QEMU_PREFIX_PATH = "/qemu";
    private static final String QEMU_PREFIX_PATH_FW = "/qemu/firmware";
    private static final String QEMU_TEMP_PREFIX = "qemu-";

    public static String getQemuFirmwareSpecPath() {
        String fwSpecDir = null;
        try {
            fwSpecDir = QemuFirmwareTestResources.getResourceDirectory(QemuFirmwareTestResources.class, QEMU_PREFIX_PATH_FW);
        }
        catch (IOException e) {
            fwSpecDir = null;
        }
        return fwSpecDir;
    }

    private static String getResourceDirectory(Class<?> clazz, String resourceDir) throws IOException {
        File fwDirectory;
        String fwDirPath = resourceDir.substring(1).concat("/");
        URL fwResource = clazz.getResource(resourceDir);
        String fwDirectoryPath = null;
        if (fwResource != null && "jar".equals(fwResource.getProtocol())) {
            fwDirectory = Files.createTempDirectory(QEMU_TEMP_PREFIX, new FileAttribute[0]).toFile();
            String jarPath = fwResource.getPath().substring(5, fwResource.getPath().indexOf("!"));
            JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
            Enumeration<JarEntry> jarEntries = jar.entries();
            HashSet<String> fileNames = new HashSet<String>();
            while (jarEntries.hasMoreElements()) {
                String jarEntry;
                String jarEntryName = jarEntries.nextElement().getName();
                if (!jarEntryName.startsWith(fwDirPath) || (jarEntry = jarEntryName.substring(fwDirPath.length())).isEmpty()) continue;
                fileNames.add(jarEntry);
            }
            fileNames.forEach(fileName -> {
                String resourceFileName = resourceDir + "/" + fileName;
                File tempFile = new File(fwDirectory.getPath() + File.separator + fileName);
                InputStream fileInput = QemuFirmwareTestResources.class.getResourceAsStream(resourceFileName);
                try {
                    FileUtils.copyInputStreamToFile((InputStream)fileInput, (File)tempFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                tempFile.deleteOnExit();
            });
            fwDirectory.deleteOnExit();
        } else {
            fwDirectory = fwResource != null && "file".equals(fwResource.getProtocol()) ? new File(fwResource.getFile()) : null;
        }
        try {
            fwDirectoryPath = fwDirectory.toURI().toURL().getFile();
        }
        catch (NullPointerException | MalformedURLException e) {
            fwDirectoryPath = null;
        }
        return fwDirectoryPath;
    }

    public static File getQemuFirmwareSpecFile(String fileName) {
        String fwSpecFilePath = "/qemu/firmware/" + fileName;
        URL fwSpecFileUrl = QemuFirmwareTestResources.class.getResource(fwSpecFilePath);
        return new File(fwSpecFileUrl.getFile());
    }
}

