/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.firmware;

import java.nio.file.Paths;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.openslx.firmware.FirmwareException;
import org.openslx.firmware.QemuFirmwareTestResources;
import org.openslx.firmware.QemuFirmwareUtil;
import org.openslx.libvirt.domain.Domain;
import org.openslx.libvirt.domain.DomainTest;

public class QemuFirmwareUtilTest {
    @Test
    @DisplayName(value="Test that lookup of OS loader from Libvirt domain file succeeds")
    public void testQemuFirmwareUtilLookupTargetOsLoaderValid() throws FirmwareException {
        String fwSpecPath = QemuFirmwareTestResources.getQemuFirmwareSpecPath();
        Domain config = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm_transform-non-persistent_uefi.xml");
        String targetOsLoader = QemuFirmwareUtil.lookupTargetOsLoader((String)fwSpecPath, (String)config.getOsLoader(), (String)config.getOsArch(), (String)config.getOsMachine());
        Assertions.assertEquals((Object)Paths.get("/usr/share/qemu/edk2-x86_64-code.fd", new String[0]).toString(), (Object)targetOsLoader);
    }

    @Test
    @DisplayName(value="Test that lookup of OS loader from Archlinux path succeeds")
    public void testQemuFirmwareUtilLookupTargetOsLoaderValidArchlinux() throws FirmwareException {
        String fwSpecPath = QemuFirmwareTestResources.getQemuFirmwareSpecPath();
        String targetOsLoader = QemuFirmwareUtil.lookupTargetOsLoader((String)fwSpecPath, (String)"/usr/share/edk2-ovmf/x64/OVMF_CODE.fd", (String)"x86_64", (String)"pc-q35-5.0");
        Assertions.assertEquals((Object)Paths.get("/usr/share/qemu/edk2-x86_64-code.fd", new String[0]).toString(), (Object)targetOsLoader);
    }

    @Test
    @DisplayName(value="Test that lookup of OS loader from Debian path succeeds")
    public void testQemuFirmwareUtilLookupTargetOsLoaderValidDebian() throws FirmwareException {
        String fwSpecPath = QemuFirmwareTestResources.getQemuFirmwareSpecPath();
        String targetOsLoader = QemuFirmwareUtil.lookupTargetOsLoader((String)fwSpecPath, (String)"/usr/share/OVMF/OVMF_CODE.fd", (String)"x86_64", (String)"pc-q35-5.0");
        Assertions.assertEquals((Object)Paths.get("/usr/share/qemu/edk2-x86_64-code.fd", new String[0]).toString(), (Object)targetOsLoader);
    }

    @Test
    @DisplayName(value="Test that lookup of OS loader from CentOS path succeeds")
    public void testQemuFirmwareUtilLookupTargetOsLoaderValidCentOs() throws FirmwareException {
        String fwSpecPath = QemuFirmwareTestResources.getQemuFirmwareSpecPath();
        String targetOsLoader = QemuFirmwareUtil.lookupTargetOsLoader((String)fwSpecPath, (String)"/usr/share/edk2/ovmf/OVMF_CODE.cc.fd", (String)"x86_64", (String)"pc-q35-5.0");
        Assertions.assertEquals((Object)Paths.get("/usr/share/qemu/edk2-x86_64-code.fd", new String[0]).toString(), (Object)targetOsLoader);
    }

    @Test
    @DisplayName(value="Test that lookup of OS loader from OpenSUSE path succeeds")
    public void testQemuFirmwareUtilLookupTargetOsLoaderValidOpenSuse() throws FirmwareException {
        String fwSpecPath = QemuFirmwareTestResources.getQemuFirmwareSpecPath();
        String targetOsLoader = QemuFirmwareUtil.lookupTargetOsLoader((String)fwSpecPath, (String)"/usr/share/qemu/ovmf-x86_64-4m-code.bin", (String)"x86_64", (String)"pc-q35-5.0");
        Assertions.assertEquals((Object)Paths.get("/usr/share/qemu/edk2-x86_64-code.fd", new String[0]).toString(), (Object)targetOsLoader);
    }

    @Test
    @DisplayName(value="Test that lookup of OS loader from Ubuntu path succeeds")
    public void testQemuFirmwareUtilLookupTargetOsLoaderValidUbuntu() throws FirmwareException {
        String fwSpecPath = QemuFirmwareTestResources.getQemuFirmwareSpecPath();
        String targetOsLoader = QemuFirmwareUtil.lookupTargetOsLoader((String)fwSpecPath, (String)"/usr/share/OVMF/OVMF_CODE_4M.fd", (String)"x86_64", (String)"pc-q35-5.0");
        Assertions.assertEquals((Object)Paths.get("/usr/share/qemu/edk2-x86_64-code.fd", new String[0]).toString(), (Object)targetOsLoader);
    }

    @Test
    @DisplayName(value="Test that lookup of non-existent OS loader for non-existent architecture fails")
    public void testQemuFirmwareUtilLookupTargetOsLoaderInvalid() throws FirmwareException {
        String fwSpecPath = QemuFirmwareTestResources.getQemuFirmwareSpecPath();
        Assertions.assertThrows(FirmwareException.class, () -> QemuFirmwareUtil.lookupTargetOsLoader((String)fwSpecPath, (String)Paths.get("/non/existent/loader.fd", new String[0]).toString(), (String)"x87", (String)"pc-q35-6.0"));
    }
}

