/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.libvirt.capabilities;

import java.math.BigInteger;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.openslx.libvirt.capabilities.Capabilities;
import org.openslx.libvirt.capabilities.cpu.Cpu;
import org.openslx.libvirt.capabilities.cpu.Feature;
import org.openslx.libvirt.capabilities.cpu.Pages;
import org.openslx.libvirt.capabilities.guest.Domain;
import org.openslx.libvirt.capabilities.guest.Guest;
import org.openslx.libvirt.capabilities.guest.Machine;
import org.openslx.libvirt.domain.Domain;
import org.openslx.libvirt.xml.LibvirtXmlDocumentException;
import org.openslx.libvirt.xml.LibvirtXmlSerializationException;
import org.openslx.libvirt.xml.LibvirtXmlTestResources;
import org.openslx.libvirt.xml.LibvirtXmlValidationException;

public class CapabilitiesTest {
    @BeforeAll
    public static void setUp() {
        Configurator.setRootLevel((Level)Level.OFF);
    }

    private Capabilities newCapabilitiesInstance(String xmlFileName) {
        Capabilities caps = null;
        try {
            caps = new Capabilities(LibvirtXmlTestResources.getLibvirtXmlFile(xmlFileName));
        }
        catch (LibvirtXmlDocumentException | LibvirtXmlSerializationException | LibvirtXmlValidationException e) {
            String errorMsg = new String("Cannot prepare requested Libvirt capabilities XML file from the resources folder");
            Assertions.fail((String)errorMsg);
        }
        return caps;
    }

    @Test
    @DisplayName(value="Get host UUID from libvirt XML capabilities file")
    public void testGetHostUuid() {
        Capabilities caps = this.newCapabilitiesInstance("qemu-kvm_capabilities_default.xml");
        Assertions.assertEquals((Object)"9b2f12af-1fba-444c-b72b-9cbc43fb3ca5", (Object)caps.getHostUuid());
    }

    @Test
    @DisplayName(value="Get host CPU from libvirt XML capabilities file")
    public void testGetHostCpu() {
        Capabilities caps = this.newCapabilitiesInstance("qemu-kvm_capabilities_default.xml");
        Cpu hostCpu = caps.getHostCpu();
        Assertions.assertNotNull((Object)hostCpu);
        Assertions.assertEquals((Object)"x86_64", (Object)hostCpu.getArch());
        Assertions.assertEquals((Object)"Skylake-Client-IBRS", (Object)hostCpu.getModel());
        Assertions.assertEquals((Object)"Intel", (Object)hostCpu.getVendor());
        Assertions.assertEquals((int)1, (int)hostCpu.getTopologySockets());
        Assertions.assertEquals((int)1, (int)hostCpu.getTopologyDies());
        Assertions.assertEquals((int)4, (int)hostCpu.getTopologyCores());
        Assertions.assertEquals((int)1, (int)hostCpu.getTopologyThreads());
    }

    @Test
    @DisplayName(value="Get non-existent host CPU from libvirt XML capabilities file")
    public void testGetHostCpuNonExistent() {
        Capabilities caps = this.newCapabilitiesInstance("qemu-kvm_capabilities_no-cpu.xml");
        Cpu hostCpu = caps.getHostCpu();
        Assertions.assertNull((Object)hostCpu);
    }

    @Test
    @DisplayName(value="Get host CPU features from libvirt XML capabilities file")
    public void testGetHostCpuFeatures() {
        Capabilities caps = this.newCapabilitiesInstance("qemu-kvm_capabilities_default.xml");
        Cpu hostCpu = caps.getHostCpu();
        Assertions.assertNotNull((Object)hostCpu);
        List hostCpuFeatures = hostCpu.getFeatures();
        Assertions.assertNotNull((Object)hostCpuFeatures);
        Assertions.assertEquals((int)25, (int)hostCpuFeatures.size());
        Feature hostCpuFeature = (Feature)hostCpuFeatures.get(9);
        Assertions.assertNotNull((Object)hostCpuFeature);
        Assertions.assertEquals((Object)"vmx", (Object)hostCpuFeature.getName());
    }

    @Test
    @DisplayName(value="Get empty host CPU features from libvirt XML capabilities file")
    public void testGetHostCpuFeaturesEmpty() {
        Capabilities caps = this.newCapabilitiesInstance("qemu-kvm_capabilities_no-cpu-features.xml");
        Cpu hostCpu = caps.getHostCpu();
        Assertions.assertNotNull((Object)hostCpu);
        List hostCpuFeatures = hostCpu.getFeatures();
        Assertions.assertNotNull((Object)hostCpuFeatures);
        Assertions.assertEquals((int)0, (int)hostCpuFeatures.size());
    }

    @Test
    @DisplayName(value="Get host CPU pages from libvirt XML capabilities file")
    public void testGetHostCpuPages() {
        Capabilities caps = this.newCapabilitiesInstance("qemu-kvm_capabilities_default.xml");
        Cpu hostCpu = caps.getHostCpu();
        Assertions.assertNotNull((Object)hostCpu);
        List hostCpuPages = hostCpu.getPages();
        Assertions.assertNotNull((Object)hostCpuPages);
        Assertions.assertEquals((int)3, (int)hostCpuPages.size());
        Pages hostCpuPage = (Pages)hostCpuPages.get(2);
        Assertions.assertNotNull((Object)hostCpuPage);
        Assertions.assertEquals((Object)new BigInteger("1073741824").toString(), (Object)hostCpuPage.getSize().toString());
    }

    @Test
    @DisplayName(value="Get empty host CPU pages from libvirt XML capabilities file")
    public void testGetHostCpuPagesEmpty() {
        Capabilities caps = this.newCapabilitiesInstance("qemu-kvm_capabilities_no-cpu-pages.xml");
        Cpu hostCpu = caps.getHostCpu();
        Assertions.assertNotNull((Object)hostCpu);
        List hostCpuPages = hostCpu.getPages();
        Assertions.assertNotNull((Object)hostCpuPages);
        Assertions.assertEquals((int)0, (int)hostCpuPages.size());
    }

    @Test
    @DisplayName(value="Get host IOMMU support from libvirt XML capabilities file")
    public void testGetHostIommuSupport() {
        Capabilities caps = this.newCapabilitiesInstance("qemu-kvm_capabilities_default.xml");
        Assertions.assertEquals((Object)true, (Object)caps.hasHostIommuSupport());
    }

    @Test
    @DisplayName(value="Get non-existent host IOMMU support from libvirt XML capabilities file")
    public void testGetHostIommuSupportNonExistent() {
        Capabilities caps = this.newCapabilitiesInstance("qemu-kvm_capabilities_no-iommu.xml");
        Assertions.assertEquals((Object)false, (Object)caps.hasHostIommuSupport());
    }

    @Test
    @DisplayName(value="Get guests from libvirt XML capabilities file")
    public void testGetGuests() {
        Capabilities caps = this.newCapabilitiesInstance("qemu-kvm_capabilities_default.xml");
        List guests = caps.getGuests();
        Assertions.assertNotNull((Object)guests);
        Assertions.assertEquals((int)26, (int)guests.size());
        Guest guest = (Guest)guests.get(3);
        Assertions.assertNotNull((Object)guest);
        Assertions.assertEquals((Object)Domain.OsType.HVM.toString(), (Object)guest.getOsType().toString());
        Assertions.assertEquals((Object)"aarch64", (Object)guest.getArchName());
        Assertions.assertEquals((int)64, (int)guest.getArchWordSize());
        Assertions.assertEquals((Object)"/usr/bin/qemu-system-aarch64", (Object)guest.getArchEmulator());
    }

    @Test
    @DisplayName(value="Get empty guests from libvirt XML capabilities file")
    public void testGetGuestsEmpty() {
        Capabilities caps = this.newCapabilitiesInstance("qemu-kvm_capabilities_no-guests.xml");
        List guests = caps.getGuests();
        Assertions.assertNotNull((Object)guests);
        Assertions.assertEquals((int)0, (int)guests.size());
    }

    @Test
    @DisplayName(value="Get guest machines from libvirt XML capabilities file")
    public void testGetGuestMachines() {
        Capabilities caps = this.newCapabilitiesInstance("qemu-kvm_capabilities_default.xml");
        List guests = caps.getGuests();
        Assertions.assertNotNull((Object)guests);
        Assertions.assertEquals((int)26, (int)guests.size());
        Guest guest = (Guest)guests.get(3);
        Assertions.assertNotNull((Object)guest);
        List guestMachines = guest.getArchMachines();
        Assertions.assertNotNull((Object)guestMachines);
        Assertions.assertEquals((int)89, (int)guestMachines.size());
        Machine guestMachine = (Machine)guestMachines.get(5);
        Assertions.assertNotNull((Object)guestMachine);
        Assertions.assertNull((Object)guestMachine.getCanonicalMachine());
        Assertions.assertEquals((int)2, (int)guestMachine.getMaxCpus());
        Assertions.assertEquals((Object)"nuri", (Object)guestMachine.getName());
    }

    @Test
    @DisplayName(value="Get empty guest machines from libvirt XML capabilities file")
    public void testGetGuestMachinesEmpty() {
        Capabilities caps = this.newCapabilitiesInstance("qemu-kvm_capabilities_no-guest-machines.xml");
        List guests = caps.getGuests();
        Assertions.assertNotNull((Object)guests);
        Assertions.assertEquals((int)26, (int)guests.size());
        Guest guest = (Guest)guests.get(3);
        Assertions.assertNotNull((Object)guest);
        List guestMachines = guest.getArchMachines();
        Assertions.assertNotNull((Object)guestMachines);
        Assertions.assertEquals((int)0, (int)guestMachines.size());
    }

    @Test
    @DisplayName(value="Get canonical guest machine from libvirt XML capabilities file")
    public void testGetGuestMachineCanonical() {
        Capabilities caps = this.newCapabilitiesInstance("qemu-kvm_capabilities_default.xml");
        List guests = caps.getGuests();
        Assertions.assertNotNull((Object)guests);
        Assertions.assertEquals((int)26, (int)guests.size());
        Guest guest = (Guest)guests.get(3);
        Assertions.assertNotNull((Object)guest);
        List guestMachines = guest.getArchMachines();
        Assertions.assertNotNull((Object)guestMachines);
        Assertions.assertEquals((int)89, (int)guestMachines.size());
        Machine guestMachine = (Machine)guestMachines.get(29);
        Assertions.assertNotNull((Object)guestMachine);
        Assertions.assertEquals((Object)"virt-5.2", (Object)guestMachine.getCanonicalMachine());
        Assertions.assertEquals((int)512, (int)guestMachine.getMaxCpus());
        Assertions.assertEquals((Object)"virt", (Object)guestMachine.getName());
    }

    @Test
    @DisplayName(value="Get guest machine domains from libvirt XML capabilities file")
    public void testGetGuestMachineDomains() {
        Capabilities caps = this.newCapabilitiesInstance("qemu-kvm_capabilities_default.xml");
        List guests = caps.getGuests();
        Assertions.assertNotNull((Object)guests);
        Assertions.assertEquals((int)26, (int)guests.size());
        Guest guest = (Guest)guests.get(5);
        Assertions.assertNotNull((Object)guest);
        List guestDomains = guest.getArchDomains();
        Assertions.assertNotNull((Object)guestDomains);
        Assertions.assertEquals((int)2, (int)guestDomains.size());
        Domain guestDomain = (Domain)guestDomains.get(1);
        Assertions.assertNotNull((Object)guestDomain);
        Assertions.assertEquals((Object)Domain.Type.KVM, (Object)guestDomain.getType());
    }

    @Test
    @DisplayName(value="Get empty guest machine domains from libvirt XML capabilities file")
    public void testGetGuestMachineDomainsEmpty() {
        Capabilities caps = this.newCapabilitiesInstance("qemu-kvm_capabilities_no-guest-machines.xml");
        List guests = caps.getGuests();
        Assertions.assertNotNull((Object)guests);
        Assertions.assertEquals((int)26, (int)guests.size());
        Guest guest = (Guest)guests.get(3);
        Assertions.assertNotNull((Object)guest);
        List guestDomains = guest.getArchDomains();
        Assertions.assertNotNull((Object)guestDomains);
        Assertions.assertEquals((int)0, (int)guestDomains.size());
    }
}

