/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.libvirt.domain;

import java.math.BigInteger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.openslx.libvirt.domain.Domain;
import org.openslx.libvirt.xml.LibvirtXmlDocumentException;
import org.openslx.libvirt.xml.LibvirtXmlSerializationException;
import org.openslx.libvirt.xml.LibvirtXmlTestResources;
import org.openslx.libvirt.xml.LibvirtXmlValidationException;

public class DomainTest {
    @BeforeAll
    public static void setUp() {
        Configurator.setRootLevel((Level)Level.OFF);
    }

    public static Domain getDomain(String xmlFileName) {
        Domain domain = null;
        try {
            domain = new Domain(LibvirtXmlTestResources.getLibvirtXmlStream(xmlFileName));
        }
        catch (LibvirtXmlDocumentException | LibvirtXmlSerializationException | LibvirtXmlValidationException e) {
            String errorMsg = new String("Cannot prepare requested Libvirt domain XML file from the resources folder");
            Assertions.fail((String)errorMsg);
        }
        return domain;
    }

    @Test
    @DisplayName(value="Get VM type from libvirt XML file")
    public void testGetType() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        Assertions.assertEquals((Object)Domain.Type.KVM.toString(), (Object)vm.getType().toString());
    }

    @Test
    @DisplayName(value="Set VM type from libvirt XML file")
    public void testSetType() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        vm.setType(Domain.Type.QEMU);
        Assertions.assertEquals((Object)Domain.Type.QEMU.toString(), (Object)vm.getType().toString());
    }

    @Test
    @DisplayName(value="Get VM name from libvirt XML file")
    public void testGetName() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        Assertions.assertEquals((Object)"ubuntu-20-04", (Object)vm.getName());
    }

    @Test
    @DisplayName(value="Set VM name in libvirt XML file")
    public void testSetName() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        vm.setName("ubuntu-18-04");
        Assertions.assertEquals((Object)"ubuntu-18-04", (Object)vm.getName());
    }

    @Test
    @DisplayName(value="Get VM title from libvirt XML file")
    public void testGetTitle() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        Assertions.assertEquals((Object)"Ubuntu 20.04", (Object)vm.getTitle());
    }

    @Test
    @DisplayName(value="Set VM title in libvirt XML file")
    public void testSetTitle() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        vm.setTitle("Ubuntu 18.04");
        Assertions.assertEquals((Object)"Ubuntu 18.04", (Object)vm.getTitle());
    }

    @Test
    @DisplayName(value="Get VM description from libvirt XML file")
    public void testGetDescription() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        Assertions.assertEquals((Object)"Ubuntu 20.04 desktop installation", (Object)vm.getDescription());
    }

    @Test
    @DisplayName(value="Set VM description in libvirt XML file")
    public void testSetDescription() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        vm.setDescription("Ubuntu 18.04 server installation");
        Assertions.assertEquals((Object)"Ubuntu 18.04 server installation", (Object)vm.getDescription());
    }

    @Test
    @DisplayName(value="Get VM libosinfo operating system identifier in libvirt XML file")
    public void testGetLibOsInfoOsId() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        Assertions.assertEquals((Object)"http://ubuntu.com/ubuntu/20.04", (Object)vm.getLibOsInfoOsId());
    }

    @Test
    @DisplayName(value="Get VM UUID from libvirt XML file")
    public void testGetUuid() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        Assertions.assertEquals((Object)"8dc5433c-0228-49e4-b019-fa2b606aa544", (Object)vm.getUuid());
    }

    @Test
    @DisplayName(value="Set VM UUID in libvirt XML file")
    public void testSetUuid() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        vm.setUuid("5ab08167-3d95-400e-ac83-e6af8d150971");
        Assertions.assertEquals((Object)"5ab08167-3d95-400e-ac83-e6af8d150971", (Object)vm.getUuid());
    }

    @Test
    @DisplayName(value="Get VM memory from libvirt XML file")
    public void testGetMemory() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        Assertions.assertEquals((Object)new BigInteger("4294967296").toString(), (Object)vm.getMemory().toString());
    }

    @Test
    @DisplayName(value="Set VM memory in libvirt XML file")
    public void testSetMemory() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        vm.setMemory(new BigInteger("12073740288"));
        Assertions.assertEquals((Object)new BigInteger("12073740288").toString(), (Object)vm.getMemory().toString());
    }

    @Test
    @DisplayName(value="Get current VM memory from libvirt XML file")
    public void testGetCurrentMemory() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        Assertions.assertEquals((Object)new BigInteger("4294967296").toString(), (Object)vm.getCurrentMemory().toString());
    }

    @Test
    @DisplayName(value="Set current VM memory in libvirt XML file")
    public void testSetCurrentMemory() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        vm.setCurrentMemory(new BigInteger("8087237632"));
        Assertions.assertEquals((Object)new BigInteger("8087237632").toString(), (Object)vm.getCurrentMemory().toString());
    }

    @Test
    @DisplayName(value="Get VM number of vCpus from libvirt XML file")
    public void testGetVCpu() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        Assertions.assertEquals((int)2, (int)vm.getVCpu());
    }

    @Test
    @DisplayName(value="Set VM number of vCpus in libvirt XML file")
    public void testSetVCpu() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        vm.setVCpu(4);
        Assertions.assertEquals((int)4, (int)vm.getVCpu());
    }

    @Test
    @DisplayName(value="Get VM's OS type from libvirt XML file")
    public void testGetOsType() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        Assertions.assertEquals((Object)Domain.OsType.HVM.toString(), (Object)vm.getOsType().toString());
    }

    @Test
    @DisplayName(value="Set VM's OS type in libvirt XML file")
    public void testSetOsType() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        vm.setOsType(Domain.OsType.XEN);
        Assertions.assertEquals((Object)Domain.OsType.XEN.toString(), (Object)vm.getOsType().toString());
    }

    @Test
    @DisplayName(value="Get VM's OS architecture from libvirt XML file")
    public void testGetOsArch() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        Assertions.assertEquals((Object)"x86_64", (Object)vm.getOsArch());
    }

    @Test
    @DisplayName(value="Set VM's OS architecture in libvirt XML file")
    public void testSetOsArch() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        vm.setOsArch("aarch");
        Assertions.assertEquals((Object)"aarch", (Object)vm.getOsArch());
    }

    @Test
    @DisplayName(value="Get VM's OS machine from libvirt XML file")
    public void testGetOsMachine() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        Assertions.assertEquals((Object)"pc-q35-5.1", (Object)vm.getOsMachine());
    }

    @Test
    @DisplayName(value="Set VM's OS machine in libvirt XML file")
    public void testSetOsMachine() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        vm.setOsMachine("pc");
        Assertions.assertEquals((Object)"pc", (Object)vm.getOsMachine());
    }

    @Test
    @DisplayName(value="Get VM's OS loader from libvirt XML file")
    public void testGetOsLoader() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm_uefi.xml");
        Assertions.assertEquals((Object)"/usr/share/edk2-ovmf/x64/OVMF_CODE.fd", (Object)vm.getOsLoader());
    }

    @Test
    @DisplayName(value="Set VM's OS loader in libvirt XML file")
    public void testSetOsLoader() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm_uefi.xml");
        vm.setOsLoader("/usr/share/qemu/edk2-x86_64-code.fd");
        Assertions.assertEquals((Object)"/usr/share/qemu/edk2-x86_64-code.fd", (Object)vm.getOsLoader());
    }

    @Test
    @DisplayName(value="Get VM's OS Nvram from libvirt XML file")
    public void testGetOsNvram() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm_uefi.xml");
        Assertions.assertEquals((Object)"/var/lib/libvirt/nvram/guest_VARS.fd", (Object)vm.getOsNvram());
    }

    @Test
    @DisplayName(value="Set VM's OS Nvram in libvirt XML file")
    public void testSetOsNvram() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm_uefi.xml");
        vm.setOsNvram("/tmp/nvram-tmp/tmp_VARS.fd");
        Assertions.assertEquals((Object)"/tmp/nvram-tmp/tmp_VARS.fd", (Object)vm.getOsNvram());
    }

    @Test
    @DisplayName(value="Get VM CPU model from libvirt XML file")
    public void testGetCpuModel() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        Assertions.assertNull((Object)vm.getCpuModel());
    }

    @Test
    @DisplayName(value="Set VM CPU model in libvirt XML file")
    public void testSetCpuModel() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        vm.setCpuModel("core2duo");
        Assertions.assertEquals((Object)"core2duo", (Object)vm.getCpuModel());
    }

    @Test
    @DisplayName(value="Get VM CPU mode from libvirt XML file")
    public void testGetCpuModelMode() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        Assertions.assertEquals((Object)Domain.CpuMode.HOST_MODEL.toString(), (Object)vm.getCpuMode().toString());
    }

    @Test
    @DisplayName(value="Set VM CPU mode in libvirt XML file")
    public void testSetCpuModelMode() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        vm.setCpuMode(Domain.CpuMode.HOST_PASSTHROUGH);
        Assertions.assertEquals((Object)Domain.CpuMode.HOST_PASSTHROUGH.toString(), (Object)vm.getCpuMode().toString());
    }

    @Test
    @DisplayName(value="Get VM CPU check from libvirt XML file")
    public void testGetCpuCheck() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        Assertions.assertEquals((Object)Domain.CpuCheck.PARTIAL.toString(), (Object)vm.getCpuCheck().toString());
    }

    @Test
    @DisplayName(value="Set VM CPU check in libvirt XML file")
    public void testSetCpuCheck() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        vm.setCpuCheck(Domain.CpuCheck.NONE);
        Assertions.assertEquals((Object)Domain.CpuCheck.NONE.toString(), (Object)vm.getCpuCheck().toString());
    }

    @Test
    @DisplayName(value="Get VM CPU dies from libvirt XML file")
    public void testGetCpuDies() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm_cpu-topology.xml");
        Assertions.assertEquals((int)2, (int)vm.getCpuDies());
    }

    @Test
    @DisplayName(value="Set VM CPU dies in libvirt XML file")
    public void testSetCpuDies() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm_cpu-topology.xml");
        vm.setCpuDies(3);
        Assertions.assertEquals((int)3, (int)vm.getCpuDies());
    }

    @Test
    @DisplayName(value="Get VM CPU sockets from libvirt XML file")
    public void testGetCpuSockets() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm_cpu-topology.xml");
        Assertions.assertEquals((int)3, (int)vm.getCpuSockets());
    }

    @Test
    @DisplayName(value="Set VM CPU sockets in libvirt XML file")
    public void testSetCpuSockets() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm_cpu-topology.xml");
        vm.setCpuSockets(2);
        Assertions.assertEquals((int)2, (int)vm.getCpuSockets());
    }

    @Test
    @DisplayName(value="Get VM CPU cores from libvirt XML file")
    public void testGetCpuCores() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm_cpu-topology.xml");
        Assertions.assertEquals((int)4, (int)vm.getCpuCores());
    }

    @Test
    @DisplayName(value="Set VM CPU cores in libvirt XML file")
    public void testSetCpuCores() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm_cpu-topology.xml");
        vm.setCpuCores(8);
        Assertions.assertEquals((int)8, (int)vm.getCpuCores());
    }

    @Test
    @DisplayName(value="Get VM CPU threads from libvirt XML file")
    public void testGetCpuThreads() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm_cpu-topology.xml");
        Assertions.assertEquals((int)1, (int)vm.getCpuThreads());
    }

    @Test
    @DisplayName(value="Set VM CPU threads in libvirt XML file")
    public void testSetCpuThreads() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm_cpu-topology.xml");
        vm.setCpuThreads(2);
        Assertions.assertEquals((int)2, (int)vm.getCpuThreads());
    }

    @Test
    @DisplayName(value="Get VM emulator binary from libvirt XML file")
    public void testGetDevicesEmulator() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        Assertions.assertEquals((Object)"/usr/bin/qemu-system-x86_64", (Object)vm.getDevicesEmulator());
    }

    @Test
    @DisplayName(value="Set VM emulator binary in libvirt XML file")
    public void testSetDevicesEmulator() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        vm.setDevicesEmulator("/usr/bin/qemu-system-i386");
        Assertions.assertEquals((Object)"/usr/bin/qemu-system-i386", (Object)vm.getDevicesEmulator());
    }

    @Test
    @DisplayName(value="Get all VM devices from libvirt XML file")
    public void testGetDevices() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        Assertions.assertEquals((int)33, (int)vm.getDevices().size());
    }

    @Test
    @DisplayName(value="Get all VM controller devices from libvirt XML file")
    public void testGetControllerDevices() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        Assertions.assertEquals((int)14, (int)vm.getControllerDevices().size());
    }

    @Test
    @DisplayName(value="Get all VM disk devices from libvirt XML file")
    public void testGetDiskDevices() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        Assertions.assertEquals((int)3, (int)vm.getDiskDevices().size());
    }

    @Test
    @DisplayName(value="Get all VM file system devices from libvirt XML file")
    public void testGetFileSystemDevices() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        Assertions.assertEquals((int)0, (int)vm.getFileSystemDevices().size());
    }

    @Test
    @DisplayName(value="Get all VM hostdev devices from libvirt XML file")
    public void testGetHostdevDevices() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        Assertions.assertEquals((int)0, (int)vm.getHostdevDevices().size());
    }

    @Test
    @DisplayName(value="Get all VM interface devices from libvirt XML file")
    public void testGetInterfaceDevices() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        Assertions.assertEquals((int)1, (int)vm.getInterfaceDevices().size());
    }

    @Test
    @DisplayName(value="Get all VM graphic devices from libvirt XML file")
    public void testGetGraphicDevices() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        Assertions.assertEquals((int)1, (int)vm.getGraphicDevices().size());
    }

    @Test
    @DisplayName(value="Get all VM parallel port devices from libvirt XML file")
    public void testGetParallelDevices() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        Assertions.assertEquals((int)0, (int)vm.getParallelDevices().size());
    }

    @Test
    @DisplayName(value="Get all VM serial port devices from libvirt XML file")
    public void testGetSerialDevices() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        Assertions.assertEquals((int)1, (int)vm.getSerialDevices().size());
    }

    @Test
    @DisplayName(value="Get all VM sound devices from libvirt XML file")
    public void testGetSoundDevices() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        Assertions.assertEquals((int)1, (int)vm.getSoundDevices().size());
    }

    @Test
    @DisplayName(value="Get all VM video devices from libvirt XML file")
    public void testGetVideoDevices() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        Assertions.assertEquals((int)1, (int)vm.getVideoDevices().size());
    }

    @Test
    @DisplayName(value="Get all Redir devices from libvirt XML file")
    public void testGetRedirDevices() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        Assertions.assertEquals((int)2, (int)vm.getRedirectDevices().size());
    }

    @Test
    @DisplayName(value="Get all QEMU command line arguments from libvirt XML file")
    public void testGetQemuCmdlnArguments() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm_qemu-cmdln.xml");
        Assertions.assertEquals((int)2, (int)vm.getQemuCmdlnArguments().size());
    }

    @Test
    @DisplayName(value="Set QEMU command line arguments in libvirt XML file")
    public void testAddQemuCmdlnArguments() {
        Domain vm = DomainTest.getDomain("qemu-kvm_default-ubuntu-20-04-vm.xml");
        Assertions.assertEquals((int)0, (int)vm.getQemuCmdlnArguments().size());
        vm.addQemuCmdlnArgument("-set");
        vm.addQemuCmdlnArgument("device.hostdev0.x-igd-opregion=on");
        Assertions.assertEquals((int)2, (int)vm.getQemuCmdlnArguments().size());
    }
}

