/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.libvirt.domain.device;

import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.openslx.libvirt.domain.device.HostdevMdevDeviceAddress;

public class HostdevMdevDeviceAddressTest {
    @Test
    @DisplayName(value="Test that a mediated device address instance is parsed from a valid String")
    public void testHostdevMdevDeviceAddressValueOfValid() {
        UUID deviceAddress = UUID.randomUUID();
        HostdevMdevDeviceAddress mdevDeviceAddr = HostdevMdevDeviceAddress.valueOf((String)deviceAddress.toString());
        Assertions.assertNotNull((Object)mdevDeviceAddr);
        Assertions.assertEquals((Object)deviceAddress, (Object)mdevDeviceAddr.getDeviceAddress());
        Assertions.assertEquals((Object)deviceAddress.toString(), (Object)mdevDeviceAddr.getDeviceAddressAsString());
    }

    @Test
    @DisplayName(value="Test that no mediated device address instance is parsed from an invalid String")
    public void testHostdevMdevDeviceAddressValueOfInvalid() {
        HostdevMdevDeviceAddress mdevDeviceAddr = HostdevMdevDeviceAddress.valueOf((String)"0xaffe");
        Assertions.assertNull((Object)mdevDeviceAddr);
    }

    @Test
    @DisplayName(value="Test that two mediated device address instances are equal")
    public void testHostdevMdevDeviceAddressEquals() {
        HostdevMdevDeviceAddress mdevDeviceAddr1 = new HostdevMdevDeviceAddress(new UUID(-559042562L, -1342251347L));
        HostdevMdevDeviceAddress mdevDeviceAddr2 = new HostdevMdevDeviceAddress(new UUID(-559042562L, -1342251347L));
        Assertions.assertTrue((boolean)mdevDeviceAddr1.equals((Object)mdevDeviceAddr2));
    }

    @Test
    @DisplayName(value="Test that two mediated device address instances are not equal")
    public void testHostdevMdevDeviceAddressNotEquals() {
        HostdevMdevDeviceAddress mdevDeviceAddr1 = new HostdevMdevDeviceAddress(new UUID(-559042562L, -1342251347L));
        HostdevMdevDeviceAddress mdevDeviceAddr2 = new HostdevMdevDeviceAddress(new UUID(-1342251347L, -559042562L));
        Assertions.assertFalse((boolean)mdevDeviceAddr1.equals((Object)mdevDeviceAddr2));
    }

    @Test
    @DisplayName(value="Test that a mediated device address can be dumped to a String")
    public void testHostdevMdevDeviceAddressToString() {
        UUID deviceAddr = UUID.randomUUID();
        HostdevMdevDeviceAddress mdevDeviceAddr = new HostdevMdevDeviceAddress(deviceAddr);
        Assertions.assertEquals((Object)deviceAddr.toString(), (Object)mdevDeviceAddr.toString());
    }
}

