/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.libvirt.domain.device;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.openslx.libvirt.domain.device.HostdevPciDeviceAddress;

public class HostdevPciDeviceAddressTest {
    @Test
    @DisplayName(value="Test that a PCI device address instance is not created if invalid values are specified")
    public void testHostdevPciDeviceAddressInstanceInvalid() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new HostdevPciDeviceAddress(Integer.MIN_VALUE, 3, 10, 7));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new HostdevPciDeviceAddress(29355, 12, 26, Integer.MAX_VALUE));
    }

    @Test
    @DisplayName(value="Test that a PCI device address instance is parsed from a valid String")
    public void testHostdevPciDeviceAddressValueOfValid() {
        HostdevPciDeviceAddress pciDeviceAddr = HostdevPciDeviceAddress.valueOf((String)"002b:2a:1f.1");
        Assertions.assertNotNull((Object)pciDeviceAddr);
        Assertions.assertEquals((int)43, (int)pciDeviceAddr.getPciDomain());
        Assertions.assertEquals((Object)"002b", (Object)pciDeviceAddr.getPciDomainAsString());
        Assertions.assertEquals((int)42, (int)pciDeviceAddr.getPciBus());
        Assertions.assertEquals((Object)"2a", (Object)pciDeviceAddr.getPciBusAsString());
        Assertions.assertEquals((int)31, (int)pciDeviceAddr.getPciDevice());
        Assertions.assertEquals((Object)"1f", (Object)pciDeviceAddr.getPciDeviceAsString());
        Assertions.assertEquals((int)1, (int)pciDeviceAddr.getPciFunction());
        Assertions.assertEquals((Object)"1", (Object)pciDeviceAddr.getPciFunctionAsString());
    }

    @Test
    @DisplayName(value="Test that no PCI device address instance is parsed from an invalid String")
    public void testHostdevPciDeviceAddressValueOfInvalid() {
        HostdevPciDeviceAddress pciDeviceAddr = HostdevPciDeviceAddress.valueOf((String)"0000b2ac1f31");
        Assertions.assertNull((Object)pciDeviceAddr);
    }

    @Test
    @DisplayName(value="Test that two PCI device address instances are equal")
    public void testHostdevPciDeviceAddressEquals() {
        HostdevPciDeviceAddress pciDeviceAddr1 = new HostdevPciDeviceAddress(0, 42, 31, 1);
        HostdevPciDeviceAddress pciDeviceAddr2 = new HostdevPciDeviceAddress(0, 42, 31, 1);
        Assertions.assertTrue((boolean)pciDeviceAddr1.equals((Object)pciDeviceAddr2));
    }

    @Test
    @DisplayName(value="Test that two PCI device address instances are not equal")
    public void testHostdevPciDeviceAddressNotEquals() {
        HostdevPciDeviceAddress pciDeviceAddr1 = new HostdevPciDeviceAddress(0, 42, 31, 1);
        HostdevPciDeviceAddress pciDeviceAddr2 = new HostdevPciDeviceAddress(0, 42, 31, 2);
        Assertions.assertFalse((boolean)pciDeviceAddr1.equals((Object)pciDeviceAddr2));
    }

    @Test
    @DisplayName(value="Test that a PCI device address can be dumped to a String")
    public void testHostdevPciDeviceAddressToString() {
        HostdevPciDeviceAddress pciDeviceAddr = new HostdevPciDeviceAddress(0, 42, 31, 1);
        Assertions.assertEquals((Object)"0000:2a:1f.1", (Object)pciDeviceAddr.toString());
    }
}

