/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.libvirt.domain.device;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.openslx.libvirt.domain.device.HostdevPciDeviceDescription;

public class HostdevPciDeviceDescriptionTest {
    @Test
    @DisplayName(value="Test that a PCI device description instance is not created if invalid values are specified")
    public void testHostdevPciDeviceDescriptionInstanceInvalid() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new HostdevPciDeviceDescription(Integer.MIN_VALUE, 10554));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new HostdevPciDeviceDescription(32902, Integer.MAX_VALUE));
    }

    @Test
    @DisplayName(value="Test that a PCI device description instance is parsed from a valid String")
    public void testHostdevPciDeviceDescriptionValueOfValid() {
        HostdevPciDeviceDescription pciDeviceDesc = HostdevPciDeviceDescription.valueOf((String)"8086:293a");
        Assertions.assertNotNull((Object)pciDeviceDesc);
        Assertions.assertEquals((int)32902, (int)pciDeviceDesc.getVendorId());
        Assertions.assertEquals((Object)"8086", (Object)pciDeviceDesc.getVendorIdAsString());
        Assertions.assertEquals((int)10554, (int)pciDeviceDesc.getDeviceId());
        Assertions.assertEquals((Object)"293a", (Object)pciDeviceDesc.getDeviceIdAsString());
    }

    @Test
    @DisplayName(value="Test that no PCI device description instance is parsed from an invalid String")
    public void testHostdevPciDeviceDescriptionValueOfInvalid() {
        HostdevPciDeviceDescription pciDeviceDesc = HostdevPciDeviceDescription.valueOf((String)"bba93e215");
        Assertions.assertNull((Object)pciDeviceDesc);
    }

    @Test
    @DisplayName(value="Test that two PCI device description instances are equal")
    public void testHostdevPciDeviceDescriptionEquals() {
        HostdevPciDeviceDescription pciDeviceDesc1 = new HostdevPciDeviceDescription(32902, 10554);
        HostdevPciDeviceDescription pciDeviceDesc2 = new HostdevPciDeviceDescription(32902, 10554);
        Assertions.assertTrue((boolean)pciDeviceDesc1.equals((Object)pciDeviceDesc2));
    }

    @Test
    @DisplayName(value="Test that two PCI device description instances are not equal")
    public void testHostdevPciDeviceDescriptionNotEquals() {
        HostdevPciDeviceDescription pciDeviceDesc1 = new HostdevPciDeviceDescription(32902, 10554);
        HostdevPciDeviceDescription pciDeviceDesc2 = new HostdevPciDeviceDescription(10554, 32902);
        Assertions.assertFalse((boolean)pciDeviceDesc1.equals((Object)pciDeviceDesc2));
    }

    @Test
    @DisplayName(value="Test that a PCI device description can be dumped to a String")
    public void testHostdevPciDeviceDescriptionToString() {
        HostdevPciDeviceDescription pciDeviceDesc = new HostdevPciDeviceDescription(177, 10554);
        Assertions.assertEquals((Object)"00b1:293a", (Object)pciDeviceDesc.toString());
    }
}

