/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.libvirt.libosinfo;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.openslx.libvirt.libosinfo.LibOsInfo;
import org.openslx.libvirt.libosinfo.os.Os;
import org.openslx.virtualization.Version;

public class LibOsInfoTest {
    @Test
    @DisplayName(value="Test the lookup of an operating system")
    public void testOsLookup() {
        String osId = "http://ubuntu.com/ubuntu/20.04";
        Os os = LibOsInfo.lookupOs((String)"http://ubuntu.com/ubuntu/20.04");
        Assertions.assertNotNull((Object)os);
        Assertions.assertEquals((Object)"http://ubuntu.com/ubuntu/20.04", (Object)os.getId());
        Assertions.assertEquals((Object)"Ubuntu 20.04", (Object)os.getName());
        Assertions.assertEquals((Object)"linux", (Object)os.getFamily());
        Assertions.assertEquals((Object)"ubuntu", (Object)os.getDistro());
        Assertions.assertEquals((Object)new Version(Short.valueOf("20").shortValue(), Short.valueOf("04").shortValue()), (Object)os.getVersion());
    }
}

