/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.libvirt.xml;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.openslx.libvirt.xml.LibvirtXmlDocument;
import org.openslx.libvirt.xml.LibvirtXmlDocumentException;
import org.openslx.libvirt.xml.LibvirtXmlDocumentStub;
import org.openslx.libvirt.xml.LibvirtXmlResources;
import org.openslx.libvirt.xml.LibvirtXmlSerializationException;
import org.openslx.libvirt.xml.LibvirtXmlTestResources;
import org.openslx.libvirt.xml.LibvirtXmlValidationException;

public class LibvirtXmlDocumentTest {
    private static final String EMPTY = new String();

    @BeforeAll
    public static void setUp() {
        Configurator.setRootLevel((Level)Level.OFF);
    }

    private LibvirtXmlDocument newLibvirtXmlDocumentInstance(String xmlFileName) {
        LibvirtXmlDocumentStub document = null;
        try {
            File xmlFile = LibvirtXmlTestResources.getLibvirtXmlFile(xmlFileName);
            document = new LibvirtXmlDocumentStub(xmlFile);
        }
        catch (LibvirtXmlDocumentException | LibvirtXmlSerializationException | LibvirtXmlValidationException e) {
            String errorMsg = new String("Cannot prepare requested Libvirt XML file from the resources folder");
            Assertions.fail((String)errorMsg);
        }
        return document;
    }

    private LibvirtXmlDocument newLibvirtXmlDocumentValidationInstance(String xmlFileName, String rngSchemaFileName) throws LibvirtXmlValidationException {
        LibvirtXmlDocumentStub document = null;
        try {
            File xmlFile = LibvirtXmlTestResources.getLibvirtXmlFile(xmlFileName);
            InputStream rngSchema = LibvirtXmlResources.getLibvirtRng((String)rngSchemaFileName);
            document = new LibvirtXmlDocumentStub(xmlFile, rngSchema);
        }
        catch (LibvirtXmlDocumentException | LibvirtXmlSerializationException e) {
            String errorMsg = new String("Cannot prepare requested Libvirt XML file from the resources folder");
            Assertions.fail((String)errorMsg);
        }
        return document;
    }

    private static long countLines(Reader input) throws IOException {
        BufferedReader bfrContent = new BufferedReader(input);
        return bfrContent.lines().count();
    }

    public static long countLinesFromString(String input) throws IOException {
        return LibvirtXmlDocumentTest.countLines(new StringReader(input));
    }

    public static long countLinesFromFile(File input) throws IOException {
        return LibvirtXmlDocumentTest.countLines(new FileReader(input));
    }

    @Test
    @DisplayName(value="Read libvirt XML file to String")
    public void testReadXmlFileToString() throws LibvirtXmlSerializationException, IOException {
        LibvirtXmlDocument vm = this.newLibvirtXmlDocumentInstance("qemu-kvm_default-ubuntu-20-04-vm.xml");
        File originalXmlFile = LibvirtXmlTestResources.getLibvirtXmlFile("qemu-kvm_default-ubuntu-20-04-vm.xml");
        String readXmlContent = vm.toXml();
        Assertions.assertNotNull((Object)readXmlContent);
        long lengthReadXmlContent = LibvirtXmlDocumentTest.countLinesFromString(readXmlContent);
        long lengthOriginalXmlContent = LibvirtXmlDocumentTest.countLinesFromFile(originalXmlFile);
        Assertions.assertEquals((long)lengthOriginalXmlContent, (long)lengthReadXmlContent);
    }

    @Test
    @DisplayName(value="Read libvirt XML file to file")
    public void testReadXmlFileToFile() throws LibvirtXmlSerializationException, IOException {
        LibvirtXmlDocument vm = this.newLibvirtXmlDocumentInstance("qemu-kvm_default-ubuntu-20-04-vm.xml");
        File originalXmlFile = LibvirtXmlTestResources.getLibvirtXmlFile("qemu-kvm_default-ubuntu-20-04-vm.xml");
        File readXmlFile = LibvirtXmlTestResources.createLibvirtXmlTempFile();
        vm.toXml(readXmlFile);
        String readXmlContent = FileUtils.readFileToString((File)readXmlFile, (Charset)StandardCharsets.UTF_8);
        String originalXmlContent = FileUtils.readFileToString((File)originalXmlFile, (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)readXmlContent);
        long lengthReadXmlContent = LibvirtXmlDocumentTest.countLinesFromString(readXmlContent);
        long lengthOriginalXmlContent = LibvirtXmlDocumentTest.countLinesFromString(originalXmlContent);
        Assertions.assertEquals((long)lengthOriginalXmlContent, (long)lengthReadXmlContent);
    }

    @Test
    @DisplayName(value="Validate correct libvirt XML file")
    public void testValidateCorrectXmlFile() {
        Executable validateXmlDocument = () -> this.newLibvirtXmlDocumentValidationInstance("qemu-kvm_default-ubuntu-20-04-vm.xml", "domain.rng");
        Assertions.assertDoesNotThrow((Executable)validateXmlDocument);
    }

    @Test
    @DisplayName(value="Validate incorrect libvirt XML file")
    public void testValidateIncorrectXmlFile() {
        Executable validateXmlDocument = () -> {
            LibvirtXmlDocument doc = this.newLibvirtXmlDocumentValidationInstance("qemu-kvm_default-ubuntu-20-04-vm-invalid.xml", "domain.rng");
            doc.validateXml();
        };
        Assertions.assertThrows(LibvirtXmlValidationException.class, (Executable)validateXmlDocument);
    }

    @Test
    @DisplayName(value="Get non-existent node from libvirt XML file")
    public void testGetNonExistentElement() {
        LibvirtXmlDocument vm = this.newLibvirtXmlDocumentInstance("qemu-kvm_default-ubuntu-20-04-vm.xml");
        Assertions.assertNull((Object)vm.getRootXmlNode().getXmlElement("info"));
    }

    @Test
    @DisplayName(value="Set non-existent node in libvirt XML file")
    public void testSetNonExistentElement() {
        LibvirtXmlDocument vm = this.newLibvirtXmlDocumentInstance("qemu-kvm_default-ubuntu-20-04-vm.xml");
        vm.getRootXmlNode().setXmlElement("info");
        Assertions.assertNotNull((Object)vm.getRootXmlNode().getXmlElement("info"));
    }

    @Test
    @DisplayName(value="Get non-existent element's value in libvirt XML file")
    public void testGetNonExistentElementValue() {
        LibvirtXmlDocument vm = this.newLibvirtXmlDocumentInstance("qemu-kvm_default-ubuntu-20-04-vm.xml");
        Assertions.assertNull((Object)vm.getRootXmlNode().getXmlElementValue("info"));
    }

    @Test
    @DisplayName(value="Set non-existent element's value in libvirt XML file")
    public void testSetNonExistentElementValue() {
        LibvirtXmlDocument vm = this.newLibvirtXmlDocumentInstance("qemu-kvm_default-ubuntu-20-04-vm.xml");
        vm.getRootXmlNode().setXmlElementValue("info", "content");
        Assertions.assertEquals((Object)"content", (Object)vm.getRootXmlNode().getXmlElementValue("info"));
    }

    @Test
    @DisplayName(value="Get empty element from libvirt XML file")
    public void testGetEmptyElement() {
        LibvirtXmlDocument vm = this.newLibvirtXmlDocumentInstance("qemu-kvm_default-ubuntu-20-04-vm.xml");
        Assertions.assertNotNull((Object)vm.getRootXmlNode().getXmlElement("features/acpi"));
    }

    @Test
    @DisplayName(value="Set empty element in libvirt XML file")
    public void testSetEmptyElement() {
        LibvirtXmlDocument vm = this.newLibvirtXmlDocumentInstance("qemu-kvm_default-ubuntu-20-04-vm.xml");
        vm.getRootXmlNode().setXmlElement("features/acpi");
        Assertions.assertNotNull((Object)vm.getRootXmlNode().getXmlElement("features/acpi"));
    }

    @Test
    @DisplayName(value="Get empty element's value from libvirt XML file")
    public void testGetEmptyElementValue() {
        LibvirtXmlDocument vm = this.newLibvirtXmlDocumentInstance("qemu-kvm_default-ubuntu-20-04-vm.xml");
        Assertions.assertEquals((Object)EMPTY, (Object)vm.getRootXmlNode().getXmlElementValue("features/acpi"));
    }

    @Test
    @DisplayName(value="Set empty element's value in libvirt XML file")
    public void testSetEmptyElementValue() {
        LibvirtXmlDocument vm = this.newLibvirtXmlDocumentInstance("qemu-kvm_default-ubuntu-20-04-vm.xml");
        vm.getRootXmlNode().setXmlElementValue("features/acpi", "content");
        Assertions.assertEquals((Object)"content", (Object)vm.getRootXmlNode().getXmlElementValue("features/acpi"));
    }

    @Test
    @DisplayName(value="Get non-existent element's attribute value from libvirt XML file")
    public void testGetNonExistentElementAttributeValue() {
        LibvirtXmlDocument vm = this.newLibvirtXmlDocumentInstance("qemu-kvm_default-ubuntu-20-04-vm.xml");
        Assertions.assertNull((Object)vm.getRootXmlNode().getXmlElementAttributeValue("info", "test"));
    }

    @Test
    @DisplayName(value="Set non-existent element's attribute value from libvirt XML file")
    public void testSetNonExistentElementAttributeValue() {
        LibvirtXmlDocument vm = this.newLibvirtXmlDocumentInstance("qemu-kvm_default-ubuntu-20-04-vm.xml");
        vm.getRootXmlNode().setXmlElementAttributeValue("info", "test", "info");
        Assertions.assertEquals((Object)"info", (Object)vm.getRootXmlNode().getXmlElementAttributeValue("info", "test"));
    }

    @Test
    @DisplayName(value="Get element's non-existent attribute value from libvirt XML file")
    public void testGetElementNonExistentAttributeValue() {
        LibvirtXmlDocument vm = this.newLibvirtXmlDocumentInstance("qemu-kvm_default-ubuntu-20-04-vm.xml");
        Assertions.assertNull((Object)vm.getRootXmlNode().getXmlElementAttributeValue("features/acpi", "test"));
    }

    @Test
    @DisplayName(value="Set element's non-existent attribute value from libvirt XML file")
    public void testSetElementNonExistentAttributeValue() {
        LibvirtXmlDocument vm = this.newLibvirtXmlDocumentInstance("qemu-kvm_default-ubuntu-20-04-vm.xml");
        vm.getRootXmlNode().setXmlElementAttributeValue("features/acpi", "test", "info");
        Assertions.assertEquals((Object)"info", (Object)vm.getRootXmlNode().getXmlElementAttributeValue("features/acpi", "test"));
    }

    @Test
    @DisplayName(value="Get element's attribute value from libvirt XML file")
    public void testGetElementAttributeValue() {
        LibvirtXmlDocument vm = this.newLibvirtXmlDocumentInstance("qemu-kvm_default-ubuntu-20-04-vm.xml");
        Assertions.assertEquals((Object)"partial", (Object)vm.getRootXmlNode().getXmlElementAttributeValue("cpu", "check"));
    }

    @Test
    @DisplayName(value="Set element's attribute value from libvirt XML file")
    public void testSetElementAttributeValue() {
        LibvirtXmlDocument vm = this.newLibvirtXmlDocumentInstance("qemu-kvm_default-ubuntu-20-04-vm.xml");
        vm.getRootXmlNode().setXmlElementAttributeValue("cpu", "check", "full");
        Assertions.assertEquals((Object)"full", (Object)vm.getRootXmlNode().getXmlElementAttributeValue("cpu", "check"));
    }
}

