/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.openslx.util.TarArchiveUtil;

public class TarArchiveUtilTest {
    @Test
    @DisplayName(value="Test creating tgz file")
    public void testCreateTarGz() throws IOException {
        String DUMMY_FILENAME = "test";
        String DUMMY_FILE_DATA = "Hello World";
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TarArchiveUtil.TarArchiveWriter tarArchiveWriter = new TarArchiveUtil.TarArchiveWriter((OutputStream)out);
        tarArchiveWriter.writeFile("test", "Hello World");
        tarArchiveWriter.close();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        TarArchiveUtil.TarArchiveReader tarArchiveReader = new TarArchiveUtil.TarArchiveReader((InputStream)in, true, true);
        Assertions.assertTrue((boolean)tarArchiveReader.hasNextEntry(), (String)"Tar Archive should contain a file");
        Assertions.assertEquals((Object)"test", (Object)tarArchiveReader.getEntryName());
        String test_string = new String(tarArchiveReader.readCurrentEntry(), StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"Hello World", (Object)test_string);
        tarArchiveReader.close();
    }
}

