/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.virtualization;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.openslx.virtualization.Version;

public class VersionTest {
    @Test
    @DisplayName(value="Test that version is supported in list of versions")
    public void testVersionIsSupported() {
        Version version = new Version(Short.valueOf("2").shortValue(), Short.valueOf("3").shortValue());
        List<Version> versions = Collections.unmodifiableList(Arrays.asList(new Version(Short.valueOf("2").shortValue()), new Version(Short.valueOf("4").shortValue(), Short.valueOf("3").shortValue()), new Version(Short.valueOf("2").shortValue(), Short.valueOf("3").shortValue()), new Version(Short.valueOf("1").shortValue(), Short.valueOf("3").shortValue())));
        Assertions.assertTrue((boolean)version.isSupported(versions));
    }

    @Test
    @DisplayName(value="Test that version is not supported in list of versions")
    public void testVersionIsNotSupported() {
        Version version = new Version(Short.valueOf("2").shortValue(), Short.valueOf("3").shortValue());
        List<Version> versions = Collections.unmodifiableList(Arrays.asList(new Version(Short.valueOf("2").shortValue()), new Version(Short.valueOf("4").shortValue(), Short.valueOf("3").shortValue()), new Version(Short.valueOf("6").shortValue(), Short.valueOf("9").shortValue()), new Version(Short.valueOf("1").shortValue(), Short.valueOf("3").shortValue())));
        Assertions.assertFalse((boolean)version.isSupported(versions));
    }

    @Test
    @DisplayName(value="Test that new version from String is valid")
    public void testVersionValueOfValid() {
        Assertions.assertEquals((Object)new Version(Short.valueOf("52").shortValue()), (Object)Version.valueOf((String)"52"));
        Assertions.assertEquals((Object)new Version(Short.valueOf("1").shortValue(), Short.valueOf("34").shortValue()), (Object)Version.valueOf((String)"1.34"));
    }

    @Test
    @DisplayName(value="Test that new version from String is invalid")
    public void testVersionValueOfInvalid() {
        Assertions.assertNull((Object)Version.valueOf((String)"52."));
        Assertions.assertNull((Object)Version.valueOf((String)"1.34-release"));
    }

    @Test
    @DisplayName(value="Test that versions are equal")
    public void testVersionEquals() {
        Version versionOne = new Version(Short.valueOf("2").shortValue(), Short.valueOf("3").shortValue());
        Version versionTwo = new Version(Short.valueOf("2").shortValue(), Short.valueOf("3").shortValue());
        Assertions.assertTrue((boolean)versionOne.equals((Object)versionTwo));
        Assertions.assertTrue((boolean)versionTwo.equals((Object)versionOne));
    }

    @Test
    @DisplayName(value="Test that versions are not equal")
    public void testVersionNotEquals() {
        Version versionOne = new Version(Short.valueOf("3").shortValue(), Short.valueOf("2").shortValue());
        Version versionTwo = new Version(Short.valueOf("3").shortValue(), Short.valueOf("3").shortValue());
        Assertions.assertFalse((boolean)versionOne.equals((Object)versionTwo));
        Assertions.assertFalse((boolean)versionTwo.equals((Object)versionOne));
    }

    @Test
    @DisplayName(value="Test that version is smaller than")
    public void testVersionSmallerThan() {
        Version versionOne = new Version(Short.valueOf("2").shortValue(), Short.valueOf("3").shortValue());
        Version versionTwo = new Version(Short.valueOf("3").shortValue(), Short.valueOf("2").shortValue());
        Assertions.assertEquals((int)-1, (int)versionOne.compareTo(versionTwo));
        Assertions.assertEquals((int)1, (int)versionTwo.compareTo(versionOne));
    }

    @Test
    @DisplayName(value="Test that version is smaller than with helper method")
    public void testVersionSmallerThanMethod() {
        Version versionOne = new Version(Short.valueOf("2").shortValue(), Short.valueOf("3").shortValue());
        Version versionTwo = new Version(Short.valueOf("3").shortValue(), Short.valueOf("2").shortValue());
        Assertions.assertTrue((boolean)versionOne.isSmallerThan(versionTwo));
        Assertions.assertFalse((boolean)versionTwo.isSmallerThan(versionOne));
    }

    @Test
    @DisplayName(value="Test that version is greater than")
    public void testVersionGreaterThan() {
        Version versionOne = new Version(Short.valueOf("3").shortValue(), Short.valueOf("3").shortValue());
        Version versionTwo = new Version(Short.valueOf("3").shortValue(), Short.valueOf("2").shortValue());
        Assertions.assertEquals((int)1, (int)versionOne.compareTo(versionTwo));
        Assertions.assertEquals((int)-1, (int)versionTwo.compareTo(versionOne));
    }

    @Test
    @DisplayName(value="Test that version is greater than with helper method")
    public void testVersionGreaterThanMethod() {
        Version versionOne = new Version(Short.valueOf("3").shortValue(), Short.valueOf("3").shortValue());
        Version versionTwo = new Version(Short.valueOf("3").shortValue(), Short.valueOf("2").shortValue());
        Assertions.assertTrue((boolean)versionOne.isGreaterThan(versionTwo));
        Assertions.assertFalse((boolean)versionTwo.isGreaterThan(versionOne));
    }

    @Test
    @DisplayName(value="Test that versions are equal (compareTo)")
    public void testVersionEqualCompareTo() {
        Version versionOne = new Version(Short.valueOf("2").shortValue(), Short.valueOf("3").shortValue());
        Version versionTwo = new Version(Short.valueOf("2").shortValue(), Short.valueOf("3").shortValue());
        Assertions.assertEquals((int)0, (int)versionOne.compareTo(versionTwo));
        Assertions.assertEquals((int)0, (int)versionTwo.compareTo(versionOne));
    }
}

