/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.virtualization.configuration;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.openslx.bwlp.thrift.iface.OperatingSystem;
import org.openslx.libvirt.domain.Domain;
import org.openslx.libvirt.domain.device.DiskCdrom;
import org.openslx.libvirt.domain.device.DiskFloppy;
import org.openslx.libvirt.domain.device.DiskStorage;
import org.openslx.libvirt.domain.device.Interface;
import org.openslx.libvirt.xml.LibvirtXmlDocumentTest;
import org.openslx.libvirt.xml.LibvirtXmlTestResources;
import org.openslx.virtualization.Version;
import org.openslx.virtualization.configuration.VirtualizationConfiguration;
import org.openslx.virtualization.configuration.VirtualizationConfigurationException;
import org.openslx.virtualization.configuration.VirtualizationConfigurationQemu;
import org.openslx.virtualization.configuration.logic.ConfigurationLogicTestUtils;
import org.openslx.virtualization.disk.DiskImage;
import org.openslx.virtualization.disk.DiskImageTestResources;
import org.openslx.virtualization.hardware.ConfigurationGroups;

public class VirtualizationConfigurationQemuTest {
    public static final List<OperatingSystem> STUB_OS_LIST = ConfigurationLogicTestUtils.STUB_OS_LIST;

    private static Domain getPrivateDomainFromQemuMetaData(VirtualizationConfigurationQemu qemuMetadata) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field privateDomainField = VirtualizationConfigurationQemu.class.getDeclaredField("vmConfig");
        privateDomainField.setAccessible(true);
        return (Domain)Domain.class.cast(privateDomainField.get(qemuMetadata));
    }

    @BeforeAll
    public static void setUp() {
        Configurator.setRootLevel((Level)Level.OFF);
    }

    @Test
    @DisplayName(value="Test display name from VM configuration")
    public void testQemuMetaDataGetDisplayName() throws VirtualizationConfigurationException, IOException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        File file = LibvirtXmlTestResources.getLibvirtXmlFile("qemu-kvm_default-archlinux-vm.xml");
        VirtualizationConfigurationQemu vmConfig = new VirtualizationConfigurationQemu(null, file);
        String displayName = vmConfig.getDisplayName();
        Assertions.assertEquals((Object)"archlinux", (Object)displayName);
        Assertions.assertDoesNotThrow(() -> vmConfig.validate());
    }

    @Test
    @DisplayName(value="Test machine snapshot state from VM configuration")
    public void testQemuMetaDataIsMachineSnapshot() throws VirtualizationConfigurationException, IOException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        File file = LibvirtXmlTestResources.getLibvirtXmlFile("qemu-kvm_default-archlinux-vm.xml");
        VirtualizationConfigurationQemu vmConfig = new VirtualizationConfigurationQemu(null, file);
        boolean isVmSnapshot = vmConfig.isMachineSnapshot();
        Assertions.assertEquals((Object)false, (Object)isVmSnapshot);
        Assertions.assertDoesNotThrow(() -> vmConfig.validate());
    }

    @Test
    @DisplayName(value="Test supported image formats from VM configuration")
    public void testQemuMetaDataGetSupportedImageFormats() throws VirtualizationConfigurationException, IOException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        File file = LibvirtXmlTestResources.getLibvirtXmlFile("qemu-kvm_default-archlinux-vm.xml");
        VirtualizationConfigurationQemu vmConfig = new VirtualizationConfigurationQemu(null, file);
        List supportedImageFormats = vmConfig.getVirtualizer().getSupportedImageFormats();
        Assertions.assertNotNull((Object)supportedImageFormats);
        Assertions.assertEquals((int)3, (int)supportedImageFormats.size());
        Assertions.assertEquals((Object)true, (Object)supportedImageFormats.containsAll(Arrays.asList(DiskImage.ImageFormat.QCOW2, DiskImage.ImageFormat.VMDK, DiskImage.ImageFormat.VDI)));
        Assertions.assertDoesNotThrow(() -> vmConfig.validate());
    }

    @Test
    @DisplayName(value="Test output of detected 32-bit OS from VM configuration")
    public void testQemuMetaDataGetOs32Bit() throws VirtualizationConfigurationException, IOException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        File file = LibvirtXmlTestResources.getLibvirtXmlFile("qemu-kvm_default-ubuntu-20-04-vm_i686.xml");
        VirtualizationConfigurationQemu vmConfig = new VirtualizationConfigurationQemu(STUB_OS_LIST, file);
        OperatingSystem os = vmConfig.getOs();
        Assertions.assertNotNull((Object)os);
        Assertions.assertEquals((Object)STUB_OS_LIST.get(3), (Object)os);
        Assertions.assertDoesNotThrow(() -> vmConfig.validate());
    }

    @Test
    @DisplayName(value="Test output of detected 64-bit OS from VM configuration")
    public void testQemuMetaDataGetOs64Bit() throws VirtualizationConfigurationException, IOException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        File file = LibvirtXmlTestResources.getLibvirtXmlFile("qemu-kvm_default-ubuntu-20-04-vm.xml");
        VirtualizationConfigurationQemu vmConfig = new VirtualizationConfigurationQemu(STUB_OS_LIST, file);
        OperatingSystem os = vmConfig.getOs();
        Assertions.assertNotNull((Object)os);
        Assertions.assertEquals((Object)STUB_OS_LIST.get(4), (Object)os);
        Assertions.assertDoesNotThrow(() -> vmConfig.validate());
    }

    @Test
    @DisplayName(value="Test output of HDDs from VM configuration")
    public void testQemuMetaDataGetHdds() throws VirtualizationConfigurationException, IOException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        File file = LibvirtXmlTestResources.getLibvirtXmlFile("qemu-kvm_default-archlinux-vm.xml");
        VirtualizationConfigurationQemu vmConfig = new VirtualizationConfigurationQemu(null, file);
        List hdds = vmConfig.getHdds();
        Assertions.assertNotNull((Object)hdds);
        Assertions.assertEquals((int)1, (int)hdds.size());
        Assertions.assertEquals((Object)"/var/lib/libvirt/images/archlinux.qcow2", (Object)((VirtualizationConfiguration.HardDisk)hdds.get((int)0)).diskImage);
        Assertions.assertDoesNotThrow(() -> vmConfig.validate());
    }

    @Test
    @DisplayName(value="Test output of unfiltered VM configuration")
    public void testQemuMetaDataGetDefinitionArray() throws VirtualizationConfigurationException, IOException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        File file = LibvirtXmlTestResources.getLibvirtXmlFile("qemu-kvm_default-archlinux-vm.xml");
        VirtualizationConfigurationQemu vmConfig = new VirtualizationConfigurationQemu(null, file);
        String unfilteredXmlConfig = new String(vmConfig.getConfigurationAsByteArray(), StandardCharsets.UTF_8);
        String originalXmlConfig = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)unfilteredXmlConfig);
        long lengthUnfilteredXmlConfig = LibvirtXmlDocumentTest.countLinesFromString(unfilteredXmlConfig);
        long lengthOriginalXmlConfig = LibvirtXmlDocumentTest.countLinesFromString(originalXmlConfig);
        Assertions.assertEquals((long)lengthOriginalXmlConfig, (long)lengthUnfilteredXmlConfig);
        Assertions.assertDoesNotThrow(() -> vmConfig.validate());
    }

    @ParameterizedTest
    @DisplayName(value="Test add HDD to VM configuration")
    @ValueSource(strings={"qemu-kvm_default-archlinux-vm.xml", "qemu-kvm_default-archlinux-vm-no-hdd.xml"})
    public void testQemuMetaDataAddHdd(String xmlFileName) throws VirtualizationConfigurationException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        File diskFile = DiskImageTestResources.getDiskFile("image-default.qcow2");
        File file = LibvirtXmlTestResources.getLibvirtXmlFile(xmlFileName);
        VirtualizationConfigurationQemu vmConfig = new VirtualizationConfigurationQemu(null, file);
        Domain vmLibvirtDomainConfig = VirtualizationConfigurationQemuTest.getPrivateDomainFromQemuMetaData(vmConfig);
        int numHddsLibvirtDomainXmlBeforeAdd = vmLibvirtDomainConfig.getDiskStorageDevices().size();
        int numHddsQemuMetaDataBeforeAdd = vmConfig.getHdds().size();
        vmConfig.addHddTemplate(diskFile, null, null);
        int numHddsLibvirtDomainXmlAfterAdd = vmLibvirtDomainConfig.getDiskStorageDevices().size();
        int numHddsQemuMetaDataAfterAdd = vmConfig.getHdds().size();
        Assertions.assertTrue((numHddsLibvirtDomainXmlBeforeAdd == numHddsQemuMetaDataBeforeAdd ? 1 : 0) != 0);
        Assertions.assertTrue((numHddsLibvirtDomainXmlAfterAdd == numHddsQemuMetaDataAfterAdd ? 1 : 0) != 0);
        Assertions.assertTrue((numHddsQemuMetaDataBeforeAdd >= 0 ? 1 : 0) != 0);
        Assertions.assertTrue((numHddsQemuMetaDataAfterAdd > 0 ? 1 : 0) != 0);
        if (numHddsQemuMetaDataBeforeAdd >= 1) {
            Assertions.assertEquals((int)numHddsQemuMetaDataBeforeAdd, (int)numHddsQemuMetaDataAfterAdd);
        } else {
            Assertions.assertEquals((int)(numHddsQemuMetaDataBeforeAdd + 1), (int)numHddsQemuMetaDataAfterAdd);
        }
        DiskStorage addedStorageDevice = (DiskStorage)vmLibvirtDomainConfig.getDiskStorageDevices().get(0);
        Assertions.assertEquals((Object)diskFile.getAbsolutePath(), (Object)addedStorageDevice.getStorageSource());
        Assertions.assertDoesNotThrow(() -> vmConfig.validate());
    }

    @ParameterizedTest
    @DisplayName(value="Test add CDROM to VM configuration")
    @ValueSource(strings={"qemu-kvm_default-archlinux-vm.xml", "qemu-kvm_default-archlinux-vm-cdrom.xml"})
    public void testQemuMetaDataAddCdrom(String xmlFileName) throws VirtualizationConfigurationException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        File diskFile = DiskImageTestResources.getDiskFile("image-default.qcow2");
        File file = LibvirtXmlTestResources.getLibvirtXmlFile(xmlFileName);
        VirtualizationConfigurationQemu vmConfig = new VirtualizationConfigurationQemu(null, file);
        Domain vmLibvirtDomainConfig = VirtualizationConfigurationQemuTest.getPrivateDomainFromQemuMetaData(vmConfig);
        int numCdromsLibvirtDomainXmlBeforeAdd = vmLibvirtDomainConfig.getDiskCdromDevices().size();
        vmConfig.addCdrom(0, diskFile.getAbsolutePath());
        int numCdromsLibvirtDomainXmlAfterAdd = vmLibvirtDomainConfig.getDiskCdromDevices().size();
        Assertions.assertTrue((numCdromsLibvirtDomainXmlBeforeAdd >= 0 ? 1 : 0) != 0);
        Assertions.assertTrue((numCdromsLibvirtDomainXmlAfterAdd > 0 ? 1 : 0) != 0);
        DiskCdrom addedCdromDevice = (DiskCdrom)vmLibvirtDomainConfig.getDiskCdromDevices().get(0);
        Assertions.assertEquals((Object)diskFile.getAbsolutePath(), (Object)addedCdromDevice.getStorageSource());
        Assertions.assertDoesNotThrow(() -> vmConfig.validate());
    }

    @ParameterizedTest
    @DisplayName(value="Test add physical CDROM drive to VM configuration")
    @ValueSource(strings={"qemu-kvm_default-archlinux-vm.xml", "qemu-kvm_default-archlinux-vm-cdrom.xml"})
    public void testQemuMetaDataAddPhysicalCdromDrive(String xmlFileName) throws VirtualizationConfigurationException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        File file = LibvirtXmlTestResources.getLibvirtXmlFile(xmlFileName);
        VirtualizationConfigurationQemu vmConfig = new VirtualizationConfigurationQemu(null, file);
        Domain vmLibvirtDomainConfig = VirtualizationConfigurationQemuTest.getPrivateDomainFromQemuMetaData(vmConfig);
        int numCdromsLibvirtDomainXmlBeforeAdd = vmLibvirtDomainConfig.getDiskCdromDevices().size();
        vmConfig.addCdrom(0, null);
        int numCdromsLibvirtDomainXmlAfterAdd = vmLibvirtDomainConfig.getDiskCdromDevices().size();
        Assertions.assertTrue((numCdromsLibvirtDomainXmlBeforeAdd >= 0 ? 1 : 0) != 0);
        Assertions.assertTrue((numCdromsLibvirtDomainXmlAfterAdd > 0 ? 1 : 0) != 0);
        DiskCdrom addedCdromDevice = (DiskCdrom)vmLibvirtDomainConfig.getDiskCdromDevices().get(0);
        Assertions.assertEquals((Object)"/dev/sr0", (Object)addedCdromDevice.getStorageSource());
        Assertions.assertDoesNotThrow(() -> vmConfig.validate());
    }

    @ParameterizedTest
    @DisplayName(value="Test add floppy to VM configuration")
    @ValueSource(strings={"qemu-kvm_default-archlinux-vm.xml", "qemu-kvm_default-archlinux-vm-floppy.xml"})
    public void testQemuMetaDataAddFloppy(String xmlFileName) throws VirtualizationConfigurationException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        File diskFile = DiskImageTestResources.getDiskFile("image-default.qcow2");
        File file = LibvirtXmlTestResources.getLibvirtXmlFile(xmlFileName);
        VirtualizationConfigurationQemu vmConfig = new VirtualizationConfigurationQemu(null, file);
        Domain vmLibvirtDomainConfig = VirtualizationConfigurationQemuTest.getPrivateDomainFromQemuMetaData(vmConfig);
        int numFloppiesLibvirtDomainXmlBeforeAdd = vmLibvirtDomainConfig.getDiskFloppyDevices().size();
        vmConfig.addFloppy(0, diskFile.getAbsolutePath(), true);
        int numFloppiesLibvirtDomainXmlAfterAdd = vmLibvirtDomainConfig.getDiskFloppyDevices().size();
        Assertions.assertTrue((numFloppiesLibvirtDomainXmlBeforeAdd >= 0 ? 1 : 0) != 0);
        Assertions.assertTrue((numFloppiesLibvirtDomainXmlAfterAdd > 0 ? 1 : 0) != 0);
        DiskFloppy addedFloppyDevice = (DiskFloppy)vmLibvirtDomainConfig.getDiskFloppyDevices().get(0);
        Assertions.assertTrue((boolean)addedFloppyDevice.isReadOnly());
        Assertions.assertEquals((Object)diskFile.getAbsolutePath(), (Object)addedFloppyDevice.getStorageSource());
        Assertions.assertDoesNotThrow(() -> vmConfig.validate());
    }

    @ParameterizedTest
    @DisplayName(value="Test add CPU core count to VM configuration")
    @ValueSource(ints={2, 4, 6, 8})
    public void testQemuMetaDataAddCpuCoreCount(int coreCount) throws VirtualizationConfigurationException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        File file = LibvirtXmlTestResources.getLibvirtXmlFile("qemu-kvm_default-archlinux-vm.xml");
        VirtualizationConfigurationQemu vmConfig = new VirtualizationConfigurationQemu(null, file);
        Domain vmLibvirtDomainConfig = VirtualizationConfigurationQemuTest.getPrivateDomainFromQemuMetaData(vmConfig);
        vmConfig.addCpuCoreCount(coreCount);
        Assertions.assertEquals((int)coreCount, (int)vmLibvirtDomainConfig.getVCpu());
        Assertions.assertDoesNotThrow(() -> vmConfig.validate());
    }

    @ParameterizedTest
    @DisplayName(value="Test get ethernet device type from VM configuration")
    @ValueSource(strings={"qemu-kvm_default-archlinux-vm.xml", "qemu-kvm_default-archlinux-vm-no-nic.xml"})
    public void testQemuMetaDataGetEthernetDevType(String xmlFileName) throws VirtualizationConfigurationException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        File file = LibvirtXmlTestResources.getLibvirtXmlFile(xmlFileName);
        VirtualizationConfigurationQemu vmConfig = new VirtualizationConfigurationQemu(null, file);
        Domain vmLibvirtDomainConfig = VirtualizationConfigurationQemuTest.getPrivateDomainFromQemuMetaData(vmConfig);
        List groups = vmConfig.getConfigurableOptions();
        for (VirtualizationConfiguration.ConfigurableOptionGroup group : groups) {
            if (group.groupIdentifier != ConfigurationGroups.NIC_MODEL) continue;
            if (vmLibvirtDomainConfig.getInterfaceDevices().isEmpty()) {
                Assertions.assertEquals(null, (Object)group.getSelected());
                continue;
            }
            Assertions.assertEquals((Object)Interface.Model.VIRTIO.toString(), (Object)group.getSelected().getId());
        }
        Assertions.assertDoesNotThrow(() -> vmConfig.validate());
    }

    static Stream<Arguments> configAndEthernetTypeProvider() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{"qemu-kvm_default-archlinux-vm.xml", VirtualizationConfiguration.EtherType.BRIDGED}), Arguments.arguments((Object[])new Object[]{"qemu-kvm_default-archlinux-vm.xml", VirtualizationConfiguration.EtherType.HOST_ONLY}), Arguments.arguments((Object[])new Object[]{"qemu-kvm_default-archlinux-vm.xml", VirtualizationConfiguration.EtherType.NAT}), Arguments.arguments((Object[])new Object[]{"qemu-kvm_default-archlinux-vm-no-usb.xml", VirtualizationConfiguration.EtherType.BRIDGED}), Arguments.arguments((Object[])new Object[]{"qemu-kvm_default-archlinux-vm-no-usb.xml", VirtualizationConfiguration.EtherType.HOST_ONLY}), Arguments.arguments((Object[])new Object[]{"qemu-kvm_default-archlinux-vm-no-usb.xml", VirtualizationConfiguration.EtherType.NAT}));
    }

    @ParameterizedTest
    @DisplayName(value="Test add ethernet device to VM configuration")
    @MethodSource(value={"configAndEthernetTypeProvider"})
    public void testQemuMetaDataAddEthernet(String xmlFileName, VirtualizationConfiguration.EtherType ethernetType) throws VirtualizationConfigurationException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        File file = LibvirtXmlTestResources.getLibvirtXmlFile(xmlFileName);
        VirtualizationConfigurationQemu vmConfig = new VirtualizationConfigurationQemu(null, file);
        Domain vmLibvirtDomainConfig = VirtualizationConfigurationQemuTest.getPrivateDomainFromQemuMetaData(vmConfig);
        int numEthernetDevsLibvirtDomainXmlBeforeAdd = vmLibvirtDomainConfig.getInterfaceDevices().size();
        vmConfig.addEthernet(ethernetType);
        int numEthernetDevsLibvirtDomainXmlAfterAdd = vmLibvirtDomainConfig.getInterfaceDevices().size();
        Assertions.assertTrue((numEthernetDevsLibvirtDomainXmlBeforeAdd >= 0 ? 1 : 0) != 0);
        Assertions.assertTrue((numEthernetDevsLibvirtDomainXmlAfterAdd > 0 ? 1 : 0) != 0);
        Interface addedEthernetDevice = (Interface)vmLibvirtDomainConfig.getInterfaceDevices().get(0);
        switch (ethernetType) {
            case BRIDGED: {
                Assertions.assertEquals((Object)Interface.Type.BRIDGE, (Object)addedEthernetDevice.getType());
                Assertions.assertEquals((Object)Interface.Model.VIRTIO, (Object)addedEthernetDevice.getModel());
                Assertions.assertEquals((Object)"br0", (Object)addedEthernetDevice.getSource());
                break;
            }
            case HOST_ONLY: {
                Assertions.assertEquals((Object)Interface.Type.BRIDGE, (Object)addedEthernetDevice.getType());
                Assertions.assertEquals((Object)Interface.Model.VIRTIO, (Object)addedEthernetDevice.getModel());
                Assertions.assertEquals((Object)"vsw2", (Object)addedEthernetDevice.getSource());
                break;
            }
            case NAT: {
                Assertions.assertEquals((Object)Interface.Type.BRIDGE, (Object)addedEthernetDevice.getType());
                Assertions.assertEquals((Object)Interface.Model.VIRTIO, (Object)addedEthernetDevice.getModel());
                Assertions.assertEquals((Object)"nat1", (Object)addedEthernetDevice.getSource());
            }
        }
        Assertions.assertDoesNotThrow(() -> vmConfig.validate());
    }

    @ParameterizedTest
    @DisplayName(value="Test get virtualizer HW version from VM configuration")
    @ValueSource(strings={"qemu-kvm_default-archlinux-vm-old-os.xml", "qemu-kvm_default-archlinux-vm-no-os.xml"})
    public void testQemuMetaDataGetVirtualizerVersion(String xmlFileName) throws VirtualizationConfigurationException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        File file = LibvirtXmlTestResources.getLibvirtXmlFile(xmlFileName);
        VirtualizationConfigurationQemu vmConfig = new VirtualizationConfigurationQemu(null, file);
        Domain vmLibvirtDomainConfig = VirtualizationConfigurationQemuTest.getPrivateDomainFromQemuMetaData(vmConfig);
        Version machineVersion = vmConfig.getVirtualizerVersion();
        if (vmLibvirtDomainConfig.getOsMachine() == null) {
            Assertions.assertNull((Object)machineVersion);
        } else {
            Assertions.assertEquals((Object)new Version(Short.valueOf("3").shortValue(), Short.valueOf("1").shortValue()), (Object)machineVersion);
        }
        Assertions.assertDoesNotThrow(() -> vmConfig.validate());
    }

    @ParameterizedTest
    @DisplayName(value="Test set virtualizer HW version in VM configuration")
    @ValueSource(strings={"qemu-kvm_default-archlinux-vm-old-os.xml", "qemu-kvm_default-archlinux-vm-no-os.xml"})
    public void testQemuMetaDataSetVirtualizerVersion(String xmlFileName) throws VirtualizationConfigurationException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        File file = LibvirtXmlTestResources.getLibvirtXmlFile(xmlFileName);
        VirtualizationConfigurationQemu vmConfig = new VirtualizationConfigurationQemu(null, file);
        Domain vmLibvirtDomainConfig = VirtualizationConfigurationQemuTest.getPrivateDomainFromQemuMetaData(vmConfig);
        String originalOsMachine = vmLibvirtDomainConfig.getOsMachine();
        if (originalOsMachine != null) {
            Assertions.assertEquals((Object)"pc-q35-3.1", (Object)originalOsMachine);
        }
        Version modifiedVersion = new Version(Short.valueOf("4").shortValue(), Short.valueOf("1").shortValue());
        vmConfig.setVirtualizerVersion(modifiedVersion);
        String modifiedOsMachine = vmLibvirtDomainConfig.getOsMachine();
        if (modifiedOsMachine == null) {
            Assertions.assertNull((Object)vmConfig.getVirtualizerVersion());
        } else {
            Assertions.assertEquals((Object)modifiedVersion, (Object)vmConfig.getVirtualizerVersion());
            Assertions.assertEquals((Object)"pc-q35-4.1", (Object)modifiedOsMachine);
        }
        Assertions.assertDoesNotThrow(() -> vmConfig.validate());
    }

    @ParameterizedTest
    @DisplayName(value="Remove any USB redirect devices")
    @ValueSource(strings={"qemu-kvm_default-archlinux-vm.xml"})
    public void testQemuMetaDataDisableUsb(String xmlFileName) throws VirtualizationConfigurationException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        File file = LibvirtXmlTestResources.getLibvirtXmlFile(xmlFileName);
        VirtualizationConfigurationQemu vmConfig = new VirtualizationConfigurationQemu(null, file);
        Domain vmLibvirtDomainConfig = VirtualizationConfigurationQemuTest.getPrivateDomainFromQemuMetaData(vmConfig);
        Assertions.assertEquals((int)2, (int)vmLibvirtDomainConfig.getRedirectDevices().size());
        vmConfig.disableUsb();
        Assertions.assertEquals((int)0, (int)vmLibvirtDomainConfig.getRedirectDevices().size());
        Assertions.assertDoesNotThrow(() -> vmConfig.validate());
    }
}

