/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.virtualization.configuration;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.openslx.virtualization.Version;
import org.openslx.virtualization.configuration.VirtualizationConfiguration;
import org.openslx.virtualization.configuration.VirtualizationConfigurationException;
import org.openslx.virtualization.configuration.VirtualizationConfigurationTestResources;
import org.openslx.virtualization.configuration.VirtualizationConfigurationVirtualBox;
import org.openslx.virtualization.disk.DiskImage;

public class VirtualizationConfigurationVirtualBoxTest {
    @BeforeAll
    public static void setUp() {
        Configurator.setRootLevel((Level)Level.OFF);
    }

    @ParameterizedTest
    @DisplayName(value="Test version from VM configuration")
    @MethodSource(value={"configAndVersionProvider"})
    public void testVirtualizationConfigurationVirtualBoxGetConfigurationVersion(String name, String configFileName, Version configVersion) throws IOException, VirtualizationConfigurationException {
        File configFile = VirtualizationConfigurationTestResources.getVirtualBoxXmlFile(configFileName);
        VirtualizationConfigurationVirtualBox vmConfig = new VirtualizationConfigurationVirtualBox(null, configFile);
        Assertions.assertEquals((Object)configVersion, (Object)vmConfig.getConfigurationVersion());
    }

    @ParameterizedTest
    @DisplayName(value="Test display name from VM configuration")
    @MethodSource(value={"configAndVersionProvider"})
    public void testVirtualizationConfigurationVirtualBoxGetDisplayName(String name, String configFileName, Version configVersion) throws IOException, VirtualizationConfigurationException {
        File configFile = VirtualizationConfigurationTestResources.getVirtualBoxXmlFile(configFileName);
        VirtualizationConfigurationVirtualBox vmConfig = new VirtualizationConfigurationVirtualBox(null, configFile);
        String displayName = vmConfig.getDisplayName();
        Assertions.assertEquals((Object)VirtualizationConfigurationVirtualBoxTest.getVmName(name, configVersion), (Object)displayName);
    }

    @ParameterizedTest
    @DisplayName(value="Test machine snapshot state from VM configuration")
    @MethodSource(value={"configAndVersionProvider"})
    public void testVirtualizationConfigurationVirtualBoxIsMachineSnapshot(String name, String configFileName, Version configVersion) throws IOException, VirtualizationConfigurationException {
        File configFile = VirtualizationConfigurationTestResources.getVirtualBoxXmlFile(configFileName);
        VirtualizationConfigurationVirtualBox vmConfig = new VirtualizationConfigurationVirtualBox(null, configFile);
        boolean isVmSnapshot = vmConfig.isMachineSnapshot();
        Assertions.assertFalse((boolean)isVmSnapshot);
    }

    @ParameterizedTest
    @DisplayName(value="Test supported image formats from VM configuration")
    @MethodSource(value={"configAndVersionProvider"})
    public void testVirtualizationConfigurationVirtualBoxGetSupportedImageFormats(String name, String configFileName, Version configVersion) throws IOException, VirtualizationConfigurationException {
        File configFile = VirtualizationConfigurationTestResources.getVirtualBoxXmlFile(configFileName);
        VirtualizationConfigurationVirtualBox vmConfig = new VirtualizationConfigurationVirtualBox(null, configFile);
        List supportedImageFormats = vmConfig.getVirtualizer().getSupportedImageFormats();
        Assertions.assertNotNull((Object)supportedImageFormats);
        Assertions.assertEquals((int)1, (int)supportedImageFormats.size());
        Assertions.assertTrue((boolean)supportedImageFormats.containsAll(Arrays.asList(DiskImage.ImageFormat.VDI)));
    }

    @ParameterizedTest
    @DisplayName(value="Test output of HDDs from VM configuration")
    @MethodSource(value={"configAndVersionProvider"})
    public void testVirtualizationConfigurationVirtualBoxGetHdds(String name, String configFileName, Version configVersion) throws IOException, VirtualizationConfigurationException {
        File configFile = VirtualizationConfigurationTestResources.getVirtualBoxXmlFile(configFileName);
        VirtualizationConfigurationVirtualBox vmConfig = new VirtualizationConfigurationVirtualBox(null, configFile);
        List hdds = vmConfig.getHdds();
        String imageFileName = VirtualizationConfigurationVirtualBoxTest.getVmName(name, configVersion) + ".vdi";
        Assertions.assertNotNull((Object)hdds);
        Assertions.assertEquals((int)1, (int)hdds.size());
        Assertions.assertEquals((Object)imageFileName, (Object)((VirtualizationConfiguration.HardDisk)hdds.get((int)0)).diskImage);
    }

    static String getVmName(String name, Version version) {
        return name + "_" + version.toString().replace('.', '-');
    }

    static Stream<Arguments> configAndVersionProvider() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{"ubuntu", "virtualbox_default-ubuntu_v1-15.vbox", new Version(Short.valueOf("1").shortValue(), Short.valueOf("15").shortValue())}), Arguments.arguments((Object[])new Object[]{"ubuntu", "virtualbox_default-ubuntu_v1-16.vbox", new Version(Short.valueOf("1").shortValue(), Short.valueOf("16").shortValue())}), Arguments.arguments((Object[])new Object[]{"ubuntu", "virtualbox_default-ubuntu_v1-17.vbox", new Version(Short.valueOf("1").shortValue(), Short.valueOf("17").shortValue())}), Arguments.arguments((Object[])new Object[]{"ubuntu", "virtualbox_default-ubuntu_v1-18.vbox", new Version(Short.valueOf("1").shortValue(), Short.valueOf("18").shortValue())}), Arguments.arguments((Object[])new Object[]{"windows-7", "virtualbox_default-windows-7_v1-15.vbox", new Version(Short.valueOf("1").shortValue(), Short.valueOf("15").shortValue())}), Arguments.arguments((Object[])new Object[]{"windows-7", "virtualbox_default-windows-7_v1-16.vbox", new Version(Short.valueOf("1").shortValue(), Short.valueOf("16").shortValue())}), Arguments.arguments((Object[])new Object[]{"windows-7", "virtualbox_default-windows-7_v1-17.vbox", new Version(Short.valueOf("1").shortValue(), Short.valueOf("17").shortValue())}), Arguments.arguments((Object[])new Object[]{"windows-7", "virtualbox_default-windows-7_v1-18.vbox", new Version(Short.valueOf("1").shortValue(), Short.valueOf("18").shortValue())}));
    }
}

