/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.virtualization.configuration.logic;

import java.io.File;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.openslx.libvirt.xml.LibvirtXmlTestResources;
import org.openslx.virtualization.configuration.VirtualizationConfiguration;
import org.openslx.virtualization.configuration.data.ConfigurationDataDozModClientToDozModServer;
import org.openslx.virtualization.configuration.logic.ConfigurationLogicDozModClientToDozModServer;
import org.openslx.virtualization.configuration.logic.ConfigurationLogicTestResources;
import org.openslx.virtualization.configuration.logic.ConfigurationLogicTestUtils;
import org.openslx.virtualization.configuration.transformation.TransformationException;

public class ConfigurationLogicDozModClientToDozModServerTest {
    @BeforeAll
    public static void setUp() {
        Configurator.setRootLevel((Level)Level.OFF);
    }

    @Test
    @DisplayName(value="Test transformation logic between a dozmod-client and a dozmod-server for Libvirt/QEMU configuration")
    public void testConfigurationLogicDozModClientToDozModServerLibvirt() throws TransformationException {
        String inputConfigFileName = "qemu-kvm_default-ubuntu-20-04-vm.xml";
        String expectedConfigFileName = "qemu-kvm_default-ubuntu-20-04-vm_transform-privacy.xml";
        File inputConfig = LibvirtXmlTestResources.getLibvirtXmlFile("qemu-kvm_default-ubuntu-20-04-vm.xml");
        File expectedConfig = LibvirtXmlTestResources.getLibvirtXmlFile("qemu-kvm_default-ubuntu-20-04-vm_transform-privacy.xml");
        VirtualizationConfiguration config = ConfigurationLogicTestUtils.newVirtualizationConfigurationInstance(inputConfig);
        ConfigurationLogicDozModClientToDozModServer logic = new ConfigurationLogicDozModClientToDozModServer();
        logic.apply((Object)config, (Object)new ConfigurationDataDozModClientToDozModServer());
        String transformedConfig = config.getConfigurationAsString();
        String expectedTransformedConfig = ConfigurationLogicTestUtils.readFileToString(expectedConfig);
        ConfigurationLogicTestUtils.assertXmlEqual(expectedTransformedConfig, transformedConfig);
        Assertions.assertDoesNotThrow(() -> config.validate());
    }

    @Test
    @DisplayName(value="Test transformation logic between a dozmod-client and a dozmod-server for VirtualBox configuration")
    public void testConfigurationLogicDozModClientToDozModServerVirtualBox() throws TransformationException {
        String inputConfigFileName = "virtualbox_default-ubuntu.vbox";
        String expectedConfigFileName = "virtualbox_default-ubuntu_transform-privacy.vbox";
        File inputConfig = ConfigurationLogicTestResources.getVirtualBoxXmlFile("virtualbox_default-ubuntu.vbox");
        File expectedConfig = ConfigurationLogicTestResources.getVirtualBoxXmlFile("virtualbox_default-ubuntu_transform-privacy.vbox");
        VirtualizationConfiguration config = ConfigurationLogicTestUtils.newVirtualizationConfigurationInstance(inputConfig);
        ConfigurationLogicDozModClientToDozModServer logic = new ConfigurationLogicDozModClientToDozModServer();
        logic.apply((Object)config, (Object)new ConfigurationDataDozModClientToDozModServer());
        String transformedConfig = config.getConfigurationAsString();
        String expectedTransformedConfig = ConfigurationLogicTestUtils.readFileToString(expectedConfig);
        ConfigurationLogicTestUtils.assertXmlEqual(expectedTransformedConfig, transformedConfig);
    }

    @Test
    @DisplayName(value="Test transformation logic between a dozmod-client and a dozmod-server for VMware configuration")
    public void testConfigurationLogicDozModClientToDozModServerVmware() throws TransformationException {
        String inputConfigFileName = "vmware-player_default-ubuntu.vmx";
        String expectedConfigFileName = "vmware-player_default-ubuntu_transform-privacy.vmx";
        File inputConfig = ConfigurationLogicTestResources.getVmwareVmxFile("vmware-player_default-ubuntu.vmx");
        File expectedConfig = ConfigurationLogicTestResources.getVmwareVmxFile("vmware-player_default-ubuntu_transform-privacy.vmx");
        VirtualizationConfiguration config = ConfigurationLogicTestUtils.newVirtualizationConfigurationInstance(inputConfig);
        Assertions.assertTrue((config.getHdds().size() == 1 ? 1 : 0) != 0);
        ConfigurationLogicDozModClientToDozModServer logic = new ConfigurationLogicDozModClientToDozModServer();
        logic.apply((Object)config, (Object)new ConfigurationDataDozModClientToDozModServer());
        String transformedConfig = config.getConfigurationAsString();
        String expectedTransformedConfig = ConfigurationLogicTestUtils.readFileToString(expectedConfig);
        ConfigurationLogicTestUtils.assertVmxVmwareEqual(expectedTransformedConfig, transformedConfig);
        Assertions.assertDoesNotThrow(() -> config.validate());
    }
}

