/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.virtualization.configuration.logic;

import java.io.File;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.openslx.bwlp.thrift.iface.OperatingSystem;
import org.openslx.libvirt.xml.LibvirtXmlTestResources;
import org.openslx.virtualization.configuration.VirtualizationConfiguration;
import org.openslx.virtualization.configuration.data.ConfigurationDataDozModServerToDozModClient;
import org.openslx.virtualization.configuration.logic.ConfigurationLogicDozModServerToDozModClient;
import org.openslx.virtualization.configuration.logic.ConfigurationLogicTestResources;
import org.openslx.virtualization.configuration.logic.ConfigurationLogicTestUtils;
import org.openslx.virtualization.configuration.transformation.TransformationException;
import org.openslx.virtualization.disk.DiskImageTestResources;

public class ConfigurationLogicDozModServerToDozModClientTest {
    private static final String DEFAULT_DISPLAY_NAME = "Test";
    private static final File DEFAULT_DISK_IMAGE = DiskImageTestResources.getDiskFile("image-default.vmdk");
    private static final OperatingSystem DEFAULT_GUEST_OS = null;
    private static final String DEFAULT_VIRTUALIZER_ID = null;
    private static final int DEFAULT_TOTAL_MEMORY = 4096;
    private static final ConfigurationDataDozModServerToDozModClient DEFAULT_CONFIG_DATA = new ConfigurationDataDozModServerToDozModClient("Test", DEFAULT_DISK_IMAGE, DEFAULT_GUEST_OS, DEFAULT_VIRTUALIZER_ID, 4096);

    @BeforeAll
    public static void setUp() {
        Configurator.setRootLevel((Level)Level.OFF);
    }

    @Test
    @DisplayName(value="Test transformation logic between a dozmod-server and a dozmod-client for Libvirt/QEMU configuration")
    public void testConfigurationLogicDozModServerToDozModClientLibvirt() throws TransformationException {
        String inputConfigFileName = "qemu-kvm_default-ubuntu-20-04-vm_transform-privacy.xml";
        String expectedConfigFileName = "qemu-kvm_default-ubuntu-20-04-vm_transform-editable.xml";
        File inputConfig = LibvirtXmlTestResources.getLibvirtXmlFile("qemu-kvm_default-ubuntu-20-04-vm_transform-privacy.xml");
        File expectedConfig = LibvirtXmlTestResources.getLibvirtXmlFile("qemu-kvm_default-ubuntu-20-04-vm_transform-editable.xml");
        VirtualizationConfiguration config = ConfigurationLogicTestUtils.newVirtualizationConfigurationInstance(inputConfig);
        ConfigurationLogicDozModServerToDozModClient logic = new ConfigurationLogicDozModServerToDozModClient();
        logic.apply((Object)config, (Object)DEFAULT_CONFIG_DATA);
        String transformedConfig = config.getConfigurationAsString();
        String expectedTransformedConfig = ConfigurationLogicTestUtils.readFileToString(expectedConfig);
        ConfigurationLogicTestUtils.assertXmlLibvirtEqual(expectedTransformedConfig, transformedConfig);
        Assertions.assertDoesNotThrow(() -> config.validate());
    }

    @Test
    @DisplayName(value="Test transformation logic between a dozmod-server and a dozmod-client for VirtualBox configuration")
    public void testConfigurationLogicDozModServerToDozModClientVirtualBox() throws TransformationException {
        String inputConfigFileName = "virtualbox_default-ubuntu_transform-privacy.vbox";
        String expectedConfigFileName = "virtualbox_default-ubuntu_transform-editable.vbox";
        File inputConfig = ConfigurationLogicTestResources.getVirtualBoxXmlFile("virtualbox_default-ubuntu_transform-privacy.vbox");
        File expectedConfig = ConfigurationLogicTestResources.getVirtualBoxXmlFile("virtualbox_default-ubuntu_transform-editable.vbox");
        VirtualizationConfiguration config = ConfigurationLogicTestUtils.newVirtualizationConfigurationInstance(inputConfig);
        ConfigurationLogicDozModServerToDozModClient logic = new ConfigurationLogicDozModServerToDozModClient();
        logic.apply((Object)config, (Object)DEFAULT_CONFIG_DATA);
        String transformedConfig = config.getConfigurationAsString();
        String expectedTransformedConfig = ConfigurationLogicTestUtils.readFileToString(expectedConfig);
        ConfigurationLogicTestUtils.assertXmlVirtualBoxEqual(expectedTransformedConfig, transformedConfig);
    }

    @Test
    @DisplayName(value="Test transformation logic between dozmod-server and a dozmod-client for VMware configuration")
    public void testConfigurationLogicDozModServerToDozModClientVmware() throws TransformationException {
        String inputConfigFileName = "vmware-player_default-ubuntu_transform-privacy.vmx";
        String expectedConfigFileName = "vmware-player_default-ubuntu_transform-editable.vmx";
        File inputConfig = ConfigurationLogicTestResources.getVmwareVmxFile("vmware-player_default-ubuntu_transform-privacy.vmx");
        File expectedConfig = ConfigurationLogicTestResources.getVmwareVmxFile("vmware-player_default-ubuntu_transform-editable.vmx");
        VirtualizationConfiguration config = ConfigurationLogicTestUtils.newVirtualizationConfigurationInstance(inputConfig);
        Assertions.assertTrue((config.getHdds().size() == 1 ? 1 : 0) != 0);
        ConfigurationLogicDozModServerToDozModClient logic = new ConfigurationLogicDozModServerToDozModClient();
        logic.apply((Object)config, (Object)DEFAULT_CONFIG_DATA);
        String transformedConfig = config.getConfigurationAsString();
        String expectedTransformedConfig = ConfigurationLogicTestUtils.readFileToString(expectedConfig);
        ConfigurationLogicTestUtils.assertVmxVmwareEqual(expectedTransformedConfig, transformedConfig);
        Assertions.assertDoesNotThrow(() -> config.validate());
    }
}

