/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.virtualization.configuration.logic;

import java.io.File;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.openslx.libvirt.xml.LibvirtXmlTestResources;
import org.openslx.virtualization.configuration.VirtualizationConfiguration;
import org.openslx.virtualization.configuration.data.ConfigurationDataDozModServerToStatelessClient;
import org.openslx.virtualization.configuration.logic.ConfigurationLogicDozModServerToStatelessClient;
import org.openslx.virtualization.configuration.logic.ConfigurationLogicTestResources;
import org.openslx.virtualization.configuration.logic.ConfigurationLogicTestUtils;
import org.openslx.virtualization.configuration.transformation.TransformationException;

public class ConfigurationLogicDozModServerToStatelessClientTest {
    private static final String DEFAULT_DISPLAY_NAME = "Test";
    private static final String DEFAULT_OS_ID = null;
    private static final boolean DEFAULT_HAS_USB_ACCESS = true;
    private static final ConfigurationDataDozModServerToStatelessClient DEFAULT_CONFIG_DATA = new ConfigurationDataDozModServerToStatelessClient("Test", DEFAULT_OS_ID, true);

    @BeforeAll
    public static void setUp() {
        Configurator.setRootLevel((Level)Level.OFF);
    }

    @Test
    @DisplayName(value="Test transformation logic between a dozmod-server and a stateless client for Libvirt/QEMU configuration")
    public void testConfigurationLogicDozModServerToStatelessClientLibvirt() throws TransformationException {
        String inputConfigFileName = "qemu-kvm_default-ubuntu-20-04-vm_transform-privacy.xml";
        String expectedConfigFileName = "qemu-kvm_default-ubuntu-20-04-vm_transform-non-persistent.xml";
        File inputConfig = LibvirtXmlTestResources.getLibvirtXmlFile("qemu-kvm_default-ubuntu-20-04-vm_transform-privacy.xml");
        File expectedConfig = LibvirtXmlTestResources.getLibvirtXmlFile("qemu-kvm_default-ubuntu-20-04-vm_transform-non-persistent.xml");
        VirtualizationConfiguration config = ConfigurationLogicTestUtils.newVirtualizationConfigurationInstance(inputConfig);
        ConfigurationLogicDozModServerToStatelessClient logic = new ConfigurationLogicDozModServerToStatelessClient();
        logic.apply((Object)config, (Object)DEFAULT_CONFIG_DATA);
        String transformedConfig = config.getConfigurationAsString();
        String expectedTransformedConfig = ConfigurationLogicTestUtils.readFileToString(expectedConfig);
        ConfigurationLogicTestUtils.assertXmlEqual(expectedTransformedConfig, transformedConfig);
        Assertions.assertDoesNotThrow(() -> config.validate());
    }

    @Test
    @DisplayName(value="Test transformation logic between a dozmod-server and a stateless client for VirtualBox configuration")
    public void testConfigurationLogicDozModServerToStatelessClientVirtualBox() throws TransformationException {
        String inputConfigFileName = "virtualbox_default-ubuntu_transform-privacy.vbox";
        String expectedConfigFileName = "virtualbox_default-ubuntu_transform-non-persistent.vbox";
        File inputConfig = ConfigurationLogicTestResources.getVirtualBoxXmlFile("virtualbox_default-ubuntu_transform-privacy.vbox");
        File expectedConfig = ConfigurationLogicTestResources.getVirtualBoxXmlFile("virtualbox_default-ubuntu_transform-non-persistent.vbox");
        VirtualizationConfiguration config = ConfigurationLogicTestUtils.newVirtualizationConfigurationInstance(inputConfig);
        ConfigurationLogicDozModServerToStatelessClient logic = new ConfigurationLogicDozModServerToStatelessClient();
        logic.apply((Object)config, (Object)DEFAULT_CONFIG_DATA);
        String transformedConfig = config.getConfigurationAsString();
        String expectedTransformedConfig = ConfigurationLogicTestUtils.readFileToString(expectedConfig);
        ConfigurationLogicTestUtils.assertXmlEqual(expectedTransformedConfig, transformedConfig);
    }

    @Test
    @DisplayName(value="Test transformation logic between dozmod-server and a stateless client for VMware configuration")
    public void testConfigurationLogicDozModServerToStatelessClientVmware() throws TransformationException {
        String inputConfigFileName = "vmware-player_default-ubuntu_transform-privacy.vmx";
        String expectedConfigFileName = "vmware-player_default-ubuntu_transform-non-persistent.vmx";
        File inputConfig = ConfigurationLogicTestResources.getVmwareVmxFile("vmware-player_default-ubuntu_transform-privacy.vmx");
        File expectedConfig = ConfigurationLogicTestResources.getVmwareVmxFile("vmware-player_default-ubuntu_transform-non-persistent.vmx");
        VirtualizationConfiguration config = ConfigurationLogicTestUtils.newVirtualizationConfigurationInstance(inputConfig);
        Assertions.assertTrue((config.getHdds().size() == 1 ? 1 : 0) != 0);
        ConfigurationLogicDozModServerToStatelessClient logic = new ConfigurationLogicDozModServerToStatelessClient();
        logic.apply((Object)config, (Object)DEFAULT_CONFIG_DATA);
        String transformedConfig = config.getConfigurationAsString();
        String expectedTransformedConfig = ConfigurationLogicTestUtils.readFileToString(expectedConfig);
        ConfigurationLogicTestUtils.assertVmxVmwareEqual(expectedTransformedConfig, transformedConfig);
        Assertions.assertDoesNotThrow(() -> config.validate());
    }
}

