/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.virtualization.configuration.logic;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.Assertions;
import org.openslx.bwlp.thrift.iface.OperatingSystem;
import org.openslx.virtualization.configuration.VirtualizationConfiguration;
import org.xmlunit.assertj.XmlAssert;

public class ConfigurationLogicTestUtils {
    public static final List<OperatingSystem> STUB_OS_LIST = Collections.unmodifiableList(Arrays.asList(new OperatingSystem(1, "Windows 7 (64\u202fBit)", null, "AMD64", 196608, 256), new OperatingSystem(2, "Windows 8 (32\u202fBit)", null, "x86", 4096, 32), new OperatingSystem(3, "Windows 8 (64\u202fBit)", null, "AMD64", 131072, 256), new OperatingSystem(4, "Ubuntu (32\u202fBit)", null, "x86", 0, 0), new OperatingSystem(5, "Ubuntu (64\u202fBit)", null, "AMD64", 0, 0), new OperatingSystem(6, "OpenSUSE (32\u202fBit)", null, "x86", 0, 0), new OperatingSystem(7, "OpenSUSE (64\u202fBit)", null, "AMD64", 0, 0), new OperatingSystem(8, "Other Linux (32\u202fBit)", null, "x86", 0, 0), new OperatingSystem(9, "Other Linux (64\u202fBit)", null, "AMD64", 0, 0), new OperatingSystem(10, "Windows 7 (32\u202fBit)", null, "x86", 4096, 32), new OperatingSystem(11, "Windows 2000 Professional", null, "x86", 4096, 4)));
    private static final String REGEX_UUID = "<(Machine|HardDisk|Image)(.*)[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}";
    private static final String REGEX_SOURCE_FILE_PATHS = "(<source.*file=\")([^\"]*)";

    public static VirtualizationConfiguration newVirtualizationConfigurationInstance(File configFile) {
        VirtualizationConfiguration config = null;
        try {
            config = VirtualizationConfiguration.getInstance(STUB_OS_LIST, (File)configFile);
        }
        catch (IOException e) {
            Assertions.fail((String)("Virtualization configuration file '" + configFile.getName() + "' can not be processed!"));
        }
        if (config == null) {
            Assertions.fail((String)("Virtualization configuration can not be created from file '" + configFile.getName() + "'"));
        }
        return config;
    }

    public static String readFileToString(File file) {
        String content = null;
        try {
            content = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            Assertions.fail((String)("Could not read content of file '" + file.getName() + "'"));
        }
        return content;
    }

    public static void assertXmlEqual(String expectedXml, String actualXml) throws AssertionError {
        XmlAssert.assertThat((Object)actualXml).and((Object)expectedXml).ignoreComments().areIdentical();
    }

    private static String removeSourceFilePaths(String content) {
        Pattern patternSourceFilePaths = Pattern.compile(REGEX_SOURCE_FILE_PATHS);
        Matcher matcherSourceFilePathsContent = patternSourceFilePaths.matcher(content);
        return matcherSourceFilePathsContent.replaceAll("$1");
    }

    private static String removeUuid(String content) {
        Pattern patternUuid = Pattern.compile(REGEX_UUID);
        Matcher matcherUuidContent = patternUuid.matcher(content);
        return matcherUuidContent.replaceAll("<$1$200000000-0000-0000-0000-000000000000");
    }

    public static void assertXmlLibvirtEqual(String expectedXml, String actualXml) throws AssertionError {
        String filteredXml1 = ConfigurationLogicTestUtils.removeSourceFilePaths(expectedXml);
        String filteredXml2 = ConfigurationLogicTestUtils.removeSourceFilePaths(actualXml);
        ConfigurationLogicTestUtils.assertXmlEqual(filteredXml1, filteredXml2);
    }

    public static void assertXmlVirtualBoxEqual(String expectedXml, String actualXml) throws AssertionError {
        String actualXmlFiltered = ConfigurationLogicTestUtils.removeUuid(actualXml);
        ConfigurationLogicTestUtils.assertXmlEqual(expectedXml, actualXmlFiltered);
    }

    public static void assertVmxVmwareEqual(String expectedVmx, String actualVmx) throws AssertionError {
        BufferedReader bfrVmx1 = new BufferedReader(new StringReader(expectedVmx));
        BufferedReader bfrVmx2 = new BufferedReader(new StringReader(actualVmx));
        List linesVmx1 = bfrVmx1.lines().collect(Collectors.toList());
        List linesVmx2 = bfrVmx2.lines().collect(Collectors.toList());
        if (linesVmx1.size() != linesVmx2.size()) {
            ArrayList missingItems;
            String missingItemsDesc;
            if (linesVmx1.size() > linesVmx2.size()) {
                missingItemsDesc = "The following items are expected but missing in the actual output";
                missingItems = new ArrayList(linesVmx1);
                missingItems.removeAll(linesVmx2);
            } else {
                missingItemsDesc = "The following items are not expected but occuring in the actual output";
                missingItems = new ArrayList(linesVmx2);
                missingItems.removeAll(linesVmx1);
            }
            throw new AssertionError((Object)String.format("VMX output size is not satisfied: Expected %d lines, but output has %d lines!\n%s:\n%s", linesVmx1.size(), linesVmx2.size(), missingItemsDesc, missingItems));
        }
        Assertions.assertEquals(linesVmx1, linesVmx2);
    }
}

