/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.virtualization.disk;

import java.io.File;
import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.openslx.virtualization.Version;
import org.openslx.virtualization.disk.DiskImage;
import org.openslx.virtualization.disk.DiskImageException;
import org.openslx.virtualization.disk.DiskImageTestResources;

public class DiskImageQcow2Test {
    @Test
    @DisplayName(value="Test detection of default QCOW2 disk image")
    public void testQcow2DiskImage() throws DiskImageException, IOException {
        DiskImage image = DiskImage.newInstance((File)DiskImageTestResources.getDiskFile("image-default.qcow2"));
        Version imageVersion = new Version(Short.valueOf("3").shortValue());
        Assertions.assertEquals((Object)DiskImage.ImageFormat.QCOW2.toString(), (Object)image.getFormat().toString());
        Assertions.assertEquals((Object)true, (Object)image.isStandalone());
        Assertions.assertEquals((Object)false, (Object)image.isSnapshot());
        Assertions.assertEquals((Object)false, (Object)image.isCompressed());
        Assertions.assertEquals((Object)imageVersion, (Object)image.getVersion());
        Assertions.assertNull((Object)image.getDescription());
    }

    @Test
    @DisplayName(value="Test detection of compressed, 16384 byte cluster QCOW2 disk image with extended L2 tables")
    public void testQcow2DetectionL2Compressed16384DiskImage() throws DiskImageException, IOException {
        DiskImage image = DiskImage.newInstance((File)DiskImageTestResources.getDiskFile("image_cs-16384_cp-on_l2-on.qcow2"));
        Version imageVersion = new Version(Short.valueOf("3").shortValue());
        Assertions.assertEquals((Object)DiskImage.ImageFormat.QCOW2.toString(), (Object)image.getFormat().toString());
        Assertions.assertEquals((Object)true, (Object)image.isStandalone());
        Assertions.assertEquals((Object)false, (Object)image.isSnapshot());
        Assertions.assertEquals((Object)true, (Object)image.isCompressed());
        Assertions.assertEquals((Object)imageVersion, (Object)image.getVersion());
        Assertions.assertNull((Object)image.getDescription());
    }

    @Test
    @DisplayName(value="Test detection of compressed, 16384 byte cluster QCOW2 disk image without extended L2 tables")
    public void testQcow2DetectionNonL2Compressed16384DiskImage() throws DiskImageException, IOException {
        DiskImage image = DiskImage.newInstance((File)DiskImageTestResources.getDiskFile("image_cs-16384_cp-on_l2-off.qcow2"));
        Version imageVersion = new Version(Short.valueOf("3").shortValue());
        Assertions.assertEquals((Object)DiskImage.ImageFormat.QCOW2.toString(), (Object)image.getFormat().toString());
        Assertions.assertEquals((Object)true, (Object)image.isStandalone());
        Assertions.assertEquals((Object)false, (Object)image.isSnapshot());
        Assertions.assertEquals((Object)true, (Object)image.isCompressed());
        Assertions.assertEquals((Object)imageVersion, (Object)image.getVersion());
        Assertions.assertNull((Object)image.getDescription());
    }

    @Test
    @DisplayName(value="Test detection of non-compressed, 16384 byte cluster QCOW2 disk image with extended L2 tables")
    public void testQcow2DetectionL2NonCompressed16384DiskImage() throws DiskImageException, IOException {
        DiskImage image = DiskImage.newInstance((File)DiskImageTestResources.getDiskFile("image_cs-16384_cp-off_l2-on.qcow2"));
        Version imageVersion = new Version(Short.valueOf("3").shortValue());
        Assertions.assertEquals((Object)DiskImage.ImageFormat.QCOW2.toString(), (Object)image.getFormat().toString());
        Assertions.assertEquals((Object)true, (Object)image.isStandalone());
        Assertions.assertEquals((Object)false, (Object)image.isSnapshot());
        Assertions.assertEquals((Object)false, (Object)image.isCompressed());
        Assertions.assertEquals((Object)imageVersion, (Object)image.getVersion());
        Assertions.assertNull((Object)image.getDescription());
    }

    @Test
    @DisplayName(value="Test detection of non-compressed, 16384 byte cluster QCOW2 disk image without extended L2 tables")
    public void testQcow2DetectionNonL2NonCompressed16384DiskImage() throws DiskImageException, IOException {
        DiskImage image = DiskImage.newInstance((File)DiskImageTestResources.getDiskFile("image_cs-16384_cp-off_l2-off.qcow2"));
        Version imageVersion = new Version(Short.valueOf("3").shortValue());
        Assertions.assertEquals((Object)DiskImage.ImageFormat.QCOW2.toString(), (Object)image.getFormat().toString());
        Assertions.assertEquals((Object)true, (Object)image.isStandalone());
        Assertions.assertEquals((Object)false, (Object)image.isSnapshot());
        Assertions.assertEquals((Object)false, (Object)image.isCompressed());
        Assertions.assertEquals((Object)imageVersion, (Object)image.getVersion());
        Assertions.assertNull((Object)image.getDescription());
    }

    @Test
    @DisplayName(value="Test detection of compressed, 65536 byte cluster QCOW2 disk image with extended L2 tables")
    public void testQcow2DetectionL2Compressed65536DiskImage() throws DiskImageException, IOException {
        DiskImage image = DiskImage.newInstance((File)DiskImageTestResources.getDiskFile("image_cs-65536_cp-on_l2-on.qcow2"));
        Version imageVersion = new Version(Short.valueOf("3").shortValue());
        Assertions.assertEquals((Object)DiskImage.ImageFormat.QCOW2.toString(), (Object)image.getFormat().toString());
        Assertions.assertEquals((Object)true, (Object)image.isStandalone());
        Assertions.assertEquals((Object)false, (Object)image.isSnapshot());
        Assertions.assertEquals((Object)true, (Object)image.isCompressed());
        Assertions.assertEquals((Object)imageVersion, (Object)image.getVersion());
        Assertions.assertNull((Object)image.getDescription());
    }

    @Test
    @DisplayName(value="Test detection of compressed, 65536 byte cluster QCOW2 disk image without extended L2 tables")
    public void testQcow2DetectionNonL2Compressed65536DiskImage() throws DiskImageException, IOException {
        DiskImage image = DiskImage.newInstance((File)DiskImageTestResources.getDiskFile("image_cs-65536_cp-on_l2-off.qcow2"));
        Version imageVersion = new Version(Short.valueOf("3").shortValue());
        Assertions.assertEquals((Object)DiskImage.ImageFormat.QCOW2.toString(), (Object)image.getFormat().toString());
        Assertions.assertEquals((Object)true, (Object)image.isStandalone());
        Assertions.assertEquals((Object)false, (Object)image.isSnapshot());
        Assertions.assertEquals((Object)true, (Object)image.isCompressed());
        Assertions.assertEquals((Object)imageVersion, (Object)image.getVersion());
        Assertions.assertNull((Object)image.getDescription());
    }

    @Test
    @DisplayName(value="Test detection of non-compressed, 65536 byte cluster QCOW2 disk image with extended L2 tables")
    public void testQcow2DetectionL2NonCompressed65536DiskImage() throws DiskImageException, IOException {
        DiskImage image = DiskImage.newInstance((File)DiskImageTestResources.getDiskFile("image_cs-65536_cp-off_l2-on.qcow2"));
        Version imageVersion = new Version(Short.valueOf("3").shortValue());
        Assertions.assertEquals((Object)DiskImage.ImageFormat.QCOW2.toString(), (Object)image.getFormat().toString());
        Assertions.assertEquals((Object)true, (Object)image.isStandalone());
        Assertions.assertEquals((Object)false, (Object)image.isSnapshot());
        Assertions.assertEquals((Object)false, (Object)image.isCompressed());
        Assertions.assertEquals((Object)imageVersion, (Object)image.getVersion());
        Assertions.assertNull((Object)image.getDescription());
    }

    @Test
    @DisplayName(value="Test detection of non-compressed, 65536 byte cluster QCOW2 disk image without extended L2 tables")
    public void testQcow2DetectionNonL2NonCompressed65536DiskImage() throws DiskImageException, IOException {
        DiskImage image = DiskImage.newInstance((File)DiskImageTestResources.getDiskFile("image_cs-65536_cp-off_l2-off.qcow2"));
        Version imageVersion = new Version(Short.valueOf("3").shortValue());
        Assertions.assertEquals((Object)DiskImage.ImageFormat.QCOW2.toString(), (Object)image.getFormat().toString());
        Assertions.assertEquals((Object)true, (Object)image.isStandalone());
        Assertions.assertEquals((Object)false, (Object)image.isSnapshot());
        Assertions.assertEquals((Object)false, (Object)image.isCompressed());
        Assertions.assertEquals((Object)imageVersion, (Object)image.getVersion());
        Assertions.assertNull((Object)image.getDescription());
    }

    @Test
    @DisplayName(value="Test detection of compressed, 2097152 byte cluster QCOW2 disk image with extended L2 tables")
    public void testQcow2DetectionL2Compressed2097152DiskImage() throws DiskImageException, IOException {
        DiskImage image = DiskImage.newInstance((File)DiskImageTestResources.getDiskFile("image_cs-2097152_cp-on_l2-on.qcow2"));
        Version imageVersion = new Version(Short.valueOf("3").shortValue());
        Assertions.assertEquals((Object)DiskImage.ImageFormat.QCOW2.toString(), (Object)image.getFormat().toString());
        Assertions.assertEquals((Object)true, (Object)image.isStandalone());
        Assertions.assertEquals((Object)false, (Object)image.isSnapshot());
        Assertions.assertEquals((Object)true, (Object)image.isCompressed());
        Assertions.assertEquals((Object)imageVersion, (Object)image.getVersion());
        Assertions.assertNull((Object)image.getDescription());
    }

    @Test
    @DisplayName(value="Test detection of compressed, 2097152 byte cluster QCOW2 disk image without extended L2 tables")
    public void testQcow2DetectionNonL2Compressed2097152DiskImage() throws DiskImageException, IOException {
        DiskImage image = DiskImage.newInstance((File)DiskImageTestResources.getDiskFile("image_cs-2097152_cp-on_l2-off.qcow2"));
        Version imageVersion = new Version(Short.valueOf("3").shortValue());
        Assertions.assertEquals((Object)DiskImage.ImageFormat.QCOW2.toString(), (Object)image.getFormat().toString());
        Assertions.assertEquals((Object)true, (Object)image.isStandalone());
        Assertions.assertEquals((Object)false, (Object)image.isSnapshot());
        Assertions.assertEquals((Object)true, (Object)image.isCompressed());
        Assertions.assertEquals((Object)imageVersion, (Object)image.getVersion());
        Assertions.assertNull((Object)image.getDescription());
    }

    @Test
    @DisplayName(value="Test detection of non-compressed, 2097152 byte cluster QCOW2 disk image with extended L2 tables")
    public void testQcow2DetectionL2NonCompressed2097152DiskImage() throws DiskImageException, IOException {
        DiskImage image = DiskImage.newInstance((File)DiskImageTestResources.getDiskFile("image_cs-2097152_cp-off_l2-on.qcow2"));
        Version imageVersion = new Version(Short.valueOf("3").shortValue());
        Assertions.assertEquals((Object)DiskImage.ImageFormat.QCOW2.toString(), (Object)image.getFormat().toString());
        Assertions.assertEquals((Object)true, (Object)image.isStandalone());
        Assertions.assertEquals((Object)false, (Object)image.isSnapshot());
        Assertions.assertEquals((Object)false, (Object)image.isCompressed());
        Assertions.assertEquals((Object)imageVersion, (Object)image.getVersion());
        Assertions.assertNull((Object)image.getDescription());
    }

    @Test
    @DisplayName(value="Test detection of non-compressed, 2097152 byte cluster QCOW2 disk image without extended L2 tables")
    public void testQcow2DetectionNonL2NonCompressed2097152DiskImage() throws DiskImageException, IOException {
        DiskImage image = DiskImage.newInstance((File)DiskImageTestResources.getDiskFile("image_cs-2097152_cp-off_l2-off.qcow2"));
        Version imageVersion = new Version(Short.valueOf("3").shortValue());
        Assertions.assertEquals((Object)DiskImage.ImageFormat.QCOW2.toString(), (Object)image.getFormat().toString());
        Assertions.assertEquals((Object)true, (Object)image.isStandalone());
        Assertions.assertEquals((Object)false, (Object)image.isSnapshot());
        Assertions.assertEquals((Object)false, (Object)image.isCompressed());
        Assertions.assertEquals((Object)imageVersion, (Object)image.getVersion());
        Assertions.assertNull((Object)image.getDescription());
    }
}

