/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.virtualization.disk;

import java.io.File;
import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.openslx.virtualization.Version;
import org.openslx.virtualization.disk.DiskImage;
import org.openslx.virtualization.disk.DiskImageException;
import org.openslx.virtualization.disk.DiskImageTestResources;

public class DiskImageVdiTest {
    @Test
    @DisplayName(value="Test detection of default VDI disk image")
    public void testVdiDiskImage() throws DiskImageException, IOException {
        DiskImage image = DiskImage.newInstance((File)DiskImageTestResources.getDiskFile("image-default.vdi"));
        Version imageVersion = new Version(Short.valueOf("1").shortValue(), Short.valueOf("1").shortValue());
        Assertions.assertEquals((Object)DiskImage.ImageFormat.VDI.toString(), (Object)image.getFormat().toString());
        Assertions.assertEquals((Object)true, (Object)image.isStandalone());
        Assertions.assertEquals((Object)false, (Object)image.isSnapshot());
        Assertions.assertEquals((Object)false, (Object)image.isCompressed());
        Assertions.assertEquals((Object)imageVersion, (Object)image.getVersion());
        Assertions.assertNotNull((Object)image.getDescription());
    }

    @Test
    @DisplayName(value="Test detection of VDI disk image snapshot")
    public void testVdiDiskImageSnapshot() throws DiskImageException, IOException {
        DiskImage image = DiskImage.newInstance((File)DiskImageTestResources.getDiskFile("image-default_snapshot.vdi"));
        Version imageVersion = new Version(Short.valueOf("1").shortValue(), Short.valueOf("1").shortValue());
        Assertions.assertEquals((Object)DiskImage.ImageFormat.VDI.toString(), (Object)image.getFormat().toString());
        Assertions.assertEquals((Object)true, (Object)image.isStandalone());
        Assertions.assertEquals((Object)true, (Object)image.isSnapshot());
        Assertions.assertEquals((Object)false, (Object)image.isCompressed());
        Assertions.assertEquals((Object)imageVersion, (Object)image.getVersion());
        Assertions.assertNotNull((Object)image.getDescription());
    }
}

