/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.virtualization.disk;

import java.io.File;
import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.openslx.virtualization.Version;
import org.openslx.virtualization.disk.DiskImage;
import org.openslx.virtualization.disk.DiskImageException;
import org.openslx.virtualization.disk.DiskImageTestResources;
import org.openslx.virtualization.disk.DiskImageVmdk;

public class DiskImageVmdkTest {
    @Test
    @DisplayName(value="Test detection of default VMDK disk image")
    public void testVmdkDiskImage() throws DiskImageException, IOException {
        DiskImage image = DiskImage.newInstance((File)DiskImageTestResources.getDiskFile("image-default.vmdk"));
        Version imageVersion = new Version(Short.valueOf("1").shortValue());
        Version imageHwVersion = new Version(Short.valueOf("18").shortValue());
        Assertions.assertEquals((Object)DiskImage.ImageFormat.VMDK.toString(), (Object)image.getFormat().toString());
        Assertions.assertEquals((Object)true, (Object)image.isStandalone());
        Assertions.assertEquals((Object)false, (Object)image.isSnapshot());
        Assertions.assertEquals((Object)false, (Object)image.isCompressed());
        Assertions.assertEquals((Object)imageVersion, (Object)image.getVersion());
        Assertions.assertNull((Object)image.getDescription());
        DiskImageVmdk vmdkImage = (DiskImageVmdk)DiskImageVmdk.class.cast(image);
        Assertions.assertEquals((Object)imageHwVersion, (Object)vmdkImage.getHwVersion());
    }

    @Test
    @DisplayName(value="Test detection of VMDK disk image (type 0: single growable virtual disk)")
    public void testVmdkDiskImageType0() throws DiskImageException, IOException {
        DiskImage image = DiskImage.newInstance((File)DiskImageTestResources.getDiskFile("image_t0.vmdk"));
        Version imageVersion = new Version(Short.valueOf("1").shortValue());
        Version imageHwVersion = new Version(Short.valueOf("18").shortValue());
        Assertions.assertEquals((Object)DiskImage.ImageFormat.VMDK.toString(), (Object)image.getFormat().toString());
        Assertions.assertEquals((Object)true, (Object)image.isStandalone());
        Assertions.assertEquals((Object)false, (Object)image.isSnapshot());
        Assertions.assertEquals((Object)false, (Object)image.isCompressed());
        Assertions.assertEquals((Object)imageVersion, (Object)image.getVersion());
        Assertions.assertNull((Object)image.getDescription());
        DiskImageVmdk vmdkImage = (DiskImageVmdk)DiskImageVmdk.class.cast(image);
        Assertions.assertEquals((Object)imageHwVersion, (Object)vmdkImage.getHwVersion());
    }

    @Test
    @DisplayName(value="Test detection of VMDK disk image (type 1: growable virtual disk split into multiple files)")
    public void testVmdkDiskImageType1() throws DiskImageException, IOException {
        Assertions.assertThrows(DiskImageException.class, () -> DiskImage.newInstance((File)DiskImageTestResources.getDiskFile("image_t1.vmdk")));
    }

    @Test
    @DisplayName(value="Test detection of VMDK disk image (type 2: preallocated virtual disk)")
    public void testVmdkDiskImageType2() throws DiskImageException, IOException {
        Assertions.assertThrows(DiskImageException.class, () -> DiskImage.newInstance((File)DiskImageTestResources.getDiskFile("image_t2.vmdk")));
    }

    @Test
    @DisplayName(value="Test detection of VMDK disk image (type 3: preallocated virtual disk split into multiple files)")
    public void testVmdkDiskImageType3() throws DiskImageException, IOException {
        Assertions.assertThrows(DiskImageException.class, () -> DiskImage.newInstance((File)DiskImageTestResources.getDiskFile("image_t3.vmdk")));
    }

    @Test
    @DisplayName(value="Test detection of VMDK disk image (type 4: preallocated ESX-type virtual disk)")
    public void testVmdkDiskImageType4() throws DiskImageException, IOException {
        Assertions.assertThrows(DiskImageException.class, () -> DiskImage.newInstance((File)DiskImageTestResources.getDiskFile("image_t4.vmdk")));
    }

    @Test
    @DisplayName(value="Test detection of VMDK disk image (type 5: compressed disk optimized for streaming)")
    public void testVmdkDiskImageType5() throws DiskImageException, IOException {
        DiskImage image = DiskImage.newInstance((File)DiskImageTestResources.getDiskFile("image_t5.vmdk"));
        Version imageVersion = new Version(Short.valueOf("3").shortValue());
        Version imageHwVersion = new Version(Short.valueOf("18").shortValue());
        Assertions.assertEquals((Object)DiskImage.ImageFormat.VMDK.toString(), (Object)image.getFormat().toString());
        Assertions.assertEquals((Object)true, (Object)image.isStandalone());
        Assertions.assertEquals((Object)false, (Object)image.isSnapshot());
        Assertions.assertEquals((Object)true, (Object)image.isCompressed());
        Assertions.assertEquals((Object)imageVersion, (Object)image.getVersion());
        Assertions.assertNull((Object)image.getDescription());
        DiskImageVmdk vmdkImage = (DiskImageVmdk)DiskImageVmdk.class.cast(image);
        Assertions.assertEquals((Object)imageHwVersion, (Object)vmdkImage.getHwVersion());
    }
}

