/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.elonen;

import java.io.IOException;
import java.io.InputStream;

public class ChunkedInputStream
extends InputStream {
    private static final int BUFFER_SIZE = 2048;
    private final InputStream inputStream;
    private State state;
    private long chunkSize;
    private long pos;
    private boolean eof;
    private boolean closed;

    public ChunkedInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        this.pos = 0L;
        this.state = State.CHUNK_LEN;
    }

    @Override
    public int available() throws IOException {
        int len = this.inputStream.available();
        return (int)Math.min((long)len, this.chunkSize - this.pos);
    }

    @Override
    public int read() throws IOException {
        int b;
        if (this.closed) {
            throw new StreamClosedException("Already closed");
        }
        if (this.eof) {
            return -1;
        }
        if (this.state != State.CHUNK_DATA) {
            this.nextChunk();
            if (this.eof) {
                return -1;
            }
        }
        if ((b = this.inputStream.read()) != -1) {
            ++this.pos;
            if (this.pos >= this.chunkSize) {
                this.state = State.CHUNK_CRLF;
            }
            return b;
        }
        throw new MalformedChunkCodingException("Truncated chunk (expected size: " + this.chunkSize + "; actual size: " + this.pos + ")");
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead;
        if (this.closed) {
            throw new StreamClosedException("Already closed");
        }
        if (this.eof) {
            return -1;
        }
        if (this.state != State.CHUNK_DATA) {
            this.nextChunk();
            if (this.eof) {
                return -1;
            }
        }
        if ((bytesRead = this.inputStream.read(b, off, (int)Math.min((long)len, this.chunkSize - this.pos))) != -1) {
            this.pos += (long)bytesRead;
            if (this.pos >= this.chunkSize) {
                this.state = State.CHUNK_CRLF;
            }
            return bytesRead;
        }
        this.eof = true;
        throw new MalformedChunkCodingException("Truncated chunk (expected size: " + this.chunkSize + "; actual size: " + this.pos + ")");
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    private void nextChunk() throws IOException {
        block6: {
            if (this.state == State.CHUNK_INVALID) {
                throw new MalformedChunkCodingException("Corrupt data stream");
            }
            try {
                this.chunkSize = this.getChunkSize();
                if (this.chunkSize < 0L) {
                    throw new MalformedChunkCodingException("Negative chunk size");
                }
                this.state = State.CHUNK_DATA;
                this.pos = 0L;
                if (this.chunkSize != 0L) break block6;
                this.eof = true;
                try {
                    this.inputStream.read();
                    this.inputStream.read();
                }
                catch (IOException e) {
                    throw new MalformedChunkCodingException("No CRLF after final zero chunk");
                }
            }
            catch (MalformedChunkCodingException ex) {
                this.state = State.CHUNK_INVALID;
                throw ex;
            }
        }
    }

    private long getChunkSize() throws IOException {
        State st = this.state;
        switch (st) {
            case CHUNK_CRLF: {
                int ch = this.inputStream.read();
                ch = ch << 8 | this.inputStream.read();
                if (ch < 0) {
                    throw new MalformedChunkCodingException("CRLF expected at end of chunk");
                }
                if (ch != 3338) {
                    throw new MalformedChunkCodingException("Unexpected content at the end of chunk");
                }
                this.state = State.CHUNK_LEN;
            }
            case CHUNK_LEN: {
                int ch;
                int prevCh = -1;
                boolean hadSemi = false;
                StringBuilder sb = new StringBuilder(8);
                while ((ch = this.inputStream.read()) != -1 && (prevCh != 13 || ch != 10)) {
                    prevCh = ch;
                    if (ch == 13) continue;
                    if (ch == 59) {
                        hadSemi = true;
                    }
                    if (hadSemi) continue;
                    sb.append((char)ch);
                }
                if (prevCh != 13 || ch != 10) {
                    throw new StreamClosedException("Premature end of chunk coded message body");
                }
                String s = sb.toString();
                try {
                    return Long.parseLong(s, 16);
                }
                catch (NumberFormatException e) {
                    throw new MalformedChunkCodingException("Invalid hex-length in chunk header: " + s);
                }
            }
        }
        throw new IllegalStateException("Inconsistent codec state");
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                if (!this.eof && this.state != State.CHUNK_INVALID) {
                    if (this.chunkSize == this.pos && this.chunkSize > 0L && this.read() == -1) {
                        return;
                    }
                    byte[] buff = new byte[2048];
                    while (this.read(buff) >= 0) {
                    }
                }
            }
            finally {
                this.eof = true;
                this.closed = true;
            }
        }
    }

    public static class StreamClosedException
    extends IOException {
        private static final long serialVersionUID = -5871567871867283867L;

        public StreamClosedException(String msg) {
            super(msg);
        }
    }

    public static class MalformedChunkCodingException
    extends IOException {
        private static final long serialVersionUID = 7092137465179737109L;

        public MalformedChunkCodingException(String msg) {
            super(msg);
        }
    }

    private static enum State {
        CHUNK_LEN,
        CHUNK_DATA,
        CHUNK_CRLF,
        CHUNK_INVALID;

    }
}

