/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.thrift.iface;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;
import org.openslx.bwlp.thrift.iface.ImagePermissions;
import org.openslx.bwlp.thrift.iface.LecturePermissions;
import org.openslx.bwlp.thrift.iface.SscMode;

public class SatelliteConfig
implements TBase<SatelliteConfig, _Fields>,
Serializable,
Cloneable,
Comparable<SatelliteConfig> {
    private static final TStruct STRUCT_DESC = new TStruct("SatelliteConfig");
    private static final TField PAGE_SIZE_FIELD_DESC = new TField("pageSize", 8, 1);
    private static final TField DEFAULT_IMAGE_PERMISSIONS_FIELD_DESC = new TField("defaultImagePermissions", 12, 2);
    private static final TField DEFAULT_LECTURE_PERMISSIONS_FIELD_DESC = new TField("defaultLecturePermissions", 12, 3);
    private static final TField MAX_IMAGE_VALIDITY_DAYS_FIELD_DESC = new TField("maxImageValidityDays", 8, 4);
    private static final TField MAX_LECTURE_VALIDITY_DAYS_FIELD_DESC = new TField("maxLectureValidityDays", 8, 5);
    private static final TField MAX_TRANSFERS_FIELD_DESC = new TField("maxTransfers", 8, 6);
    private static final TField MAX_CONNECTIONS_PER_TRANSFER_FIELD_DESC = new TField("maxConnectionsPerTransfer", 8, 7);
    private static final TField MAX_LOCATIONS_PER_LECTURE_FIELD_DESC = new TField("maxLocationsPerLecture", 8, 8);
    private static final TField ALLOW_LOGIN_BY_DEFAULT_FIELD_DESC = new TField("allowLoginByDefault", 2, 9);
    private static final TField SERVER_SIDE_COPY_FIELD_DESC = new TField("serverSideCopy", 8, 10);
    private static final TField ALLOW_STUDENT_DOWNLOAD_FIELD_DESC = new TField("allowStudentDownload", 2, 11);
    private static final TField VM_SIZE_LIMIT_FIELD_DESC = new TField("vmSizeLimit", 10, 12);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new SatelliteConfigStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new SatelliteConfigTupleSchemeFactory();
    public int pageSize;
    @Nullable
    public ImagePermissions defaultImagePermissions;
    @Nullable
    public LecturePermissions defaultLecturePermissions;
    public int maxImageValidityDays;
    public int maxLectureValidityDays;
    public int maxTransfers;
    public int maxConnectionsPerTransfer;
    public int maxLocationsPerLecture;
    public boolean allowLoginByDefault;
    @Nullable
    public SscMode serverSideCopy;
    public boolean allowStudentDownload;
    public long vmSizeLimit;
    private static final int __PAGESIZE_ISSET_ID = 0;
    private static final int __MAXIMAGEVALIDITYDAYS_ISSET_ID = 1;
    private static final int __MAXLECTUREVALIDITYDAYS_ISSET_ID = 2;
    private static final int __MAXTRANSFERS_ISSET_ID = 3;
    private static final int __MAXCONNECTIONSPERTRANSFER_ISSET_ID = 4;
    private static final int __MAXLOCATIONSPERLECTURE_ISSET_ID = 5;
    private static final int __ALLOWLOGINBYDEFAULT_ISSET_ID = 6;
    private static final int __ALLOWSTUDENTDOWNLOAD_ISSET_ID = 7;
    private static final int __VMSIZELIMIT_ISSET_ID = 8;
    private short __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.MAX_TRANSFERS, _Fields.MAX_CONNECTIONS_PER_TRANSFER, _Fields.MAX_LOCATIONS_PER_LECTURE, _Fields.ALLOW_LOGIN_BY_DEFAULT, _Fields.SERVER_SIDE_COPY, _Fields.ALLOW_STUDENT_DOWNLOAD, _Fields.VM_SIZE_LIMIT};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public SatelliteConfig() {
    }

    public SatelliteConfig(int pageSize, ImagePermissions defaultImagePermissions, LecturePermissions defaultLecturePermissions, int maxImageValidityDays, int maxLectureValidityDays) {
        this();
        this.pageSize = pageSize;
        this.setPageSizeIsSet(true);
        this.defaultImagePermissions = defaultImagePermissions;
        this.defaultLecturePermissions = defaultLecturePermissions;
        this.maxImageValidityDays = maxImageValidityDays;
        this.setMaxImageValidityDaysIsSet(true);
        this.maxLectureValidityDays = maxLectureValidityDays;
        this.setMaxLectureValidityDaysIsSet(true);
    }

    public SatelliteConfig(SatelliteConfig other) {
        this.__isset_bitfield = other.__isset_bitfield;
        this.pageSize = other.pageSize;
        if (other.isSetDefaultImagePermissions()) {
            this.defaultImagePermissions = new ImagePermissions(other.defaultImagePermissions);
        }
        if (other.isSetDefaultLecturePermissions()) {
            this.defaultLecturePermissions = new LecturePermissions(other.defaultLecturePermissions);
        }
        this.maxImageValidityDays = other.maxImageValidityDays;
        this.maxLectureValidityDays = other.maxLectureValidityDays;
        this.maxTransfers = other.maxTransfers;
        this.maxConnectionsPerTransfer = other.maxConnectionsPerTransfer;
        this.maxLocationsPerLecture = other.maxLocationsPerLecture;
        this.allowLoginByDefault = other.allowLoginByDefault;
        if (other.isSetServerSideCopy()) {
            this.serverSideCopy = other.serverSideCopy;
        }
        this.allowStudentDownload = other.allowStudentDownload;
        this.vmSizeLimit = other.vmSizeLimit;
    }

    public SatelliteConfig deepCopy() {
        return new SatelliteConfig(this);
    }

    public void clear() {
        this.setPageSizeIsSet(false);
        this.pageSize = 0;
        this.defaultImagePermissions = null;
        this.defaultLecturePermissions = null;
        this.setMaxImageValidityDaysIsSet(false);
        this.maxImageValidityDays = 0;
        this.setMaxLectureValidityDaysIsSet(false);
        this.maxLectureValidityDays = 0;
        this.setMaxTransfersIsSet(false);
        this.maxTransfers = 0;
        this.setMaxConnectionsPerTransferIsSet(false);
        this.maxConnectionsPerTransfer = 0;
        this.setMaxLocationsPerLectureIsSet(false);
        this.maxLocationsPerLecture = 0;
        this.setAllowLoginByDefaultIsSet(false);
        this.allowLoginByDefault = false;
        this.serverSideCopy = null;
        this.setAllowStudentDownloadIsSet(false);
        this.allowStudentDownload = false;
        this.setVmSizeLimitIsSet(false);
        this.vmSizeLimit = 0L;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public SatelliteConfig setPageSize(int pageSize) {
        this.pageSize = pageSize;
        this.setPageSizeIsSet(true);
        return this;
    }

    public void unsetPageSize() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)0);
    }

    public boolean isSetPageSize() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)0);
    }

    public void setPageSizeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)0, (boolean)value);
    }

    @Nullable
    public ImagePermissions getDefaultImagePermissions() {
        return this.defaultImagePermissions;
    }

    public SatelliteConfig setDefaultImagePermissions(@Nullable ImagePermissions defaultImagePermissions) {
        this.defaultImagePermissions = defaultImagePermissions;
        return this;
    }

    public void unsetDefaultImagePermissions() {
        this.defaultImagePermissions = null;
    }

    public boolean isSetDefaultImagePermissions() {
        return this.defaultImagePermissions != null;
    }

    public void setDefaultImagePermissionsIsSet(boolean value) {
        if (!value) {
            this.defaultImagePermissions = null;
        }
    }

    @Nullable
    public LecturePermissions getDefaultLecturePermissions() {
        return this.defaultLecturePermissions;
    }

    public SatelliteConfig setDefaultLecturePermissions(@Nullable LecturePermissions defaultLecturePermissions) {
        this.defaultLecturePermissions = defaultLecturePermissions;
        return this;
    }

    public void unsetDefaultLecturePermissions() {
        this.defaultLecturePermissions = null;
    }

    public boolean isSetDefaultLecturePermissions() {
        return this.defaultLecturePermissions != null;
    }

    public void setDefaultLecturePermissionsIsSet(boolean value) {
        if (!value) {
            this.defaultLecturePermissions = null;
        }
    }

    public int getMaxImageValidityDays() {
        return this.maxImageValidityDays;
    }

    public SatelliteConfig setMaxImageValidityDays(int maxImageValidityDays) {
        this.maxImageValidityDays = maxImageValidityDays;
        this.setMaxImageValidityDaysIsSet(true);
        return this;
    }

    public void unsetMaxImageValidityDays() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)1);
    }

    public boolean isSetMaxImageValidityDays() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)1);
    }

    public void setMaxImageValidityDaysIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public int getMaxLectureValidityDays() {
        return this.maxLectureValidityDays;
    }

    public SatelliteConfig setMaxLectureValidityDays(int maxLectureValidityDays) {
        this.maxLectureValidityDays = maxLectureValidityDays;
        this.setMaxLectureValidityDaysIsSet(true);
        return this;
    }

    public void unsetMaxLectureValidityDays() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)2);
    }

    public boolean isSetMaxLectureValidityDays() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)2);
    }

    public void setMaxLectureValidityDaysIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)2, (boolean)value);
    }

    public int getMaxTransfers() {
        return this.maxTransfers;
    }

    public SatelliteConfig setMaxTransfers(int maxTransfers) {
        this.maxTransfers = maxTransfers;
        this.setMaxTransfersIsSet(true);
        return this;
    }

    public void unsetMaxTransfers() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)3);
    }

    public boolean isSetMaxTransfers() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)3);
    }

    public void setMaxTransfersIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)3, (boolean)value);
    }

    public int getMaxConnectionsPerTransfer() {
        return this.maxConnectionsPerTransfer;
    }

    public SatelliteConfig setMaxConnectionsPerTransfer(int maxConnectionsPerTransfer) {
        this.maxConnectionsPerTransfer = maxConnectionsPerTransfer;
        this.setMaxConnectionsPerTransferIsSet(true);
        return this;
    }

    public void unsetMaxConnectionsPerTransfer() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)4);
    }

    public boolean isSetMaxConnectionsPerTransfer() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)4);
    }

    public void setMaxConnectionsPerTransferIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)4, (boolean)value);
    }

    public int getMaxLocationsPerLecture() {
        return this.maxLocationsPerLecture;
    }

    public SatelliteConfig setMaxLocationsPerLecture(int maxLocationsPerLecture) {
        this.maxLocationsPerLecture = maxLocationsPerLecture;
        this.setMaxLocationsPerLectureIsSet(true);
        return this;
    }

    public void unsetMaxLocationsPerLecture() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)5);
    }

    public boolean isSetMaxLocationsPerLecture() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)5);
    }

    public void setMaxLocationsPerLectureIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)5, (boolean)value);
    }

    public boolean isAllowLoginByDefault() {
        return this.allowLoginByDefault;
    }

    public SatelliteConfig setAllowLoginByDefault(boolean allowLoginByDefault) {
        this.allowLoginByDefault = allowLoginByDefault;
        this.setAllowLoginByDefaultIsSet(true);
        return this;
    }

    public void unsetAllowLoginByDefault() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)6);
    }

    public boolean isSetAllowLoginByDefault() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)6);
    }

    public void setAllowLoginByDefaultIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)6, (boolean)value);
    }

    @Nullable
    public SscMode getServerSideCopy() {
        return this.serverSideCopy;
    }

    public SatelliteConfig setServerSideCopy(@Nullable SscMode serverSideCopy) {
        this.serverSideCopy = serverSideCopy;
        return this;
    }

    public void unsetServerSideCopy() {
        this.serverSideCopy = null;
    }

    public boolean isSetServerSideCopy() {
        return this.serverSideCopy != null;
    }

    public void setServerSideCopyIsSet(boolean value) {
        if (!value) {
            this.serverSideCopy = null;
        }
    }

    public boolean isAllowStudentDownload() {
        return this.allowStudentDownload;
    }

    public SatelliteConfig setAllowStudentDownload(boolean allowStudentDownload) {
        this.allowStudentDownload = allowStudentDownload;
        this.setAllowStudentDownloadIsSet(true);
        return this;
    }

    public void unsetAllowStudentDownload() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)7);
    }

    public boolean isSetAllowStudentDownload() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)7);
    }

    public void setAllowStudentDownloadIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)7, (boolean)value);
    }

    public long getVmSizeLimit() {
        return this.vmSizeLimit;
    }

    public SatelliteConfig setVmSizeLimit(long vmSizeLimit) {
        this.vmSizeLimit = vmSizeLimit;
        this.setVmSizeLimitIsSet(true);
        return this;
    }

    public void unsetVmSizeLimit() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)8);
    }

    public boolean isSetVmSizeLimit() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)8);
    }

    public void setVmSizeLimitIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)8, (boolean)value);
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case PAGE_SIZE: {
                if (value == null) {
                    this.unsetPageSize();
                    break;
                }
                this.setPageSize((Integer)value);
                break;
            }
            case DEFAULT_IMAGE_PERMISSIONS: {
                if (value == null) {
                    this.unsetDefaultImagePermissions();
                    break;
                }
                this.setDefaultImagePermissions((ImagePermissions)value);
                break;
            }
            case DEFAULT_LECTURE_PERMISSIONS: {
                if (value == null) {
                    this.unsetDefaultLecturePermissions();
                    break;
                }
                this.setDefaultLecturePermissions((LecturePermissions)value);
                break;
            }
            case MAX_IMAGE_VALIDITY_DAYS: {
                if (value == null) {
                    this.unsetMaxImageValidityDays();
                    break;
                }
                this.setMaxImageValidityDays((Integer)value);
                break;
            }
            case MAX_LECTURE_VALIDITY_DAYS: {
                if (value == null) {
                    this.unsetMaxLectureValidityDays();
                    break;
                }
                this.setMaxLectureValidityDays((Integer)value);
                break;
            }
            case MAX_TRANSFERS: {
                if (value == null) {
                    this.unsetMaxTransfers();
                    break;
                }
                this.setMaxTransfers((Integer)value);
                break;
            }
            case MAX_CONNECTIONS_PER_TRANSFER: {
                if (value == null) {
                    this.unsetMaxConnectionsPerTransfer();
                    break;
                }
                this.setMaxConnectionsPerTransfer((Integer)value);
                break;
            }
            case MAX_LOCATIONS_PER_LECTURE: {
                if (value == null) {
                    this.unsetMaxLocationsPerLecture();
                    break;
                }
                this.setMaxLocationsPerLecture((Integer)value);
                break;
            }
            case ALLOW_LOGIN_BY_DEFAULT: {
                if (value == null) {
                    this.unsetAllowLoginByDefault();
                    break;
                }
                this.setAllowLoginByDefault((Boolean)value);
                break;
            }
            case SERVER_SIDE_COPY: {
                if (value == null) {
                    this.unsetServerSideCopy();
                    break;
                }
                this.setServerSideCopy((SscMode)((Object)value));
                break;
            }
            case ALLOW_STUDENT_DOWNLOAD: {
                if (value == null) {
                    this.unsetAllowStudentDownload();
                    break;
                }
                this.setAllowStudentDownload((Boolean)value);
                break;
            }
            case VM_SIZE_LIMIT: {
                if (value == null) {
                    this.unsetVmSizeLimit();
                    break;
                }
                this.setVmSizeLimit((Long)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case PAGE_SIZE: {
                return this.getPageSize();
            }
            case DEFAULT_IMAGE_PERMISSIONS: {
                return this.getDefaultImagePermissions();
            }
            case DEFAULT_LECTURE_PERMISSIONS: {
                return this.getDefaultLecturePermissions();
            }
            case MAX_IMAGE_VALIDITY_DAYS: {
                return this.getMaxImageValidityDays();
            }
            case MAX_LECTURE_VALIDITY_DAYS: {
                return this.getMaxLectureValidityDays();
            }
            case MAX_TRANSFERS: {
                return this.getMaxTransfers();
            }
            case MAX_CONNECTIONS_PER_TRANSFER: {
                return this.getMaxConnectionsPerTransfer();
            }
            case MAX_LOCATIONS_PER_LECTURE: {
                return this.getMaxLocationsPerLecture();
            }
            case ALLOW_LOGIN_BY_DEFAULT: {
                return this.isAllowLoginByDefault();
            }
            case SERVER_SIDE_COPY: {
                return this.getServerSideCopy();
            }
            case ALLOW_STUDENT_DOWNLOAD: {
                return this.isAllowStudentDownload();
            }
            case VM_SIZE_LIMIT: {
                return this.getVmSizeLimit();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case PAGE_SIZE: {
                return this.isSetPageSize();
            }
            case DEFAULT_IMAGE_PERMISSIONS: {
                return this.isSetDefaultImagePermissions();
            }
            case DEFAULT_LECTURE_PERMISSIONS: {
                return this.isSetDefaultLecturePermissions();
            }
            case MAX_IMAGE_VALIDITY_DAYS: {
                return this.isSetMaxImageValidityDays();
            }
            case MAX_LECTURE_VALIDITY_DAYS: {
                return this.isSetMaxLectureValidityDays();
            }
            case MAX_TRANSFERS: {
                return this.isSetMaxTransfers();
            }
            case MAX_CONNECTIONS_PER_TRANSFER: {
                return this.isSetMaxConnectionsPerTransfer();
            }
            case MAX_LOCATIONS_PER_LECTURE: {
                return this.isSetMaxLocationsPerLecture();
            }
            case ALLOW_LOGIN_BY_DEFAULT: {
                return this.isSetAllowLoginByDefault();
            }
            case SERVER_SIDE_COPY: {
                return this.isSetServerSideCopy();
            }
            case ALLOW_STUDENT_DOWNLOAD: {
                return this.isSetAllowStudentDownload();
            }
            case VM_SIZE_LIMIT: {
                return this.isSetVmSizeLimit();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof SatelliteConfig) {
            return this.equals((SatelliteConfig)that);
        }
        return false;
    }

    public boolean equals(SatelliteConfig that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_pageSize = true;
        boolean that_present_pageSize = true;
        if (this_present_pageSize || that_present_pageSize) {
            if (!this_present_pageSize || !that_present_pageSize) {
                return false;
            }
            if (this.pageSize != that.pageSize) {
                return false;
            }
        }
        boolean this_present_defaultImagePermissions = this.isSetDefaultImagePermissions();
        boolean that_present_defaultImagePermissions = that.isSetDefaultImagePermissions();
        if (this_present_defaultImagePermissions || that_present_defaultImagePermissions) {
            if (!this_present_defaultImagePermissions || !that_present_defaultImagePermissions) {
                return false;
            }
            if (!this.defaultImagePermissions.equals(that.defaultImagePermissions)) {
                return false;
            }
        }
        boolean this_present_defaultLecturePermissions = this.isSetDefaultLecturePermissions();
        boolean that_present_defaultLecturePermissions = that.isSetDefaultLecturePermissions();
        if (this_present_defaultLecturePermissions || that_present_defaultLecturePermissions) {
            if (!this_present_defaultLecturePermissions || !that_present_defaultLecturePermissions) {
                return false;
            }
            if (!this.defaultLecturePermissions.equals(that.defaultLecturePermissions)) {
                return false;
            }
        }
        boolean this_present_maxImageValidityDays = true;
        boolean that_present_maxImageValidityDays = true;
        if (this_present_maxImageValidityDays || that_present_maxImageValidityDays) {
            if (!this_present_maxImageValidityDays || !that_present_maxImageValidityDays) {
                return false;
            }
            if (this.maxImageValidityDays != that.maxImageValidityDays) {
                return false;
            }
        }
        boolean this_present_maxLectureValidityDays = true;
        boolean that_present_maxLectureValidityDays = true;
        if (this_present_maxLectureValidityDays || that_present_maxLectureValidityDays) {
            if (!this_present_maxLectureValidityDays || !that_present_maxLectureValidityDays) {
                return false;
            }
            if (this.maxLectureValidityDays != that.maxLectureValidityDays) {
                return false;
            }
        }
        boolean this_present_maxTransfers = this.isSetMaxTransfers();
        boolean that_present_maxTransfers = that.isSetMaxTransfers();
        if (this_present_maxTransfers || that_present_maxTransfers) {
            if (!this_present_maxTransfers || !that_present_maxTransfers) {
                return false;
            }
            if (this.maxTransfers != that.maxTransfers) {
                return false;
            }
        }
        boolean this_present_maxConnectionsPerTransfer = this.isSetMaxConnectionsPerTransfer();
        boolean that_present_maxConnectionsPerTransfer = that.isSetMaxConnectionsPerTransfer();
        if (this_present_maxConnectionsPerTransfer || that_present_maxConnectionsPerTransfer) {
            if (!this_present_maxConnectionsPerTransfer || !that_present_maxConnectionsPerTransfer) {
                return false;
            }
            if (this.maxConnectionsPerTransfer != that.maxConnectionsPerTransfer) {
                return false;
            }
        }
        boolean this_present_maxLocationsPerLecture = this.isSetMaxLocationsPerLecture();
        boolean that_present_maxLocationsPerLecture = that.isSetMaxLocationsPerLecture();
        if (this_present_maxLocationsPerLecture || that_present_maxLocationsPerLecture) {
            if (!this_present_maxLocationsPerLecture || !that_present_maxLocationsPerLecture) {
                return false;
            }
            if (this.maxLocationsPerLecture != that.maxLocationsPerLecture) {
                return false;
            }
        }
        boolean this_present_allowLoginByDefault = this.isSetAllowLoginByDefault();
        boolean that_present_allowLoginByDefault = that.isSetAllowLoginByDefault();
        if (this_present_allowLoginByDefault || that_present_allowLoginByDefault) {
            if (!this_present_allowLoginByDefault || !that_present_allowLoginByDefault) {
                return false;
            }
            if (this.allowLoginByDefault != that.allowLoginByDefault) {
                return false;
            }
        }
        boolean this_present_serverSideCopy = this.isSetServerSideCopy();
        boolean that_present_serverSideCopy = that.isSetServerSideCopy();
        if (this_present_serverSideCopy || that_present_serverSideCopy) {
            if (!this_present_serverSideCopy || !that_present_serverSideCopy) {
                return false;
            }
            if (!this.serverSideCopy.equals((Object)that.serverSideCopy)) {
                return false;
            }
        }
        boolean this_present_allowStudentDownload = this.isSetAllowStudentDownload();
        boolean that_present_allowStudentDownload = that.isSetAllowStudentDownload();
        if (this_present_allowStudentDownload || that_present_allowStudentDownload) {
            if (!this_present_allowStudentDownload || !that_present_allowStudentDownload) {
                return false;
            }
            if (this.allowStudentDownload != that.allowStudentDownload) {
                return false;
            }
        }
        boolean this_present_vmSizeLimit = this.isSetVmSizeLimit();
        boolean that_present_vmSizeLimit = that.isSetVmSizeLimit();
        if (this_present_vmSizeLimit || that_present_vmSizeLimit) {
            if (!this_present_vmSizeLimit || !that_present_vmSizeLimit) {
                return false;
            }
            if (this.vmSizeLimit != that.vmSizeLimit) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + this.pageSize;
        hashCode = hashCode * 8191 + (this.isSetDefaultImagePermissions() ? 131071 : 524287);
        if (this.isSetDefaultImagePermissions()) {
            hashCode = hashCode * 8191 + this.defaultImagePermissions.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetDefaultLecturePermissions() ? 131071 : 524287);
        if (this.isSetDefaultLecturePermissions()) {
            hashCode = hashCode * 8191 + this.defaultLecturePermissions.hashCode();
        }
        hashCode = hashCode * 8191 + this.maxImageValidityDays;
        hashCode = hashCode * 8191 + this.maxLectureValidityDays;
        hashCode = hashCode * 8191 + (this.isSetMaxTransfers() ? 131071 : 524287);
        if (this.isSetMaxTransfers()) {
            hashCode = hashCode * 8191 + this.maxTransfers;
        }
        hashCode = hashCode * 8191 + (this.isSetMaxConnectionsPerTransfer() ? 131071 : 524287);
        if (this.isSetMaxConnectionsPerTransfer()) {
            hashCode = hashCode * 8191 + this.maxConnectionsPerTransfer;
        }
        hashCode = hashCode * 8191 + (this.isSetMaxLocationsPerLecture() ? 131071 : 524287);
        if (this.isSetMaxLocationsPerLecture()) {
            hashCode = hashCode * 8191 + this.maxLocationsPerLecture;
        }
        hashCode = hashCode * 8191 + (this.isSetAllowLoginByDefault() ? 131071 : 524287);
        if (this.isSetAllowLoginByDefault()) {
            hashCode = hashCode * 8191 + (this.allowLoginByDefault ? 131071 : 524287);
        }
        hashCode = hashCode * 8191 + (this.isSetServerSideCopy() ? 131071 : 524287);
        if (this.isSetServerSideCopy()) {
            hashCode = hashCode * 8191 + this.serverSideCopy.getValue();
        }
        hashCode = hashCode * 8191 + (this.isSetAllowStudentDownload() ? 131071 : 524287);
        if (this.isSetAllowStudentDownload()) {
            hashCode = hashCode * 8191 + (this.allowStudentDownload ? 131071 : 524287);
        }
        hashCode = hashCode * 8191 + (this.isSetVmSizeLimit() ? 131071 : 524287);
        if (this.isSetVmSizeLimit()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.vmSizeLimit);
        }
        return hashCode;
    }

    @Override
    public int compareTo(SatelliteConfig other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetPageSize(), other.isSetPageSize());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPageSize() && (lastComparison = TBaseHelper.compareTo((int)this.pageSize, (int)other.pageSize)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetDefaultImagePermissions(), other.isSetDefaultImagePermissions());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDefaultImagePermissions() && (lastComparison = TBaseHelper.compareTo((Comparable)this.defaultImagePermissions, (Comparable)other.defaultImagePermissions)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetDefaultLecturePermissions(), other.isSetDefaultLecturePermissions());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDefaultLecturePermissions() && (lastComparison = TBaseHelper.compareTo((Comparable)this.defaultLecturePermissions, (Comparable)other.defaultLecturePermissions)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetMaxImageValidityDays(), other.isSetMaxImageValidityDays());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMaxImageValidityDays() && (lastComparison = TBaseHelper.compareTo((int)this.maxImageValidityDays, (int)other.maxImageValidityDays)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetMaxLectureValidityDays(), other.isSetMaxLectureValidityDays());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMaxLectureValidityDays() && (lastComparison = TBaseHelper.compareTo((int)this.maxLectureValidityDays, (int)other.maxLectureValidityDays)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetMaxTransfers(), other.isSetMaxTransfers());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMaxTransfers() && (lastComparison = TBaseHelper.compareTo((int)this.maxTransfers, (int)other.maxTransfers)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetMaxConnectionsPerTransfer(), other.isSetMaxConnectionsPerTransfer());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMaxConnectionsPerTransfer() && (lastComparison = TBaseHelper.compareTo((int)this.maxConnectionsPerTransfer, (int)other.maxConnectionsPerTransfer)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetMaxLocationsPerLecture(), other.isSetMaxLocationsPerLecture());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMaxLocationsPerLecture() && (lastComparison = TBaseHelper.compareTo((int)this.maxLocationsPerLecture, (int)other.maxLocationsPerLecture)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetAllowLoginByDefault(), other.isSetAllowLoginByDefault());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAllowLoginByDefault() && (lastComparison = TBaseHelper.compareTo((boolean)this.allowLoginByDefault, (boolean)other.allowLoginByDefault)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetServerSideCopy(), other.isSetServerSideCopy());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetServerSideCopy() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.serverSideCopy), (Comparable)((Object)other.serverSideCopy))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetAllowStudentDownload(), other.isSetAllowStudentDownload());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAllowStudentDownload() && (lastComparison = TBaseHelper.compareTo((boolean)this.allowStudentDownload, (boolean)other.allowStudentDownload)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetVmSizeLimit(), other.isSetVmSizeLimit());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetVmSizeLimit() && (lastComparison = TBaseHelper.compareTo((long)this.vmSizeLimit, (long)other.vmSizeLimit)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        SatelliteConfig.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        SatelliteConfig.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SatelliteConfig(");
        boolean first = true;
        sb.append("pageSize:");
        sb.append(this.pageSize);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("defaultImagePermissions:");
        if (this.defaultImagePermissions == null) {
            sb.append("null");
        } else {
            sb.append(this.defaultImagePermissions);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("defaultLecturePermissions:");
        if (this.defaultLecturePermissions == null) {
            sb.append("null");
        } else {
            sb.append(this.defaultLecturePermissions);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("maxImageValidityDays:");
        sb.append(this.maxImageValidityDays);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("maxLectureValidityDays:");
        sb.append(this.maxLectureValidityDays);
        first = false;
        if (this.isSetMaxTransfers()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("maxTransfers:");
            sb.append(this.maxTransfers);
            first = false;
        }
        if (this.isSetMaxConnectionsPerTransfer()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("maxConnectionsPerTransfer:");
            sb.append(this.maxConnectionsPerTransfer);
            first = false;
        }
        if (this.isSetMaxLocationsPerLecture()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("maxLocationsPerLecture:");
            sb.append(this.maxLocationsPerLecture);
            first = false;
        }
        if (this.isSetAllowLoginByDefault()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("allowLoginByDefault:");
            sb.append(this.allowLoginByDefault);
            first = false;
        }
        if (this.isSetServerSideCopy()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("serverSideCopy:");
            if (this.serverSideCopy == null) {
                sb.append("null");
            } else {
                sb.append((Object)this.serverSideCopy);
            }
            first = false;
        }
        if (this.isSetAllowStudentDownload()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("allowStudentDownload:");
            sb.append(this.allowStudentDownload);
            first = false;
        }
        if (this.isSetVmSizeLimit()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("vmSizeLimit:");
            sb.append(this.vmSizeLimit);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.defaultImagePermissions != null) {
            this.defaultImagePermissions.validate();
        }
        if (this.defaultLecturePermissions != null) {
            this.defaultLecturePermissions.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.PAGE_SIZE, new FieldMetaData("pageSize", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.DEFAULT_IMAGE_PERMISSIONS, new FieldMetaData("defaultImagePermissions", 3, (FieldValueMetaData)new StructMetaData(12, ImagePermissions.class)));
        tmpMap.put(_Fields.DEFAULT_LECTURE_PERMISSIONS, new FieldMetaData("defaultLecturePermissions", 3, (FieldValueMetaData)new StructMetaData(12, LecturePermissions.class)));
        tmpMap.put(_Fields.MAX_IMAGE_VALIDITY_DAYS, new FieldMetaData("maxImageValidityDays", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.MAX_LECTURE_VALIDITY_DAYS, new FieldMetaData("maxLectureValidityDays", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.MAX_TRANSFERS, new FieldMetaData("maxTransfers", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.MAX_CONNECTIONS_PER_TRANSFER, new FieldMetaData("maxConnectionsPerTransfer", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.MAX_LOCATIONS_PER_LECTURE, new FieldMetaData("maxLocationsPerLecture", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.ALLOW_LOGIN_BY_DEFAULT, new FieldMetaData("allowLoginByDefault", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.SERVER_SIDE_COPY, new FieldMetaData("serverSideCopy", 2, (FieldValueMetaData)new EnumMetaData(16, SscMode.class)));
        tmpMap.put(_Fields.ALLOW_STUDENT_DOWNLOAD, new FieldMetaData("allowStudentDownload", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.VM_SIZE_LIMIT, new FieldMetaData("vmSizeLimit", 2, new FieldValueMetaData(10)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(SatelliteConfig.class, metaDataMap);
    }

    private static class SatelliteConfigTupleScheme
    extends TupleScheme<SatelliteConfig> {
        private SatelliteConfigTupleScheme() {
        }

        public void write(TProtocol prot, SatelliteConfig struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetPageSize()) {
                optionals.set(0);
            }
            if (struct.isSetDefaultImagePermissions()) {
                optionals.set(1);
            }
            if (struct.isSetDefaultLecturePermissions()) {
                optionals.set(2);
            }
            if (struct.isSetMaxImageValidityDays()) {
                optionals.set(3);
            }
            if (struct.isSetMaxLectureValidityDays()) {
                optionals.set(4);
            }
            if (struct.isSetMaxTransfers()) {
                optionals.set(5);
            }
            if (struct.isSetMaxConnectionsPerTransfer()) {
                optionals.set(6);
            }
            if (struct.isSetMaxLocationsPerLecture()) {
                optionals.set(7);
            }
            if (struct.isSetAllowLoginByDefault()) {
                optionals.set(8);
            }
            if (struct.isSetServerSideCopy()) {
                optionals.set(9);
            }
            if (struct.isSetAllowStudentDownload()) {
                optionals.set(10);
            }
            if (struct.isSetVmSizeLimit()) {
                optionals.set(11);
            }
            oprot.writeBitSet(optionals, 12);
            if (struct.isSetPageSize()) {
                oprot.writeI32(struct.pageSize);
            }
            if (struct.isSetDefaultImagePermissions()) {
                struct.defaultImagePermissions.write((TProtocol)oprot);
            }
            if (struct.isSetDefaultLecturePermissions()) {
                struct.defaultLecturePermissions.write((TProtocol)oprot);
            }
            if (struct.isSetMaxImageValidityDays()) {
                oprot.writeI32(struct.maxImageValidityDays);
            }
            if (struct.isSetMaxLectureValidityDays()) {
                oprot.writeI32(struct.maxLectureValidityDays);
            }
            if (struct.isSetMaxTransfers()) {
                oprot.writeI32(struct.maxTransfers);
            }
            if (struct.isSetMaxConnectionsPerTransfer()) {
                oprot.writeI32(struct.maxConnectionsPerTransfer);
            }
            if (struct.isSetMaxLocationsPerLecture()) {
                oprot.writeI32(struct.maxLocationsPerLecture);
            }
            if (struct.isSetAllowLoginByDefault()) {
                oprot.writeBool(struct.allowLoginByDefault);
            }
            if (struct.isSetServerSideCopy()) {
                oprot.writeI32(struct.serverSideCopy.getValue());
            }
            if (struct.isSetAllowStudentDownload()) {
                oprot.writeBool(struct.allowStudentDownload);
            }
            if (struct.isSetVmSizeLimit()) {
                oprot.writeI64(struct.vmSizeLimit);
            }
        }

        public void read(TProtocol prot, SatelliteConfig struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(12);
            if (incoming.get(0)) {
                struct.pageSize = iprot.readI32();
                struct.setPageSizeIsSet(true);
            }
            if (incoming.get(1)) {
                struct.defaultImagePermissions = new ImagePermissions();
                struct.defaultImagePermissions.read((TProtocol)iprot);
                struct.setDefaultImagePermissionsIsSet(true);
            }
            if (incoming.get(2)) {
                struct.defaultLecturePermissions = new LecturePermissions();
                struct.defaultLecturePermissions.read((TProtocol)iprot);
                struct.setDefaultLecturePermissionsIsSet(true);
            }
            if (incoming.get(3)) {
                struct.maxImageValidityDays = iprot.readI32();
                struct.setMaxImageValidityDaysIsSet(true);
            }
            if (incoming.get(4)) {
                struct.maxLectureValidityDays = iprot.readI32();
                struct.setMaxLectureValidityDaysIsSet(true);
            }
            if (incoming.get(5)) {
                struct.maxTransfers = iprot.readI32();
                struct.setMaxTransfersIsSet(true);
            }
            if (incoming.get(6)) {
                struct.maxConnectionsPerTransfer = iprot.readI32();
                struct.setMaxConnectionsPerTransferIsSet(true);
            }
            if (incoming.get(7)) {
                struct.maxLocationsPerLecture = iprot.readI32();
                struct.setMaxLocationsPerLectureIsSet(true);
            }
            if (incoming.get(8)) {
                struct.allowLoginByDefault = iprot.readBool();
                struct.setAllowLoginByDefaultIsSet(true);
            }
            if (incoming.get(9)) {
                struct.serverSideCopy = SscMode.findByValue(iprot.readI32());
                struct.setServerSideCopyIsSet(true);
            }
            if (incoming.get(10)) {
                struct.allowStudentDownload = iprot.readBool();
                struct.setAllowStudentDownloadIsSet(true);
            }
            if (incoming.get(11)) {
                struct.vmSizeLimit = iprot.readI64();
                struct.setVmSizeLimitIsSet(true);
            }
        }
    }

    private static class SatelliteConfigTupleSchemeFactory
    implements SchemeFactory {
        private SatelliteConfigTupleSchemeFactory() {
        }

        public SatelliteConfigTupleScheme getScheme() {
            return new SatelliteConfigTupleScheme();
        }
    }

    private static class SatelliteConfigStandardScheme
    extends StandardScheme<SatelliteConfig> {
        private SatelliteConfigStandardScheme() {
        }

        public void read(TProtocol iprot, SatelliteConfig struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 8) {
                            struct.pageSize = iprot.readI32();
                            struct.setPageSizeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 12) {
                            struct.defaultImagePermissions = new ImagePermissions();
                            struct.defaultImagePermissions.read(iprot);
                            struct.setDefaultImagePermissionsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 12) {
                            struct.defaultLecturePermissions = new LecturePermissions();
                            struct.defaultLecturePermissions.read(iprot);
                            struct.setDefaultLecturePermissionsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 8) {
                            struct.maxImageValidityDays = iprot.readI32();
                            struct.setMaxImageValidityDaysIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 8) {
                            struct.maxLectureValidityDays = iprot.readI32();
                            struct.setMaxLectureValidityDaysIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 8) {
                            struct.maxTransfers = iprot.readI32();
                            struct.setMaxTransfersIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 8) {
                            struct.maxConnectionsPerTransfer = iprot.readI32();
                            struct.setMaxConnectionsPerTransferIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 8) {
                            struct.maxLocationsPerLecture = iprot.readI32();
                            struct.setMaxLocationsPerLectureIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 2) {
                            struct.allowLoginByDefault = iprot.readBool();
                            struct.setAllowLoginByDefaultIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 8) {
                            struct.serverSideCopy = SscMode.findByValue(iprot.readI32());
                            struct.setServerSideCopyIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 2) {
                            struct.allowStudentDownload = iprot.readBool();
                            struct.setAllowStudentDownloadIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 12: {
                        if (schemeField.type == 10) {
                            struct.vmSizeLimit = iprot.readI64();
                            struct.setVmSizeLimitIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, SatelliteConfig struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            oprot.writeFieldBegin(PAGE_SIZE_FIELD_DESC);
            oprot.writeI32(struct.pageSize);
            oprot.writeFieldEnd();
            if (struct.defaultImagePermissions != null) {
                oprot.writeFieldBegin(DEFAULT_IMAGE_PERMISSIONS_FIELD_DESC);
                struct.defaultImagePermissions.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.defaultLecturePermissions != null) {
                oprot.writeFieldBegin(DEFAULT_LECTURE_PERMISSIONS_FIELD_DESC);
                struct.defaultLecturePermissions.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(MAX_IMAGE_VALIDITY_DAYS_FIELD_DESC);
            oprot.writeI32(struct.maxImageValidityDays);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(MAX_LECTURE_VALIDITY_DAYS_FIELD_DESC);
            oprot.writeI32(struct.maxLectureValidityDays);
            oprot.writeFieldEnd();
            if (struct.isSetMaxTransfers()) {
                oprot.writeFieldBegin(MAX_TRANSFERS_FIELD_DESC);
                oprot.writeI32(struct.maxTransfers);
                oprot.writeFieldEnd();
            }
            if (struct.isSetMaxConnectionsPerTransfer()) {
                oprot.writeFieldBegin(MAX_CONNECTIONS_PER_TRANSFER_FIELD_DESC);
                oprot.writeI32(struct.maxConnectionsPerTransfer);
                oprot.writeFieldEnd();
            }
            if (struct.isSetMaxLocationsPerLecture()) {
                oprot.writeFieldBegin(MAX_LOCATIONS_PER_LECTURE_FIELD_DESC);
                oprot.writeI32(struct.maxLocationsPerLecture);
                oprot.writeFieldEnd();
            }
            if (struct.isSetAllowLoginByDefault()) {
                oprot.writeFieldBegin(ALLOW_LOGIN_BY_DEFAULT_FIELD_DESC);
                oprot.writeBool(struct.allowLoginByDefault);
                oprot.writeFieldEnd();
            }
            if (struct.serverSideCopy != null && struct.isSetServerSideCopy()) {
                oprot.writeFieldBegin(SERVER_SIDE_COPY_FIELD_DESC);
                oprot.writeI32(struct.serverSideCopy.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.isSetAllowStudentDownload()) {
                oprot.writeFieldBegin(ALLOW_STUDENT_DOWNLOAD_FIELD_DESC);
                oprot.writeBool(struct.allowStudentDownload);
                oprot.writeFieldEnd();
            }
            if (struct.isSetVmSizeLimit()) {
                oprot.writeFieldBegin(VM_SIZE_LIMIT_FIELD_DESC);
                oprot.writeI64(struct.vmSizeLimit);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class SatelliteConfigStandardSchemeFactory
    implements SchemeFactory {
        private SatelliteConfigStandardSchemeFactory() {
        }

        public SatelliteConfigStandardScheme getScheme() {
            return new SatelliteConfigStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        PAGE_SIZE(1, "pageSize"),
        DEFAULT_IMAGE_PERMISSIONS(2, "defaultImagePermissions"),
        DEFAULT_LECTURE_PERMISSIONS(3, "defaultLecturePermissions"),
        MAX_IMAGE_VALIDITY_DAYS(4, "maxImageValidityDays"),
        MAX_LECTURE_VALIDITY_DAYS(5, "maxLectureValidityDays"),
        MAX_TRANSFERS(6, "maxTransfers"),
        MAX_CONNECTIONS_PER_TRANSFER(7, "maxConnectionsPerTransfer"),
        MAX_LOCATIONS_PER_LECTURE(8, "maxLocationsPerLecture"),
        ALLOW_LOGIN_BY_DEFAULT(9, "allowLoginByDefault"),
        SERVER_SIDE_COPY(10, "serverSideCopy"),
        ALLOW_STUDENT_DOWNLOAD(11, "allowStudentDownload"),
        VM_SIZE_LIMIT(12, "vmSizeLimit");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return PAGE_SIZE;
                }
                case 2: {
                    return DEFAULT_IMAGE_PERMISSIONS;
                }
                case 3: {
                    return DEFAULT_LECTURE_PERMISSIONS;
                }
                case 4: {
                    return MAX_IMAGE_VALIDITY_DAYS;
                }
                case 5: {
                    return MAX_LECTURE_VALIDITY_DAYS;
                }
                case 6: {
                    return MAX_TRANSFERS;
                }
                case 7: {
                    return MAX_CONNECTIONS_PER_TRANSFER;
                }
                case 8: {
                    return MAX_LOCATIONS_PER_LECTURE;
                }
                case 9: {
                    return ALLOW_LOGIN_BY_DEFAULT;
                }
                case 10: {
                    return SERVER_SIDE_COPY;
                }
                case 11: {
                    return ALLOW_STUDENT_DOWNLOAD;
                }
                case 12: {
                    return VM_SIZE_LIMIT;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

