/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.bwlp.thrift.iface;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TransferInformation
implements TBase<TransferInformation, _Fields>,
Serializable,
Cloneable,
Comparable<TransferInformation> {
    private static final TStruct STRUCT_DESC = new TStruct("TransferInformation");
    private static final TField TOKEN_FIELD_DESC = new TField("token", 11, 1);
    private static final TField PLAIN_PORT_FIELD_DESC = new TField("plainPort", 8, 2);
    private static final TField SSL_PORT_FIELD_DESC = new TField("sslPort", 8, 3);
    private static final TField BLOCK_HASHES_FIELD_DESC = new TField("blockHashes", 15, 4);
    private static final TField MACHINE_DESCRIPTION_FIELD_DESC = new TField("machineDescription", 11, 5);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TransferInformationStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TransferInformationTupleSchemeFactory();
    @Nullable
    public String token;
    public int plainPort;
    public int sslPort;
    @Nullable
    public List<ByteBuffer> blockHashes;
    @Nullable
    public ByteBuffer machineDescription;
    private static final int __PLAINPORT_ISSET_ID = 0;
    private static final int __SSLPORT_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.BLOCK_HASHES, _Fields.MACHINE_DESCRIPTION};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TransferInformation() {
    }

    public TransferInformation(String token, int plainPort, int sslPort) {
        this();
        this.token = token;
        this.plainPort = plainPort;
        this.setPlainPortIsSet(true);
        this.sslPort = sslPort;
        this.setSslPortIsSet(true);
    }

    public TransferInformation(TransferInformation other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetToken()) {
            this.token = other.token;
        }
        this.plainPort = other.plainPort;
        this.sslPort = other.sslPort;
        if (other.isSetBlockHashes()) {
            ArrayList<ByteBuffer> __this__blockHashes = new ArrayList<ByteBuffer>(other.blockHashes);
            this.blockHashes = __this__blockHashes;
        }
        if (other.isSetMachineDescription()) {
            this.machineDescription = TBaseHelper.copyBinary((ByteBuffer)other.machineDescription);
        }
    }

    public TransferInformation deepCopy() {
        return new TransferInformation(this);
    }

    public void clear() {
        this.token = null;
        this.setPlainPortIsSet(false);
        this.plainPort = 0;
        this.setSslPortIsSet(false);
        this.sslPort = 0;
        this.blockHashes = null;
        this.machineDescription = null;
    }

    @Nullable
    public String getToken() {
        return this.token;
    }

    public TransferInformation setToken(@Nullable String token) {
        this.token = token;
        return this;
    }

    public void unsetToken() {
        this.token = null;
    }

    public boolean isSetToken() {
        return this.token != null;
    }

    public void setTokenIsSet(boolean value) {
        if (!value) {
            this.token = null;
        }
    }

    public int getPlainPort() {
        return this.plainPort;
    }

    public TransferInformation setPlainPort(int plainPort) {
        this.plainPort = plainPort;
        this.setPlainPortIsSet(true);
        return this;
    }

    public void unsetPlainPort() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetPlainPort() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setPlainPortIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public int getSslPort() {
        return this.sslPort;
    }

    public TransferInformation setSslPort(int sslPort) {
        this.sslPort = sslPort;
        this.setSslPortIsSet(true);
        return this;
    }

    public void unsetSslPort() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetSslPort() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setSslPortIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public int getBlockHashesSize() {
        return this.blockHashes == null ? 0 : this.blockHashes.size();
    }

    @Nullable
    public Iterator<ByteBuffer> getBlockHashesIterator() {
        return this.blockHashes == null ? null : this.blockHashes.iterator();
    }

    public void addToBlockHashes(ByteBuffer elem) {
        if (this.blockHashes == null) {
            this.blockHashes = new ArrayList<ByteBuffer>();
        }
        this.blockHashes.add(elem);
    }

    @Nullable
    public List<ByteBuffer> getBlockHashes() {
        return this.blockHashes;
    }

    public TransferInformation setBlockHashes(@Nullable List<ByteBuffer> blockHashes) {
        this.blockHashes = blockHashes;
        return this;
    }

    public void unsetBlockHashes() {
        this.blockHashes = null;
    }

    public boolean isSetBlockHashes() {
        return this.blockHashes != null;
    }

    public void setBlockHashesIsSet(boolean value) {
        if (!value) {
            this.blockHashes = null;
        }
    }

    public byte[] getMachineDescription() {
        this.setMachineDescription(TBaseHelper.rightSize((ByteBuffer)this.machineDescription));
        return this.machineDescription == null ? null : this.machineDescription.array();
    }

    public ByteBuffer bufferForMachineDescription() {
        return TBaseHelper.copyBinary((ByteBuffer)this.machineDescription);
    }

    public TransferInformation setMachineDescription(byte[] machineDescription) {
        this.machineDescription = machineDescription == null ? (ByteBuffer)null : ByteBuffer.wrap((byte[])machineDescription.clone());
        return this;
    }

    public TransferInformation setMachineDescription(@Nullable ByteBuffer machineDescription) {
        this.machineDescription = TBaseHelper.copyBinary((ByteBuffer)machineDescription);
        return this;
    }

    public void unsetMachineDescription() {
        this.machineDescription = null;
    }

    public boolean isSetMachineDescription() {
        return this.machineDescription != null;
    }

    public void setMachineDescriptionIsSet(boolean value) {
        if (!value) {
            this.machineDescription = null;
        }
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case TOKEN: {
                if (value == null) {
                    this.unsetToken();
                    break;
                }
                this.setToken((String)value);
                break;
            }
            case PLAIN_PORT: {
                if (value == null) {
                    this.unsetPlainPort();
                    break;
                }
                this.setPlainPort((Integer)value);
                break;
            }
            case SSL_PORT: {
                if (value == null) {
                    this.unsetSslPort();
                    break;
                }
                this.setSslPort((Integer)value);
                break;
            }
            case BLOCK_HASHES: {
                if (value == null) {
                    this.unsetBlockHashes();
                    break;
                }
                this.setBlockHashes((List)value);
                break;
            }
            case MACHINE_DESCRIPTION: {
                if (value == null) {
                    this.unsetMachineDescription();
                    break;
                }
                if (value instanceof byte[]) {
                    this.setMachineDescription((byte[])value);
                    break;
                }
                this.setMachineDescription((ByteBuffer)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case TOKEN: {
                return this.getToken();
            }
            case PLAIN_PORT: {
                return this.getPlainPort();
            }
            case SSL_PORT: {
                return this.getSslPort();
            }
            case BLOCK_HASHES: {
                return this.getBlockHashes();
            }
            case MACHINE_DESCRIPTION: {
                return this.getMachineDescription();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case TOKEN: {
                return this.isSetToken();
            }
            case PLAIN_PORT: {
                return this.isSetPlainPort();
            }
            case SSL_PORT: {
                return this.isSetSslPort();
            }
            case BLOCK_HASHES: {
                return this.isSetBlockHashes();
            }
            case MACHINE_DESCRIPTION: {
                return this.isSetMachineDescription();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof TransferInformation) {
            return this.equals((TransferInformation)that);
        }
        return false;
    }

    public boolean equals(TransferInformation that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_token = this.isSetToken();
        boolean that_present_token = that.isSetToken();
        if (this_present_token || that_present_token) {
            if (!this_present_token || !that_present_token) {
                return false;
            }
            if (!this.token.equals(that.token)) {
                return false;
            }
        }
        boolean this_present_plainPort = true;
        boolean that_present_plainPort = true;
        if (this_present_plainPort || that_present_plainPort) {
            if (!this_present_plainPort || !that_present_plainPort) {
                return false;
            }
            if (this.plainPort != that.plainPort) {
                return false;
            }
        }
        boolean this_present_sslPort = true;
        boolean that_present_sslPort = true;
        if (this_present_sslPort || that_present_sslPort) {
            if (!this_present_sslPort || !that_present_sslPort) {
                return false;
            }
            if (this.sslPort != that.sslPort) {
                return false;
            }
        }
        boolean this_present_blockHashes = this.isSetBlockHashes();
        boolean that_present_blockHashes = that.isSetBlockHashes();
        if (this_present_blockHashes || that_present_blockHashes) {
            if (!this_present_blockHashes || !that_present_blockHashes) {
                return false;
            }
            if (!this.blockHashes.equals(that.blockHashes)) {
                return false;
            }
        }
        boolean this_present_machineDescription = this.isSetMachineDescription();
        boolean that_present_machineDescription = that.isSetMachineDescription();
        if (this_present_machineDescription || that_present_machineDescription) {
            if (!this_present_machineDescription || !that_present_machineDescription) {
                return false;
            }
            if (!this.machineDescription.equals(that.machineDescription)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetToken() ? 131071 : 524287);
        if (this.isSetToken()) {
            hashCode = hashCode * 8191 + this.token.hashCode();
        }
        hashCode = hashCode * 8191 + this.plainPort;
        hashCode = hashCode * 8191 + this.sslPort;
        hashCode = hashCode * 8191 + (this.isSetBlockHashes() ? 131071 : 524287);
        if (this.isSetBlockHashes()) {
            hashCode = hashCode * 8191 + this.blockHashes.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetMachineDescription() ? 131071 : 524287);
        if (this.isSetMachineDescription()) {
            hashCode = hashCode * 8191 + this.machineDescription.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(TransferInformation other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetToken(), other.isSetToken());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetToken() && (lastComparison = TBaseHelper.compareTo((String)this.token, (String)other.token)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetPlainPort(), other.isSetPlainPort());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPlainPort() && (lastComparison = TBaseHelper.compareTo((int)this.plainPort, (int)other.plainPort)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetSslPort(), other.isSetSslPort());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSslPort() && (lastComparison = TBaseHelper.compareTo((int)this.sslPort, (int)other.sslPort)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetBlockHashes(), other.isSetBlockHashes());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetBlockHashes() && (lastComparison = TBaseHelper.compareTo(this.blockHashes, other.blockHashes)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetMachineDescription(), other.isSetMachineDescription());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMachineDescription() && (lastComparison = TBaseHelper.compareTo((Comparable)this.machineDescription, (Comparable)other.machineDescription)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        TransferInformation.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        TransferInformation.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TransferInformation(");
        boolean first = true;
        sb.append("token:");
        if (this.token == null) {
            sb.append("null");
        } else {
            sb.append(this.token);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("plainPort:");
        sb.append(this.plainPort);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("sslPort:");
        sb.append(this.sslPort);
        first = false;
        if (this.isSetBlockHashes()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("blockHashes:");
            if (this.blockHashes == null) {
                sb.append("null");
            } else {
                TBaseHelper.toString(this.blockHashes, (StringBuilder)sb);
            }
            first = false;
        }
        if (this.isSetMachineDescription()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("machineDescription:");
            if (this.machineDescription == null) {
                sb.append("null");
            } else {
                TBaseHelper.toString((ByteBuffer)this.machineDescription, (StringBuilder)sb);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.TOKEN, new FieldMetaData("token", 3, new FieldValueMetaData(11, "Token")));
        tmpMap.put(_Fields.PLAIN_PORT, new FieldMetaData("plainPort", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.SSL_PORT, new FieldMetaData("sslPort", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.BLOCK_HASHES, new FieldMetaData("blockHashes", 2, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(11, true))));
        tmpMap.put(_Fields.MACHINE_DESCRIPTION, new FieldMetaData("machineDescription", 2, new FieldValueMetaData(11, true)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TransferInformation.class, metaDataMap);
    }

    private static class TransferInformationTupleScheme
    extends TupleScheme<TransferInformation> {
        private TransferInformationTupleScheme() {
        }

        public void write(TProtocol prot, TransferInformation struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetToken()) {
                optionals.set(0);
            }
            if (struct.isSetPlainPort()) {
                optionals.set(1);
            }
            if (struct.isSetSslPort()) {
                optionals.set(2);
            }
            if (struct.isSetBlockHashes()) {
                optionals.set(3);
            }
            if (struct.isSetMachineDescription()) {
                optionals.set(4);
            }
            oprot.writeBitSet(optionals, 5);
            if (struct.isSetToken()) {
                oprot.writeString(struct.token);
            }
            if (struct.isSetPlainPort()) {
                oprot.writeI32(struct.plainPort);
            }
            if (struct.isSetSslPort()) {
                oprot.writeI32(struct.sslPort);
            }
            if (struct.isSetBlockHashes()) {
                oprot.writeI32(struct.blockHashes.size());
                for (ByteBuffer _iter294 : struct.blockHashes) {
                    oprot.writeBinary(_iter294);
                }
            }
            if (struct.isSetMachineDescription()) {
                oprot.writeBinary(struct.machineDescription);
            }
        }

        public void read(TProtocol prot, TransferInformation struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(5);
            if (incoming.get(0)) {
                struct.token = iprot.readString();
                struct.setTokenIsSet(true);
            }
            if (incoming.get(1)) {
                struct.plainPort = iprot.readI32();
                struct.setPlainPortIsSet(true);
            }
            if (incoming.get(2)) {
                struct.sslPort = iprot.readI32();
                struct.setSslPortIsSet(true);
            }
            if (incoming.get(3)) {
                TList _list295 = iprot.readListBegin((byte)11);
                struct.blockHashes = new ArrayList<ByteBuffer>(_list295.size);
                for (int _i297 = 0; _i297 < _list295.size; ++_i297) {
                    ByteBuffer _elem296 = iprot.readBinary();
                    struct.blockHashes.add(_elem296);
                }
                struct.setBlockHashesIsSet(true);
            }
            if (incoming.get(4)) {
                struct.machineDescription = iprot.readBinary();
                struct.setMachineDescriptionIsSet(true);
            }
        }
    }

    private static class TransferInformationTupleSchemeFactory
    implements SchemeFactory {
        private TransferInformationTupleSchemeFactory() {
        }

        public TransferInformationTupleScheme getScheme() {
            return new TransferInformationTupleScheme();
        }
    }

    private static class TransferInformationStandardScheme
    extends StandardScheme<TransferInformation> {
        private TransferInformationStandardScheme() {
        }

        public void read(TProtocol iprot, TransferInformation struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.token = iprot.readString();
                            struct.setTokenIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 8) {
                            struct.plainPort = iprot.readI32();
                            struct.setPlainPortIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 8) {
                            struct.sslPort = iprot.readI32();
                            struct.setSslPortIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 15) {
                            TList _list290 = iprot.readListBegin();
                            struct.blockHashes = new ArrayList<ByteBuffer>(_list290.size);
                            for (int _i292 = 0; _i292 < _list290.size; ++_i292) {
                                ByteBuffer _elem291 = iprot.readBinary();
                                struct.blockHashes.add(_elem291);
                            }
                            iprot.readListEnd();
                            struct.setBlockHashesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 11) {
                            struct.machineDescription = iprot.readBinary();
                            struct.setMachineDescriptionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, TransferInformation struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.token != null) {
                oprot.writeFieldBegin(TOKEN_FIELD_DESC);
                oprot.writeString(struct.token);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(PLAIN_PORT_FIELD_DESC);
            oprot.writeI32(struct.plainPort);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(SSL_PORT_FIELD_DESC);
            oprot.writeI32(struct.sslPort);
            oprot.writeFieldEnd();
            if (struct.blockHashes != null && struct.isSetBlockHashes()) {
                oprot.writeFieldBegin(BLOCK_HASHES_FIELD_DESC);
                oprot.writeListBegin(new TList(11, struct.blockHashes.size()));
                for (ByteBuffer _iter293 : struct.blockHashes) {
                    oprot.writeBinary(_iter293);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.machineDescription != null && struct.isSetMachineDescription()) {
                oprot.writeFieldBegin(MACHINE_DESCRIPTION_FIELD_DESC);
                oprot.writeBinary(struct.machineDescription);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TransferInformationStandardSchemeFactory
    implements SchemeFactory {
        private TransferInformationStandardSchemeFactory() {
        }

        public TransferInformationStandardScheme getScheme() {
            return new TransferInformationStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        TOKEN(1, "token"),
        PLAIN_PORT(2, "plainPort"),
        SSL_PORT(3, "sslPort"),
        BLOCK_HASHES(4, "blockHashes"),
        MACHINE_DESCRIPTION(5, "machineDescription");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return TOKEN;
                }
                case 2: {
                    return PLAIN_PORT;
                }
                case 3: {
                    return SSL_PORT;
                }
                case 4: {
                    return BLOCK_HASHES;
                }
                case 5: {
                    return MACHINE_DESCRIPTION;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

