/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.filetransfer;

import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.filetransfer.Downloader;
import org.openslx.filetransfer.IncomingEvent;
import org.openslx.filetransfer.Transfer;
import org.openslx.filetransfer.Uploader;
import org.openslx.util.PrioThreadFactory;

public class Listener {
    private final IncomingEvent incomingEvent;
    private final SSLContext context;
    private final int port;
    private ServerSocket listenSocket = null;
    private Thread acceptThread = null;
    private final int readTimeoutMs;
    private final ExecutorService processingPool = new ThreadPoolExecutor(0, 8, 5L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), new PrioThreadFactory("BFTP-Init"));
    private static final byte CONNECTING_PEER_WANTS_TO_UPLOAD = 85;
    private static final byte CONNECTING_PEER_WANTS_TO_DOWNLOAD = 68;
    private static Logger log = LogManager.getLogger(Listener.class);

    public Listener(IncomingEvent e, SSLContext context, int port, int readTimeoutMs) {
        this.incomingEvent = e;
        this.context = context;
        this.port = port;
        this.readTimeoutMs = readTimeoutMs;
    }

    private synchronized boolean listen() {
        if (this.listenSocket != null) {
            return true;
        }
        try {
            if (this.context == null) {
                this.listenSocket = new ServerSocket();
            } else {
                SSLServerSocketFactory sslServerSocketFactory = this.context.getServerSocketFactory();
                this.listenSocket = sslServerSocketFactory.createServerSocket();
            }
            this.listenSocket.setSoTimeout(5000);
            this.listenSocket.setReuseAddress(true);
            this.listenSocket.bind(new InetSocketAddress(this.port));
            this.listenSocket.setSoTimeout(0);
        }
        catch (Exception e) {
            log.error("Cannot listen on port " + this.port, (Throwable)e);
            this.listenSocket = null;
            return false;
        }
        return true;
    }

    private synchronized void run() {
        if (this.acceptThread != null) {
            return;
        }
        final Listener instance = this;
        this.acceptThread = new Thread("BFTP:" + this.port){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                Listener listener;
                try {
                    while (!this.isInterrupted()) {
                        Socket connection;
                        try {
                            connection = Listener.this.listenSocket.accept();
                        }
                        catch (SocketTimeoutException e) {
                            continue;
                        }
                        catch (Exception e) {
                            log.warn("Some exception when accepting! Trying to resume...", (Throwable)e);
                            Transfer.safeClose(Listener.this.listenSocket);
                            Listener.this.listenSocket = null;
                            if (Listener.this.listen()) continue;
                            log.error("Could not re-open listening socket");
                            break;
                        }
                        Runnable handler = new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    connection.setSoTimeout(5000);
                                    byte[] b = new byte[1];
                                    int length = connection.getInputStream().read(b);
                                    if (length == -1) {
                                        Transfer.safeClose(connection);
                                        return;
                                    }
                                    connection.setSoTimeout(Listener.this.readTimeoutMs);
                                    if (b[0] == 85) {
                                        Downloader d = new Downloader(connection);
                                        Listener.this.incomingEvent.incomingUploadRequest(d);
                                    } else if (b[0] == 68) {
                                        Uploader u = new Uploader(connection);
                                        Listener.this.incomingEvent.incomingDownloadRequest(u);
                                    } else {
                                        log.debug("Got invalid init-byte ... closing connection");
                                        Transfer.safeClose(connection);
                                    }
                                }
                                catch (SSLException e) {
                                    Transfer.safeClose(connection);
                                    log.warn("SSL error when acceping client " + connection.getInetAddress().getHostAddress());
                                }
                                catch (SocketException | SocketTimeoutException e) {
                                    Transfer.safeClose(connection);
                                }
                                catch (Exception e) {
                                    Transfer.safeClose(connection);
                                    log.warn("Error handling client", (Throwable)e);
                                }
                            }
                        };
                        try {
                            Listener.this.processingPool.execute(handler);
                        }
                        catch (RejectedExecutionException e) {
                            Transfer.safeClose(connection);
                        }
                    }
                    listener = instance;
                }
                catch (Throwable throwable) {
                    Listener listener2 = instance;
                    synchronized (listener2) {
                        Transfer.safeClose(Listener.this.listenSocket);
                        Listener.this.listenSocket = null;
                        throw throwable;
                    }
                }
                synchronized (listener) {
                    Transfer.safeClose(Listener.this.listenSocket);
                    Listener.this.listenSocket = null;
                    return;
                }
            }
        };
        this.acceptThread.setDaemon(true);
        this.acceptThread.start();
        log.info("Starting to accept " + (this.context == null ? "UNENCRYPTED" : "encrypted") + " connections on port " + this.port);
    }

    public int getPort() {
        return this.port;
    }

    public synchronized boolean isRunning() {
        return this.acceptThread != null && this.acceptThread.isAlive() && this.listenSocket != null && !this.listenSocket.isClosed();
    }

    public synchronized boolean wasStarted() {
        return this.acceptThread != null;
    }

    public synchronized boolean start() {
        if (!this.listen()) {
            return false;
        }
        this.run();
        return true;
    }
}

