/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.filetransfer;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import net.jpountz.lz4.LZ4Factory;
import org.apache.logging.log4j.Logger;
import org.openslx.filetransfer.FileRange;
import org.openslx.filetransfer.UploadStatusCallback;
import org.openslx.util.Util;

public abstract class Transfer {
    protected final Socket transferSocket;
    protected final DataOutputStream outStream;
    protected final DataInputStream dataFromServer;
    private String remoteError;
    private boolean shouldGetToken;
    protected boolean useCompression = true;
    protected final Logger log;
    protected static final LZ4Factory lz4factory = LZ4Factory.fastestInstance();

    protected Transfer(String host, int port, int readTimeoutMs, SSLContext context, Logger log) throws IOException {
        this.log = log;
        this.transferSocket = Util.connectAllRecords(context == null ? SocketFactory.getDefault() : context.getSocketFactory(), host, port, 4000);
        this.transferSocket.setSoTimeout(readTimeoutMs);
        this.outStream = new DataOutputStream(this.transferSocket.getOutputStream());
        this.dataFromServer = new DataInputStream(this.transferSocket.getInputStream());
        this.shouldGetToken = false;
    }

    protected Transfer(Socket socket, Logger log) throws IOException {
        this.log = log;
        this.transferSocket = socket;
        this.outStream = new DataOutputStream(this.transferSocket.getOutputStream());
        this.dataFromServer = new DataInputStream(this.transferSocket.getInputStream());
        this.shouldGetToken = true;
    }

    protected boolean sendRange(long startOffset, long endOffset) {
        try {
            this.sendKeyValuePair("RANGE", startOffset + ":" + endOffset);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected void sendUseCompression() {
        try {
            this.sendKeyValuePair("COMPRESS", "true");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean sendErrorCode(String errString) {
        try {
            this.sendKeyValuePair("ERROR", errString);
            this.sendEndOfMeta();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.close(e.toString());
            return false;
        }
        return true;
    }

    protected boolean sendToken(String token) {
        try {
            this.sendKeyValuePair("TOKEN", token);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.close(e.toString());
            return false;
        }
        return true;
    }

    public void sendDoneAndClose() {
        this.sendDone();
        this.sendEndOfMeta();
        this.close("Transfer finished");
    }

    protected boolean sendDone() {
        try {
            this.sendKeyValuePair("DONE", "");
        }
        catch (IOException e) {
            e.printStackTrace();
            this.close(e.toString());
            return false;
        }
        return true;
    }

    protected boolean sendEndOfMeta() {
        try {
            this.outStream.writeShort(0);
            this.outStream.flush();
        }
        catch (SocketTimeoutException e) {
            this.log.error("Error sending end of meta - socket timeout");
            return false;
        }
        catch (IOException e) {
            this.log.error("Error sending end of meta - " + e.toString());
            return false;
        }
        return true;
    }

    protected MetaData readMetaData() {
        HashMap<String, String> entries = new HashMap<String, String>();
        try {
            String data;
            while ((data = this.dataFromServer.readUTF()) != null && data.length() != 0) {
                String[] splitted = data.split("=", 2);
                if (splitted.length != 2) {
                    this.log.warn("Invalid key value pair received (" + data + ")");
                    continue;
                }
                if (splitted[0].equals("ERROR")) {
                    this.remoteError = splitted[1];
                }
                if (entries.containsKey(splitted[0])) {
                    this.log.warn("Received meta data key " + splitted[0] + " when already received, ignoring!");
                    continue;
                }
                entries.put(splitted[0], splitted[1]);
            }
        }
        catch (SocketTimeoutException ste) {
            this.sendErrorCode("timeout");
            this.close("Socket Timeout occured in readMetaData.");
            return null;
        }
        catch (Exception e) {
            this.close("Exception occured in readMetaData: " + e.toString());
            return null;
        }
        return new MetaData(entries);
    }

    private void sendKeyValuePair(String key, String value) throws IOException {
        if (this.outStream == null) {
            return;
        }
        try {
            this.outStream.writeUTF(key + "=" + value);
        }
        catch (Exception e) {
            this.close(e.getClass().getSimpleName() + " when sending KVP with key " + key);
        }
    }

    protected void close(String error, UploadStatusCallback callback, boolean sendToPeer) {
        this.close(error, callback, sendToPeer, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(String error, UploadStatusCallback callback, boolean sendToPeer, Exception e) {
        if (error != null) {
            if (sendToPeer) {
                this.sendErrorCode(error);
            }
            if (callback != null) {
                callback.uploadError(error);
            }
            this.log.info("Closing with error '" + error + "'", (Throwable)e);
        }
        Socket socket = this.transferSocket;
        synchronized (socket) {
            Transfer.safeClose(this.dataFromServer, this.outStream, this.transferSocket);
        }
    }

    protected void close(String error) {
        this.close(error, null);
    }

    protected void close(String error, Exception e) {
        this.close(error, null, false, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Socket socket = this.transferSocket;
        synchronized (socket) {
            try {
                this.transferSocket.shutdownOutput();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.transferSocket.shutdownInput();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        Socket socket = this.transferSocket;
        synchronized (socket) {
            return this.transferSocket.isConnected() && !this.transferSocket.isClosed() && !this.transferSocket.isInputShutdown() && !this.transferSocket.isOutputShutdown();
        }
    }

    public String getRemoteError() {
        return this.remoteError;
    }

    public String getToken() {
        if (!this.shouldGetToken) {
            this.log.error("Invalid call of getToken. You either initiated the connection yourself, or you already called getToken before.");
            this.close(null);
            return null;
        }
        this.shouldGetToken = false;
        MetaData meta = this.readMetaData();
        if (meta == null) {
            return null;
        }
        if (meta.peerWantsCompression()) {
            this.useCompression = true;
        }
        return meta.getToken();
    }

    protected boolean shouldGetToken() {
        return this.shouldGetToken;
    }

    protected static void safeClose(Closeable ... list) {
        Util.safeClose(list);
    }

    class MetaData {
        private Map<String, String> meta;

        private MetaData(Map<String, String> meta) {
            this.meta = meta;
        }

        public String getToken() {
            return this.meta.get("TOKEN");
        }

        public boolean isDone() {
            return this.meta.containsKey("DONE");
        }

        public FileRange getRange() {
            if (this.meta.containsKey("RANGE")) {
                return this.parseRange(this.meta.get("RANGE"));
            }
            return null;
        }

        private FileRange parseRange(String range) {
            long end;
            long start;
            if (range == null) {
                return null;
            }
            String[] parts = range.split(":");
            if (parts.length != 2) {
                return null;
            }
            try {
                start = Long.parseLong(parts[0]);
                end = Long.parseLong(parts[1]);
            }
            catch (Throwable t) {
                Transfer.this.log.warn("Not parsable range: '" + range + "'");
                return null;
            }
            if (start >= end) {
                Transfer.this.log.warn("Invalid range. Start >= end");
                return null;
            }
            return new FileRange(start, end);
        }

        public boolean peerWantsCompression() {
            return this.meta.containsKey("COMPRESS");
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> it : this.meta.entrySet()) {
                if (sb.length() != 0) {
                    sb.append(' ');
                }
                sb.append(it.getKey());
                sb.append('=');
                sb.append(it.getValue());
            }
            return sb.toString();
        }
    }
}

