/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.filetransfer.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.filetransfer.util.ChunkStatus;
import org.openslx.filetransfer.util.FileChunk;

public class HashChecker {
    public static final int BLOCKING = 1;
    public static final int CHECK_SHA1 = 2;
    public static final int CALC_CRC32 = 4;
    public static final int CALC_SHA1 = 8;
    public static final int NO_SLOW_WARN = 16;
    private static final Logger LOGGER = LogManager.getLogger(HashChecker.class);
    private final BlockingQueue<HashTask> queue;
    private final List<Thread> threads = new ArrayList<Thread>();
    private final String algorithm;
    private boolean invalid = false;
    private final int queueCapacity;

    public HashChecker(String algorithm) throws NoSuchAlgorithmException {
        this(algorithm, 10);
    }

    public HashChecker(String algorithm, int queueLen) throws NoSuchAlgorithmException {
        this.algorithm = algorithm;
        this.queueCapacity = queueLen;
        this.queue = new LinkedBlockingQueue<HashTask>(queueLen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void threadFailed(CheckThread thread) {
        HashTask task;
        List<Thread> list = this.threads;
        synchronized (list) {
            this.threads.remove(thread);
            LOGGER.debug("Check threads: " + this.threads.size());
            if (thread.extraThread) {
                return;
            }
            this.invalid = true;
        }
        LOGGER.debug("Marking all queued chunks as failed");
        while ((task = (HashTask)this.queue.poll()) != null) {
            this.execCallback(task, HashResult.FAILURE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        try {
            List<Thread> list = this.threads;
            synchronized (list) {
                for (Thread t : this.threads) {
                    t.interrupt();
                }
            }
        }
        catch (Throwable t) {
            LOGGER.warn("Something threw in finalize", t);
        }
    }

    private void execCallback(HashTask task, HashResult result) {
        if (task.callback == null) {
            return;
        }
        try {
            task.callback.hashCheckDone(result, task.data, task.chunk);
        }
        catch (Throwable t) {
            LOGGER.warn("HashCheck callback threw!", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queue(FileChunk chunk, byte[] data, HashCheckCallback callback, int flags) throws InterruptedException {
        boolean calcSha1;
        boolean blocking = (flags & 1) != 0;
        boolean checkSha1 = (flags & 2) != 0;
        boolean calcCrc32 = (flags & 4) != 0;
        boolean bl = calcSha1 = (flags & 8) != 0;
        if (checkSha1 && chunk.getSha1Sum() == null) {
            throw new NullPointerException("Chunk has no sha1 hash");
        }
        HashTask task = new HashTask(data, chunk, callback, checkSha1, calcCrc32, calcSha1);
        List<Thread> list = this.threads;
        synchronized (list) {
            CheckThread thread;
            if (this.invalid) {
                this.execCallback(task, HashResult.FAILURE);
                return true;
            }
            if (this.threads.isEmpty()) {
                try {
                    thread = new CheckThread(false);
                    thread.start();
                    this.threads.add(thread);
                }
                catch (NoSuchAlgorithmException e1) {
                    LOGGER.warn("Cannot spawn hash thread", (Throwable)e1);
                    this.invalid = true;
                    this.execCallback(task, HashResult.FAILURE);
                    return true;
                }
            }
            if (this.queue.remainingCapacity() <= 1 && this.threads.size() < Runtime.getRuntime().availableProcessors()) {
                try {
                    thread = new CheckThread(true);
                    thread.start();
                    this.threads.add(thread);
                    LOGGER.debug("Check threads: " + this.threads.size());
                }
                catch (Exception e) {
                    LOGGER.warn("Could not create additional hash checking thread", (Throwable)e);
                }
            }
        }
        if (checkSha1) {
            chunk.setStatus(ChunkStatus.HASHING);
        }
        if (blocking) {
            long duration;
            long pre = System.currentTimeMillis();
            this.queue.put(task);
            if ((flags & 0x10) == 0 && (duration = System.currentTimeMillis() - pre) > 1000L) {
                LOGGER.warn("HashChecker.queue() took " + duration + "ms");
            }
        } else if (!this.queue.offer(task)) {
            return false;
        }
        return true;
    }

    public int getQueueFill() {
        return this.queue.size();
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public static interface HashCheckCallback {
        public void hashCheckDone(HashResult var1, byte[] var2, FileChunk var3);
    }

    private static class HashTask {
        public final byte[] data;
        public final FileChunk chunk;
        public final HashCheckCallback callback;
        public final boolean checkSha1;
        public final boolean calcCrc32;
        public final boolean calcSha1;

        public HashTask(byte[] data, FileChunk chunk, HashCheckCallback callback, boolean checkSha1, boolean calcCrc32, boolean calcSha1) {
            this.data = data;
            this.chunk = chunk;
            this.callback = callback;
            this.checkSha1 = checkSha1;
            this.calcCrc32 = calcCrc32;
            this.calcSha1 = calcSha1;
        }
    }

    public static enum HashResult {
        NONE,
        VALID,
        INVALID,
        FAILURE;

    }

    private class CheckThread
    extends Thread {
        private final MessageDigest md;
        private final boolean extraThread;

        public CheckThread(boolean isExtra) throws NoSuchAlgorithmException {
            super("HashCheck");
            this.md = MessageDigest.getInstance(HashChecker.this.algorithm);
            this.extraThread = isExtra;
            this.setPriority(4);
        }

        @Override
        public void run() {
            while (!CheckThread.interrupted()) {
                HashTask task;
                try {
                    if (this.extraThread) {
                        task = (HashTask)HashChecker.this.queue.poll(30L, TimeUnit.SECONDS);
                        if (task == null) {
                            break;
                        }
                    } else {
                        task = (HashTask)HashChecker.this.queue.take();
                        if (task == null) {
                            continue;
                        }
                    }
                }
                catch (InterruptedException e) {
                    LOGGER.info("Interrupted while waiting for hash task", (Throwable)e);
                    break;
                }
                HashResult result = HashResult.NONE;
                if (task.checkSha1 || task.calcSha1) {
                    this.md.update(task.data, 0, task.chunk.range.getLength());
                    byte[] digest = this.md.digest();
                    if (task.checkSha1) {
                        result = Arrays.equals(digest, task.chunk.getSha1Sum()) ? HashResult.VALID : HashResult.INVALID;
                    } else {
                        task.chunk.setSha1Sum(digest);
                    }
                }
                if (task.calcCrc32) {
                    task.chunk.calculateDnbd3Crc32(task.data);
                }
                HashChecker.this.execCallback(task, result);
            }
            if (!this.extraThread) {
                LOGGER.warn("Stopped MAIN hash checker");
            }
            HashChecker.this.threadFailed(this);
        }
    }
}

