/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.filetransfer.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.filetransfer.LocalChunkSource;
import org.openslx.filetransfer.util.ChunkList;
import org.openslx.filetransfer.util.FileChunk;
import org.openslx.filetransfer.util.HashChecker;
import org.openslx.filetransfer.util.IncomingTransferBase;
import org.openslx.util.Util;

public class LocalCopyManager
extends Thread {
    private static final Logger LOGGER = LogManager.getLogger(LocalCopyManager.class);
    private FileChunk currentChunk = null;
    private final ChunkList chunkList;
    private final IncomingTransferBase transfer;
    private final Map<String, RandomAccessFile> sources = new HashMap<String, RandomAccessFile>();
    private Semaphore hasWork = new Semaphore(0);
    private AtomicInteger copyCount = new AtomicInteger();
    private boolean paused = true;

    public LocalCopyManager(IncomingTransferBase transfer, ChunkList list) {
        super("LocalCopyManager");
        this.transfer = transfer;
        this.chunkList = list;
    }

    public synchronized void trigger() {
        if (this.paused) {
            return;
        }
        if (this.getState() == Thread.State.NEW) {
            this.start();
        }
        this.triggerInternal();
    }

    private synchronized void triggerInternal() {
        if (this.paused) {
            return;
        }
        if (!this.isAlive()) {
            LOGGER.warn("Cannot be triggered when Thread is not running.");
            if (this.currentChunk != null) {
                this.chunkList.markFailed(this.currentChunk);
                this.currentChunk = null;
            }
            return;
        }
        if (this.currentChunk == null) {
            this.currentChunk = this.chunkList.getCopyCandidate();
            this.hasWork.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!LocalCopyManager.interrupted()) {
                while (this.currentChunk != null) {
                    this.hasWork.drainPermits();
                    this.copyChunk();
                }
                if (this.hasWork.tryAcquire(10L, TimeUnit.SECONDS)) continue;
                if (this.chunkList.isComplete()) {
                    this.transfer.finishUploadInternal();
                } else if (this.transfer.isActive()) {
                    this.triggerInternal();
                    continue;
                }
                break;
            }
        }
        catch (IllegalStateException | InterruptedException e) {
            this.interrupt();
        }
        LocalCopyManager localCopyManager = this;
        synchronized (localCopyManager) {
            if (this.currentChunk != null) {
                LOGGER.warn("Still had a chunk when thread was interrupted.");
                this.chunkList.markFailed(this.currentChunk);
                this.currentChunk = null;
            }
        }
        for (RandomAccessFile file : this.sources.values()) {
            Util.safeClose(file);
        }
        LOGGER.debug("My work here is done. Copied " + this.copyCount.get() + " chunks from " + this.sources.size() + " files.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyChunk() throws InterruptedException {
        block13: {
            LocalChunkSource.ChunkSource source = this.currentChunk.getSources();
            if (source != null) {
                byte[] buffer;
                do {
                    LocalChunkSource.SourceFile sourceFile;
                    if ((sourceFile = this.getOpenFile(source, this.currentChunk.range.getLength())) == null) {
                        LOGGER.warn("No open file for local copying!");
                        break block13;
                    }
                    RandomAccessFile raf = this.sources.get(sourceFile.fileName);
                    try {
                        raf.seek(sourceFile.offset);
                        if (this.chunkList.hasLocallyMissingChunk()) {
                            LocalCopyManager localCopyManager = this;
                            HashChecker hc = localCopyManager.transfer.getHashChecker();
                            int delay = hc == null ? 50 : hc.getQueueFill() * 500 / hc.getQueueCapacity();
                            Thread.sleep(delay);
                        }
                        buffer = new byte[sourceFile.chunkSize];
                        raf.readFully(buffer);
                    }
                    catch (InterruptedException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        LOGGER.warn("Could not read chunk to replicate from " + sourceFile.fileName, (Throwable)e);
                        buffer = null;
                        if (!(e instanceof IOException)) continue;
                        this.sources.put(sourceFile.fileName, null);
                    }
                } while (buffer == null);
                this.transfer.chunkReceivedInternal(this.currentChunk, buffer);
                LocalCopyManager localCopyManager = this;
                synchronized (localCopyManager) {
                    this.currentChunk = null;
                }
                this.copyCount.incrementAndGet();
                this.triggerInternal();
                return;
            }
        }
        LOGGER.info("Local copying failed, queueing for normal upload...");
        LocalCopyManager localCopyManager = this;
        synchronized (localCopyManager) {
            this.chunkList.markFailed(this.currentChunk);
            this.currentChunk = null;
        }
    }

    private LocalChunkSource.SourceFile getOpenFile(LocalChunkSource.ChunkSource source, int requiredSize) {
        for (LocalChunkSource.SourceFile candidate : source.sourceCandidates) {
            if (this.sources.get(candidate.fileName) == null) continue;
            return candidate;
        }
        for (LocalChunkSource.SourceFile candidate : source.sourceCandidates) {
            if (this.sources.containsKey(candidate.fileName) || candidate.chunkSize != requiredSize) continue;
            File f = new File(candidate.fileName);
            if (!f.exists()) {
                this.sources.put(candidate.fileName, null);
                continue;
            }
            try {
                RandomAccessFile raf = new RandomAccessFile(f, "r");
                this.sources.put(candidate.fileName, raf);
                return candidate;
            }
            catch (Exception e) {
                LOGGER.info("Cannot open " + candidate.fileName, (Throwable)e);
                this.sources.put(candidate.fileName, null);
            }
        }
        return null;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }
}

