/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.firmware;

import java.io.File;
import java.io.FileFilter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.function.Predicate;
import org.openslx.firmware.FirmwareException;
import org.openslx.firmware.FirmwareTarget;
import org.openslx.firmware.QemuFirmware;
import org.openslx.util.LevenshteinDistance;

public class QemuFirmwareUtil {
    public static String lookupTargetOsLoader(String fwSpecDir, String sourceOsLoader, String sourceOsArch, String sourceOsMachine) throws FirmwareException {
        String lookupOsLoader = null;
        File fwSpecDirFile = new File(fwSpecDir);
        if (!fwSpecDirFile.exists() || !fwSpecDirFile.isDirectory()) {
            throw new FirmwareException("Path to QEMU firmware specifications directory is invalid!");
        }
        FileFilter fwSpecFilesFilter = file -> !file.isDirectory() && file.getName().endsWith(".json");
        File[] fwSpecFiles = fwSpecDirFile.listFiles(fwSpecFilesFilter);
        if (fwSpecFiles != null) {
            ArrayList<QemuFirmware> uefiFirmwares = new ArrayList<QemuFirmware>();
            for (File fwSpecFile : fwSpecFiles) {
                QemuFirmware firmware = QemuFirmware.fromFwSpec(fwSpecFile);
                if (firmware == null) {
                    throw new FirmwareException("Firmware '" + fwSpecFile.toString() + "' can not be parsed correctly!");
                }
                Predicate<String> byInterfaceType = s -> s.toLowerCase().equals("uefi");
                if (!firmware.getInterfaceTypes().stream().filter(byInterfaceType).findAny().isPresent()) continue;
                Predicate<FirmwareTarget> byArchitecture = t -> sourceOsArch.equals(t.getArchitecture());
                Predicate<String> byMachineType = s -> sourceOsMachine.startsWith(s.replace("*", ""));
                Predicate<FirmwareTarget> byMachines = t -> t.getMachines().stream().filter(byMachineType).findAny().isPresent();
                if (!firmware.getTargets().stream().filter(byArchitecture).filter(byMachines).findAny().isPresent()) continue;
                uefiFirmwares.add(firmware);
            }
            if (uefiFirmwares.isEmpty()) {
                throw new FirmwareException("There aren't any suitable UEFI firmwares locally available!");
            }
            LevenshteinDistance distance = new LevenshteinDistance(1, 1, 1);
            int minFileNameDistance = Integer.MAX_VALUE;
            Path suitablestUefiFirmwarePath = null;
            for (QemuFirmware uefiFirmware : uefiFirmwares) {
                String sourceOsLoaderFileName;
                Path uefiFirmwarePath = Paths.get(uefiFirmware.getMapping().getExecutable().getFileName(), new String[0]);
                Path sourceOsLoaderPath = Paths.get(sourceOsLoader, new String[0]);
                String uefiFirmwareFileName = uefiFirmwarePath.getFileName().toString().toLowerCase();
                int fileNameDistance = distance.calculateDistance(uefiFirmwareFileName, sourceOsLoaderFileName = sourceOsLoaderPath.getFileName().toString().toLowerCase());
                if (fileNameDistance >= minFileNameDistance) continue;
                minFileNameDistance = fileNameDistance;
                suitablestUefiFirmwarePath = uefiFirmwarePath;
            }
            lookupOsLoader = suitablestUefiFirmwarePath.toString();
        }
        return lookupOsLoader;
    }

    public static String lookupTargetOsLoaderDefaultFwSpecDir(String sourceOsLoader, String sourceOsArch, String sourceOsMachine) throws FirmwareException {
        return QemuFirmwareUtil.lookupTargetOsLoader("/usr/share/qemu/firmware", sourceOsLoader, sourceOsArch, sourceOsMachine);
    }
}

