/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.libvirt.capabilities;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.openslx.libvirt.capabilities.cpu.Cpu;
import org.openslx.libvirt.capabilities.guest.Guest;
import org.openslx.libvirt.xml.LibvirtXmlDocument;
import org.openslx.libvirt.xml.LibvirtXmlDocumentException;
import org.openslx.libvirt.xml.LibvirtXmlNode;
import org.openslx.libvirt.xml.LibvirtXmlResources;
import org.openslx.libvirt.xml.LibvirtXmlSerializationException;
import org.openslx.libvirt.xml.LibvirtXmlValidationException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Capabilities
extends LibvirtXmlDocument {
    public Capabilities(String xml) throws LibvirtXmlDocumentException, LibvirtXmlSerializationException, LibvirtXmlValidationException {
        super(xml, LibvirtXmlResources.getLibvirtRng("capabilities.rng"));
    }

    public Capabilities(File xml) throws LibvirtXmlDocumentException, LibvirtXmlSerializationException, LibvirtXmlValidationException {
        super(xml, LibvirtXmlResources.getLibvirtRng("capabilities.rng"));
    }

    public Capabilities(InputStream xml) throws LibvirtXmlDocumentException, LibvirtXmlSerializationException, LibvirtXmlValidationException {
        super(xml, LibvirtXmlResources.getLibvirtRng("capabilities.rng"));
    }

    public Capabilities(InputSource xml) throws LibvirtXmlDocumentException, LibvirtXmlSerializationException, LibvirtXmlValidationException {
        super(xml, LibvirtXmlResources.getLibvirtRng("capabilities.rng"));
    }

    public String getHostUuid() {
        return this.getRootXmlNode().getXmlElementValue("host/uuid");
    }

    public Cpu getHostCpu() {
        Element hostCpuNode = this.getRootXmlNode().getXmlElement("host/cpu");
        if (hostCpuNode == null) {
            return null;
        }
        LibvirtXmlNode hostCpuXmlNode = new LibvirtXmlNode(this.getRootXmlNode().getXmlDocument(), hostCpuNode);
        return Cpu.newInstance(hostCpuXmlNode);
    }

    public boolean hasHostIommuSupport() {
        return this.getRootXmlNode().getXmlElementAttributeValueAsBool("host/iommu", "support");
    }

    public List<Guest> getGuests() {
        ArrayList<Guest> guestList = new ArrayList<Guest>();
        NodeList guestNodes = this.getRootXmlNode().getXmlNodes("guest");
        for (int i = 0; i < guestNodes.getLength(); ++i) {
            LibvirtXmlNode guestNode = new LibvirtXmlNode(this.getRootXmlNode().getXmlDocument(), guestNodes.item(i));
            Guest guest = Guest.newInstance(guestNode);
            if (guest == null) continue;
            guestList.add(guest);
        }
        return guestList;
    }
}

