/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.libvirt.capabilities.cpu;

import java.util.ArrayList;
import java.util.List;
import org.openslx.libvirt.capabilities.cpu.Feature;
import org.openslx.libvirt.capabilities.cpu.Pages;
import org.openslx.libvirt.xml.LibvirtXmlNode;
import org.w3c.dom.NodeList;

public class Cpu
extends LibvirtXmlNode {
    public Cpu() {
    }

    public Cpu(LibvirtXmlNode xmlNode) {
        super(xmlNode);
    }

    public String getArch() {
        return this.getXmlElementValue("arch");
    }

    public String getModel() {
        return this.getXmlElementValue("model");
    }

    public String getVendor() {
        return this.getXmlElementValue("vendor");
    }

    public int getTopologySockets() {
        String numSockets = this.getXmlElementAttributeValue("topology", "sockets");
        return Integer.parseInt(numSockets);
    }

    public int getTopologyDies() {
        String numDies = this.getXmlElementAttributeValue("topology", "dies");
        return Integer.parseInt(numDies);
    }

    public int getTopologyCores() {
        String numCores = this.getXmlElementAttributeValue("topology", "cores");
        return Integer.parseInt(numCores);
    }

    public int getTopologyThreads() {
        String numThreads = this.getXmlElementAttributeValue("topology", "threads");
        return Integer.parseInt(numThreads);
    }

    public List<Feature> getFeatures() {
        ArrayList<Feature> featureList = new ArrayList<Feature>();
        NodeList featureNodes = this.getXmlNodes("feature");
        for (int i = 0; i < featureNodes.getLength(); ++i) {
            LibvirtXmlNode featureNode = new LibvirtXmlNode(this.getXmlDocument(), featureNodes.item(i));
            Feature feature = Feature.newInstance(featureNode);
            if (feature == null) continue;
            featureList.add(feature);
        }
        return featureList;
    }

    public List<Pages> getPages() {
        ArrayList<Pages> pagesList = new ArrayList<Pages>();
        NodeList pagesNodes = this.getXmlNodes("pages");
        for (int i = 0; i < pagesNodes.getLength(); ++i) {
            LibvirtXmlNode pagesNode = new LibvirtXmlNode(this.getXmlDocument(), pagesNodes.item(i));
            Pages pages = Pages.newInstance(pagesNode);
            if (pages == null) continue;
            pagesList.add(pages);
        }
        return pagesList;
    }

    public static Cpu newInstance(LibvirtXmlNode xmlNode) {
        return new Cpu(xmlNode);
    }
}

