/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.libvirt.domain.device;

import org.openslx.libvirt.domain.device.Controller;
import org.openslx.libvirt.xml.LibvirtXmlNode;

public class ControllerPci
extends Controller {
    public ControllerPci() {
    }

    public ControllerPci(LibvirtXmlNode xmlNode) {
        super(xmlNode);
    }

    public Model getModel() {
        String model = this.getXmlElementAttributeValue("model");
        return Model.fromString(model);
    }

    public void setModel(Model model) {
        this.setXmlElementAttributeValue("model", model.toString());
    }

    public String getModelEmulated() {
        return this.getXmlElementAttributeValue("model", "name");
    }

    public static ControllerPci createInstance(LibvirtXmlNode xmlNode) {
        return ControllerPci.newInstance(xmlNode);
    }

    public static ControllerPci newInstance(LibvirtXmlNode xmlNode) {
        return new ControllerPci(xmlNode);
    }

    static enum Model {
        PCI_ROOT("pci-root"),
        PCI_BRDIGE("pci-bridge"),
        PCIE_ROOT("pcie-root"),
        PCI_DMI2BRIDGE("dmi-to-pci-bridge"),
        PCIE_ROOT_PORT("pcie-root-port"),
        PCIE_SWITCH_UPSTREAM_PORT("pcie-switch-upstream-port"),
        PCIE_SWITCH_DOWNSTREAM_PORT("pcie-switch-downstream-port"),
        PCI_EXPANDER_BUS("pci-expander-bus"),
        PCIE_EXPANDER_BUS("pcie-expander-bus"),
        PCIE2PCI_BRIDGE("pcie-to-pci-bridge");

        private String model = null;

        private Model(String model) {
            this.model = model;
        }

        public String toString() {
            return this.model;
        }

        public static Model fromString(String model) {
            for (Model t : Model.values()) {
                if (!t.model.equalsIgnoreCase(model)) continue;
                return t;
            }
            return null;
        }
    }
}

