/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.libvirt.domain.device;

import org.openslx.libvirt.domain.device.Controller;
import org.openslx.libvirt.xml.LibvirtXmlNode;

public class ControllerScsi
extends Controller {
    public ControllerScsi() {
    }

    public ControllerScsi(LibvirtXmlNode xmlNode) {
        super(xmlNode);
    }

    public Model getModel() {
        String model = this.getXmlElementAttributeValue("model");
        return Model.fromString(model);
    }

    public void setModel(Model model) {
        this.setXmlElementAttributeValue("model", model.toString());
    }

    public static ControllerScsi createInstance(LibvirtXmlNode xmlNode) {
        return ControllerScsi.newInstance(xmlNode);
    }

    public static ControllerScsi newInstance(LibvirtXmlNode xmlNode) {
        return new ControllerScsi(xmlNode);
    }

    static enum Model {
        AUTO("auto"),
        BUSLOGIC("buslogic"),
        IBMVSCSI("ibmvscsi"),
        LSISAS1068("lsisas1068"),
        LSISAS1078("lsisas1078"),
        VIRTIO_SCSI("virtio-scsi"),
        VMPVSCSI("vmpvscsi"),
        VIRTIO_TRANSITIONAL("virtio-transitional"),
        VIRTIO_NON_TRANSITIONAL("virtio-non-transitional"),
        NCR53C90("ncr53c90"),
        AM53C974("am53c974"),
        DC390("dc390");

        private String model = null;

        private Model(String model) {
            this.model = model;
        }

        public String toString() {
            return this.model;
        }

        public static Model fromString(String model) {
            for (Model t : Model.values()) {
                if (!t.model.equalsIgnoreCase(model)) continue;
                return t;
            }
            return null;
        }
    }
}

