/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.libvirt.domain.device;

import org.openslx.libvirt.domain.device.Controller;
import org.openslx.libvirt.xml.LibvirtXmlNode;
import org.openslx.util.Util;

public class ControllerUsb
extends Controller {
    public ControllerUsb() {
    }

    public ControllerUsb(LibvirtXmlNode xmlNode) {
        super(xmlNode);
    }

    public Model getModel() {
        String model = this.getXmlElementAttributeValue("model");
        return Model.fromString(model);
    }

    public void setModel(Model model) {
        this.setXmlElementAttributeValue("model", model.toString());
    }

    public static ControllerUsb createInstance(LibvirtXmlNode xmlNode) {
        return ControllerUsb.newInstance(xmlNode);
    }

    public static ControllerUsb newInstance(LibvirtXmlNode xmlNode) {
        return new ControllerUsb(xmlNode);
    }

    public int getPortCount() {
        return Util.parseInt(this.getXmlElementAttributeValue("ports"), -1);
    }

    public static enum Model {
        NONE("none"),
        PIIX3_UHCI("piix3-uhci"),
        PIIX4_UHCI("piix4-uhci"),
        EHCI("ehci"),
        ICH9_EHCI1("ich9-ehci1"),
        ICH9_UHCI1("ich9-uhci1"),
        ICH9_UHCI2("ich9-uhci2"),
        ICH9_UHCI3("ich9-uhci3"),
        VT82C686B_UHCI("vt82c686b-uhci"),
        PCI_OHCI("pci-ohci"),
        NEC_XHCI("nec-xhci"),
        QUSB1("qusb1"),
        QUSB2("qusb2"),
        QEMU_XHCI("qemu-xhci");

        private String model = null;

        private Model(String model) {
            this.model = model;
        }

        public String toString() {
            return this.model;
        }

        public static Model fromString(String model) {
            for (Model t : Model.values()) {
                if (!t.model.equalsIgnoreCase(model)) continue;
                return t;
            }
            return null;
        }
    }
}

