/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.libvirt.domain.device;

import java.net.InetAddress;
import org.openslx.libvirt.domain.device.Graphics;
import org.openslx.libvirt.xml.LibvirtXmlNode;

public class GraphicsSpice
extends Graphics {
    public static final InetAddress DEFAULT_ADDRESS = InetAddress.getLoopbackAddress();
    public static final int DEFAULT_PORT = 59000;

    public GraphicsSpice() {
    }

    public GraphicsSpice(LibvirtXmlNode xmlNode) {
        super(xmlNode);
    }

    public boolean isOpenGlEnabled() {
        return this.getXmlElementAttributeValueAsBool("gl", "enable");
    }

    public void setOpenGl(boolean enabled) {
        this.setXmlElementAttributeValueYesNo("gl", "enable", enabled);
    }

    public ImageCompression getImageCompression() {
        String imageCompression = this.getXmlElementAttributeValue("image", "compression");
        return ImageCompression.fromString(imageCompression);
    }

    public void setImageCompression(ImageCompression type) {
        this.setXmlElementAttributeValue("image", "compression", type.toString());
    }

    public boolean isPlaybackCompressionOn() {
        return this.getXmlElementAttributeValueAsBool("playback", "compression");
    }

    public void setPlaybackCompression(boolean enabled) {
        this.setXmlElementAttributeValueOnOff("playback", "compression", enabled);
    }

    public StreamingMode getStreamingMode() {
        String streamingMode = this.getXmlElementAttributeValue("streaming", "mode");
        return StreamingMode.fromString(streamingMode);
    }

    public void setStreamingMode(StreamingMode type) {
        this.setXmlElementAttributeValue("streaming", "mode", type.toString());
    }

    public static GraphicsSpice createInstance(LibvirtXmlNode xmlNode) {
        return GraphicsSpice.newInstance(xmlNode);
    }

    public static GraphicsSpice newInstance(LibvirtXmlNode xmlNode) {
        return new GraphicsSpice(xmlNode);
    }

    public static enum StreamingMode {
        ALL("all"),
        FILTER("filter"),
        OFF("off");

        private String type = null;

        private StreamingMode(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }

        public static StreamingMode fromString(String type) {
            for (StreamingMode t : StreamingMode.values()) {
                if (!t.type.equalsIgnoreCase(type)) continue;
                return t;
            }
            return null;
        }
    }

    public static enum ImageCompression {
        AUTO_GLZ("auto_glz"),
        AUTO_LZ("auto_lz"),
        QUIC("quic"),
        GLZ("glz"),
        LZ("lz"),
        OFF("off");

        private String type = null;

        private ImageCompression(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }

        public static ImageCompression fromString(String type) {
            for (ImageCompression t : ImageCompression.values()) {
                if (!t.type.equalsIgnoreCase(type)) continue;
                return t;
            }
            return null;
        }
    }
}

