/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.libvirt.domain.device;

import org.openslx.libvirt.domain.device.Device;
import org.openslx.libvirt.domain.device.HostdevMdev;
import org.openslx.libvirt.domain.device.HostdevPci;
import org.openslx.libvirt.domain.device.HostdevUsb;
import org.openslx.libvirt.xml.LibvirtXmlNode;

public class Hostdev
extends Device {
    public Hostdev() {
    }

    public Hostdev(LibvirtXmlNode xmlNode) {
        super(xmlNode);
    }

    public boolean isManaged() {
        return this.getXmlElementAttributeValueAsBool("managed");
    }

    public void setManaged(boolean managed) {
        this.setXmlElementAttributeValueYesNo("managed", managed);
    }

    public void removeBootOrder() {
        this.removeXmlElement("boot");
    }

    public static Hostdev createInstance(Hostdev hostdev, LibvirtXmlNode xmlNode) {
        Hostdev addedHostdev = null;
        xmlNode.setXmlElementAttributeValue("mode", "subsystem");
        if (hostdev instanceof HostdevMdev) {
            xmlNode.setXmlElementAttributeValue("type", HostdevType.MDEV.toString());
            addedHostdev = HostdevMdev.createInstance(xmlNode);
        } else if (hostdev instanceof HostdevPci) {
            xmlNode.setXmlElementAttributeValue("type", HostdevType.PCI.toString());
            addedHostdev = HostdevPci.createInstance(xmlNode);
        } else if (hostdev instanceof HostdevUsb) {
            xmlNode.setXmlElementAttributeValue("type", HostdevType.USB.toString());
            addedHostdev = HostdevUsb.createInstance(xmlNode);
        }
        return addedHostdev;
    }

    public static Hostdev newInstance(LibvirtXmlNode xmlNode) {
        Hostdev deviceHostdev = null;
        HostdevType type = HostdevType.fromString(xmlNode.getXmlElementAttributeValue("type"));
        if (type == null) {
            return null;
        }
        switch (type) {
            case MDEV: {
                deviceHostdev = HostdevMdev.newInstance(xmlNode);
                break;
            }
            case PCI: {
                deviceHostdev = HostdevPci.newInstance(xmlNode);
                break;
            }
            case USB: {
                deviceHostdev = HostdevUsb.newInstance(xmlNode);
            }
        }
        return deviceHostdev;
    }

    static enum HostdevType {
        MDEV("mdev"),
        PCI("pci"),
        USB("usb");

        private String type = null;

        private HostdevType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }

        public static HostdevType fromString(String type) {
            for (HostdevType t : HostdevType.values()) {
                if (!t.type.equalsIgnoreCase(type)) continue;
                return t;
            }
            return null;
        }
    }
}

