/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.libvirt.domain.device;

import org.openslx.libvirt.domain.device.Hostdev;
import org.openslx.libvirt.domain.device.HostdevAddressableSource;
import org.openslx.libvirt.domain.device.HostdevMdevDeviceAddress;
import org.openslx.libvirt.xml.LibvirtXmlNode;

public class HostdevMdev
extends Hostdev
implements HostdevAddressableSource<HostdevMdevDeviceAddress> {
    public HostdevMdev() {
    }

    public HostdevMdev(LibvirtXmlNode xmlNode) {
        super(xmlNode);
    }

    public boolean isDisplayOn() {
        return this.getXmlElementAttributeValueAsBool("display");
    }

    public void setDisplayOn(boolean on) {
        this.setXmlElementAttributeValueOnOff("display", on);
    }

    public boolean isMemoryFramebufferOn() {
        return this.getXmlElementAttributeValueAsBool("ramfb");
    }

    public void setMemoryFramebufferOn(boolean on) {
        this.setXmlElementAttributeValueOnOff("ramfb", on);
    }

    public Model getModel() {
        String model = this.getXmlElementAttributeValue("model");
        return Model.fromString(model);
    }

    public void setModel(Model model) {
        this.setXmlElementAttributeValue("model", model.toString());
    }

    @Override
    public HostdevMdevDeviceAddress getSource() {
        String mdevDeviceAddress = this.getXmlElementAttributeValue("source/address", "uuid");
        return HostdevMdevDeviceAddress.valueOf(mdevDeviceAddress);
    }

    @Override
    public void setSource(HostdevMdevDeviceAddress source) {
        this.setXmlElementAttributeValue("source/address", "uuid", source.getDeviceAddressAsString());
    }

    public static HostdevMdev createInstance(LibvirtXmlNode xmlNode) {
        return HostdevMdev.newInstance(xmlNode);
    }

    public static HostdevMdev newInstance(LibvirtXmlNode xmlNode) {
        return new HostdevMdev(xmlNode);
    }

    public static enum Model {
        VFIO_PCI("vfio-pci"),
        VFIO_CCW("vfio-ccw"),
        VFIO_AP("vfio-ap");

        private String model = null;

        private Model(String model) {
            this.model = model;
        }

        public String toString() {
            return this.model;
        }

        public static Model fromString(String model) {
            for (Model m : Model.values()) {
                if (!m.model.equalsIgnoreCase(model)) continue;
                return m;
            }
            return null;
        }
    }
}

