/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.libvirt.domain.device;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openslx.libvirt.domain.device.Hostdev;

public class HostdevPciDeviceDescription
extends Hostdev {
    private static final String DEVICE_DESCRIPTION_REGEX = "^([a-f0-9]{4}):([a-f0-9]{4})$";
    private static final int DEVICE_DESCRIPTION_ID_MIN_VALUE = 0;
    private static final int DEVICE_DESCRIPTION_ID_MAX_VALUE = 65535;
    final int vendorId;
    final int deviceId;

    public HostdevPciDeviceDescription(int vendorId, int deviceId) throws IllegalArgumentException {
        HostdevPciDeviceDescription.validatePciDeviceDescriptionId("PCI vendor ID", vendorId);
        HostdevPciDeviceDescription.validatePciDeviceDescriptionId("PCI device ID", deviceId);
        this.vendorId = vendorId;
        this.deviceId = deviceId;
    }

    private static void validatePciDeviceDescriptionId(String idName, int id) throws IllegalArgumentException {
        if (id < 0) {
            throw new IllegalArgumentException("The " + idName + "must be larger or equal than " + 0);
        }
        if (id > 65535) {
            throw new IllegalArgumentException("The " + idName + "must be smaller or equal than " + 65535);
        }
    }

    public int getVendorId() {
        return this.vendorId;
    }

    public String getVendorIdAsString() {
        return String.format("%04x", 0xFFFF & this.getVendorId());
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public String getDeviceIdAsString() {
        return String.format("%04x", 0xFFFF & this.getDeviceId());
    }

    public static HostdevPciDeviceDescription valueOf(String vendorDeviceId) {
        HostdevPciDeviceDescription pciDeviceDescription;
        if (vendorDeviceId == null || vendorDeviceId.isEmpty()) {
            pciDeviceDescription = null;
        } else {
            Pattern pciDeviceDescPattern = Pattern.compile(DEVICE_DESCRIPTION_REGEX);
            Matcher pciDeviceDescMatcher = pciDeviceDescPattern.matcher(vendorDeviceId.toLowerCase());
            if (pciDeviceDescMatcher.find()) {
                int vendorId = Integer.valueOf(pciDeviceDescMatcher.group(1), 16);
                int deviceId = Integer.valueOf(pciDeviceDescMatcher.group(2), 16);
                pciDeviceDescription = new HostdevPciDeviceDescription(vendorId, deviceId);
            } else {
                pciDeviceDescription = null;
            }
        }
        return pciDeviceDescription;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HostdevPciDeviceDescription other = (HostdevPciDeviceDescription)HostdevPciDeviceDescription.class.cast(obj);
        return this.getVendorId() == other.getVendorId() && this.getDeviceId() == other.getDeviceId();
    }

    public String toString() {
        return this.getVendorIdAsString() + ":" + this.getDeviceIdAsString();
    }
}

