/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.libvirt.domain.device;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HostdevUsbDeviceDescription {
    private static final String DEVICE_DESCRIPTION_REGEX = "^([a-f0-9]{4}):([a-f0-9]{4})$";
    private static final int DEVICE_DESCRIPTION_ID_MIN_VALUE = 0;
    private static final int DEVICE_DESCRIPTION_ID_MAX_VALUE = 65535;
    final int vendorId;
    final int productId;

    public HostdevUsbDeviceDescription(int vendorId, int productId) throws IllegalArgumentException {
        HostdevUsbDeviceDescription.validateUsbDeviceDescriptionId("PCI vendor ID", vendorId);
        HostdevUsbDeviceDescription.validateUsbDeviceDescriptionId("PCI device ID", productId);
        this.vendorId = vendorId;
        this.productId = productId;
    }

    private static void validateUsbDeviceDescriptionId(String idName, int id) throws IllegalArgumentException {
        if (id < 0) {
            throw new IllegalArgumentException("The " + idName + "must be larger or equal than " + 0);
        }
        if (id > 65535) {
            throw new IllegalArgumentException("The " + idName + "must be smaller or equal than " + 65535);
        }
    }

    public int getVendorId() {
        return this.vendorId;
    }

    public String getVendorIdAsString() {
        return String.format("%04x", 0xFFFF & this.getVendorId());
    }

    public int getProductId() {
        return this.productId;
    }

    public String getProductIdAsString() {
        return String.format("%04x", 0xFFFF & this.getProductId());
    }

    public static HostdevUsbDeviceDescription valueOf(String vendorProductId) {
        HostdevUsbDeviceDescription usbDeviceDescription;
        if (vendorProductId == null || vendorProductId.isEmpty()) {
            usbDeviceDescription = null;
        } else {
            Pattern usbDeviceDescPattern = Pattern.compile(DEVICE_DESCRIPTION_REGEX);
            Matcher usbDeviceDescMatcher = usbDeviceDescPattern.matcher(vendorProductId.toLowerCase());
            if (usbDeviceDescMatcher.find()) {
                int vendorId = Integer.valueOf(usbDeviceDescMatcher.group(1), 16);
                int productId = Integer.valueOf(usbDeviceDescMatcher.group(2), 16);
                try {
                    usbDeviceDescription = new HostdevUsbDeviceDescription(vendorId, productId);
                }
                catch (IllegalArgumentException e) {
                    usbDeviceDescription = null;
                }
            } else {
                usbDeviceDescription = null;
            }
        }
        return usbDeviceDescription;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HostdevUsbDeviceDescription other = (HostdevUsbDeviceDescription)HostdevUsbDeviceDescription.class.cast(obj);
        return this.getVendorId() == other.getVendorId() && this.getProductId() == other.getProductId();
    }

    public String toString() {
        return this.getVendorIdAsString() + ":" + this.getProductIdAsString();
    }
}

