/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.libvirt.domain.device;

import org.openslx.libvirt.domain.device.Device;
import org.openslx.libvirt.domain.device.InterfaceBridge;
import org.openslx.libvirt.domain.device.InterfaceNetwork;
import org.openslx.libvirt.xml.LibvirtXmlNode;

public class Interface
extends Device {
    public Interface() {
    }

    public Interface(LibvirtXmlNode xmlNode) {
        super(xmlNode);
    }

    public Model getModel() {
        String model = this.getXmlElementAttributeValue("model", "type");
        return Model.fromString(model);
    }

    public void setModel(Model model) {
        this.setXmlElementAttributeValue("model", "type", model.toString());
    }

    public Type getType() {
        return Type.fromString(this.getXmlElementAttributeValue("type"));
    }

    public void setType(Type type) {
        String source = this.getSource();
        this.setXmlElementAttributeValue("type", type.toString());
        this.setSource(source);
    }

    public String getSource() {
        Type type = this.getType();
        String source = null;
        switch (type) {
            case BRIDGE: {
                source = this.getXmlElementAttributeValue("source", "bridge");
                break;
            }
            case NETWORK: {
                source = this.getXmlElementAttributeValue("source", "network");
            }
        }
        return source;
    }

    public void setSource(String source) {
        Type type = this.getType();
        this.removeXmlElementAttributes("source");
        switch (type) {
            case BRIDGE: {
                this.setXmlElementAttributeValue("source", "bridge", source);
                break;
            }
            case NETWORK: {
                this.setXmlElementAttributeValue("source", "network", source);
            }
        }
    }

    public String getMacAddress() {
        return this.getXmlElementAttributeValue("mac", "address");
    }

    public void setMacAddress(String macAddress) {
        this.setXmlElementAttributeValue("mac", "address", macAddress);
    }

    public void removeBootOrder() {
        this.removeXmlElement("boot");
    }

    public void removeSource() {
        this.removeXmlElement("source");
    }

    public void removeMacAddress() {
        this.removeXmlElement("mac");
    }

    public static Interface createInstance(Interface iface, LibvirtXmlNode xmlNode) {
        Interface addedInterface = null;
        if (iface instanceof InterfaceBridge) {
            xmlNode.setXmlElementAttributeValue("type", Type.BRIDGE.toString());
            addedInterface = InterfaceBridge.createInstance(xmlNode);
        } else if (iface instanceof InterfaceNetwork) {
            xmlNode.setXmlElementAttributeValue("type", Type.NETWORK.toString());
            addedInterface = InterfaceNetwork.createInstance(xmlNode);
        }
        return addedInterface;
    }

    public static Interface newInstance(LibvirtXmlNode xmlNode) {
        Interface deviceInterface = null;
        Type type = Type.fromString(xmlNode.getXmlElementAttributeValue("type"));
        if (type == null) {
            return null;
        }
        switch (type) {
            case BRIDGE: {
                deviceInterface = InterfaceBridge.newInstance(xmlNode);
                break;
            }
            case NETWORK: {
                deviceInterface = InterfaceNetwork.newInstance(xmlNode);
            }
        }
        return deviceInterface;
    }

    public static enum Model {
        E1000("e1000"),
        E1000_82544GC("e1000-82544gc"),
        E1000_82545EM("e1000-82545em"),
        E1000E("e1000e"),
        I82550("i82550"),
        I82551("i82551"),
        I82557A("i82557a"),
        I82557B("i82557b"),
        I82557C("i82557c"),
        I82558A("i82558a"),
        I82558B("i82558b"),
        I82559A("i82559a"),
        I82559B("i82559b"),
        I82559C("i82559c"),
        I82559ER("i82559er"),
        I82562("i82562"),
        I82801("i82801"),
        NE2K_PCI("ne2k_pci"),
        PCNET("pcnet"),
        RTL8139("rtl8139"),
        TULIP("tulip"),
        VIRTIO("virtio"),
        VIRTIO_NET_PCI("virtio-net-pci"),
        VIRTIO_NET_PCI_NON_TRANSITIONAL("virtio-net-pci-non-transitional"),
        VIRTIO_NET_PCI_TRANSITIONAL("virtio-net-pci-transitional"),
        VMXNET3("vmxnet3");

        private String model = null;

        private Model(String model) {
            this.model = model;
        }

        public String toString() {
            return this.model;
        }

        public static Model fromString(String model) {
            for (Model m : Model.values()) {
                if (!m.model.equalsIgnoreCase(model)) continue;
                return m;
            }
            return null;
        }
    }

    public static enum Type {
        BRIDGE("bridge"),
        NETWORK("network");

        private String type = null;

        private Type(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }

        public static Type fromString(String type) {
            for (Type t : Type.values()) {
                if (!t.type.equalsIgnoreCase(type)) continue;
                return t;
            }
            return null;
        }
    }
}

