/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.libvirt.domain.device;

import org.openslx.libvirt.domain.device.Device;
import org.openslx.libvirt.xml.LibvirtXmlNode;
import org.openslx.util.Util;

public class Video
extends Device {
    public Video() {
    }

    public Video(LibvirtXmlNode xmlNode) {
        super(xmlNode);
    }

    public Model getModel() {
        String model = this.getXmlElementAttributeValue("model", "type");
        return Model.fromString(model);
    }

    public void setModel(Model model) {
        this.setXmlElementAttributeValue("model", "type", model.toString());
    }

    public boolean get2DAcceleration() {
        return this.getXmlElementAttributeValueAsBool("model/acceleration", "accel2d");
    }

    public void set2DAcceleration(boolean acceleration) {
        Model model = this.getModel();
        if (model != null) {
            if (model == Model.VIRTIO) {
                this.setXmlElementAttributeValueYesNo("model/acceleration", "accel2d", acceleration);
            } else {
                String errorMsg = "Video card model '" + model.toString() + "' does not support enabled 2D hardware acceleration.";
                throw new IllegalArgumentException(errorMsg);
            }
        }
    }

    public boolean get3DAcceleration() {
        return this.getXmlElementAttributeValueAsBool("model/acceleration", "accel3d");
    }

    public void set3DAcceleration(boolean acceleration) {
        Model model = this.getModel();
        if (model != Model.VIRTIO) {
            String errorMsg = "Video card model '" + model.toString() + "' does not support enabled 3D hardware acceleration.";
            throw new IllegalArgumentException(errorMsg);
        }
        this.setXmlElementAttributeValueYesNo("model/acceleration", "accel3d", acceleration);
    }

    public void disable() {
        this.removeXmlElementChilds();
        this.setModel(Model.NONE);
    }

    public static Video createInstance(LibvirtXmlNode xmlNode) {
        return Video.newInstance(xmlNode);
    }

    public static Video newInstance(LibvirtXmlNode xmlNode) {
        return new Video(xmlNode);
    }

    public long getVgaMem() {
        String mem = this.getXmlElementAttributeValue("model", "vgamem");
        return mem == null ? 0L : Util.parseLong(mem, 0L);
    }

    public void setVgaMem(long kb) {
        this.setXmlElementAttributeValue("model", "vgamem", Long.toString(kb));
    }

    public long getRam() {
        String mem = this.getXmlElementAttributeValue("model", "ram");
        return mem == null ? 0L : Util.parseLong(mem, 0L);
    }

    public void setRam(long kb) {
        this.setXmlElementAttributeValue("model", "ram", Long.toString(kb));
    }

    public long getVRam() {
        String mem = this.getXmlElementAttributeValue("model", "vram");
        return mem == null ? 0L : Util.parseLong(mem, 0L);
    }

    public void setVRam(long kb) {
        this.setXmlElementAttributeValue("model", "vram", Long.toString(kb));
    }

    public static enum Model {
        NONE("none"),
        QXL("qxl"),
        VGA("vga"),
        VMVGA("vmvga"),
        VIRTIO("virtio");

        private String model = null;

        private Model(String model) {
            this.model = model;
        }

        public String toString() {
            return this.model;
        }

        public static Model fromString(String model) {
            for (Model m : Model.values()) {
                if (!m.model.equalsIgnoreCase(model)) continue;
                return m;
            }
            return null;
        }
    }
}

