/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.libvirt.libosinfo;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.function.Predicate;
import org.openslx.libvirt.libosinfo.os.Os;
import org.openslx.libvirt.xml.LibvirtXmlDocument;
import org.openslx.libvirt.xml.LibvirtXmlDocumentException;
import org.openslx.libvirt.xml.LibvirtXmlNode;
import org.openslx.libvirt.xml.LibvirtXmlResources;
import org.openslx.libvirt.xml.LibvirtXmlSerializationException;
import org.openslx.libvirt.xml.LibvirtXmlValidationException;
import org.openslx.virtualization.Version;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class LibOsInfo
extends LibvirtXmlDocument {
    public LibOsInfo(String xml) throws LibvirtXmlDocumentException, LibvirtXmlSerializationException, LibvirtXmlValidationException {
        super(xml, LibvirtXmlResources.getLibOsInfoRng("osinfo.rng"));
    }

    public LibOsInfo(File xml) throws LibvirtXmlDocumentException, LibvirtXmlSerializationException, LibvirtXmlValidationException {
        super(xml, LibvirtXmlResources.getLibOsInfoRng("osinfo.rng"));
    }

    public LibOsInfo(InputStream xml) throws LibvirtXmlDocumentException, LibvirtXmlSerializationException, LibvirtXmlValidationException {
        super(xml, LibvirtXmlResources.getLibOsInfoRng("osinfo.rng"));
    }

    public LibOsInfo(InputSource xml) throws LibvirtXmlDocumentException, LibvirtXmlSerializationException, LibvirtXmlValidationException {
        super(xml, LibvirtXmlResources.getLibOsInfoRng("osinfo.rng"));
    }

    public Version getVersion() {
        String version = this.getRootXmlNode().getXmlElementAttributeValue("version");
        return Version.valueOf(version);
    }

    public ArrayList<Os> getOses() {
        ArrayList<Os> oses = new ArrayList<Os>();
        NodeList osNodes = this.getRootXmlNode().getXmlNodes("os");
        if (osNodes != null) {
            for (int i = 0; i < osNodes.getLength(); ++i) {
                LibvirtXmlNode osNode;
                Os os;
                Node childNode = osNodes.item(i);
                if (childNode.getNodeType() != 1 || (os = Os.newInstance(osNode = new LibvirtXmlNode(this.getRootXmlNode().getXmlDocument(), childNode))) == null) continue;
                oses.add(os);
            }
        }
        return oses;
    }

    public static Os lookupOs(String osId) {
        Os os = null;
        if (osId != null && !osId.isEmpty()) {
            ArrayList<Os> oses = null;
            try {
                LibOsInfo osInfo = new LibOsInfo(LibvirtXmlResources.getLibOsInfoXml("osinfo.xml"));
                oses = osInfo.getOses();
            }
            catch (LibvirtXmlDocumentException | LibvirtXmlSerializationException | LibvirtXmlValidationException e) {
                oses = null;
            }
            if (oses != null) {
                Predicate<Os> byOsId = osCandidate -> osId.equals(osCandidate.getId());
                os = oses.stream().filter(byOsId).findFirst().orElse(null);
            }
        }
        return os;
    }
}

