/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.libvirt.xml;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.openslx.libvirt.xml.LibvirtXmlCreatable;
import org.openslx.libvirt.xml.LibvirtXmlEditable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LibvirtXmlNode
implements LibvirtXmlCreatable,
LibvirtXmlEditable {
    private static final String XPATH_EXPRESSION_SEPARATOR = "/";
    private static final String XPATH_EXPRESSION_CURRENT_NODE = ".";
    private XPathFactory xPathFactory = null;
    private Document xmlDocument = null;
    private Node xmlBaseNode = null;

    private void createXPathContext() {
        this.xPathFactory = XPathFactory.newInstance();
    }

    public LibvirtXmlNode() {
        this(null, null);
    }

    public LibvirtXmlNode(LibvirtXmlNode xmlNode) {
        this(xmlNode.getXmlDocument(), xmlNode.getXmlBaseNode());
    }

    public LibvirtXmlNode(Document xmlDocument) {
        this(xmlDocument, null);
    }

    public LibvirtXmlNode(Node xmlBaseNode) {
        this(null, xmlBaseNode);
    }

    public LibvirtXmlNode(Document xmlDocument, Node xmlBaseNode) {
        this.createXPathContext();
        this.setXmlDocument(xmlDocument);
        this.setXmlBaseNode(xmlBaseNode);
    }

    public Document getXmlDocument() {
        return this.xmlDocument;
    }

    public void setXmlDocument(Document xmlDocument) {
        this.xmlDocument = xmlDocument;
    }

    public Node getXmlBaseNode() {
        return this.xmlBaseNode;
    }

    public void setXmlBaseNode(Node xmlBaseNode) {
        this.xmlBaseNode = xmlBaseNode;
    }

    @Override
    public Node getXmlNode(String expression) {
        if (XPATH_EXPRESSION_CURRENT_NODE.equals(expression)) {
            return this.xmlBaseNode;
        }
        NodeList nodes = this.getXmlNodes(expression);
        return nodes.item(0);
    }

    @Override
    public NodeList getXmlNodes(String expression) {
        Object nodes = null;
        try {
            XPath xPath = this.xPathFactory.newXPath();
            XPathExpression xPathExpr = xPath.compile(expression);
            nodes = xPathExpr.evaluate(this.xmlBaseNode, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return (NodeList)NodeList.class.cast(nodes);
    }

    @Override
    public Element getXmlElement(String expression) {
        String completeExpression = null;
        completeExpression = expression == null || expression.isEmpty() ? XPATH_EXPRESSION_CURRENT_NODE : "./" + expression;
        Node node = this.getXmlNode(completeExpression);
        if (node != null && node.getNodeType() == 1) {
            return (Element)node;
        }
        return null;
    }

    private Node createXmlElement(String expression) {
        Node parentNode;
        Node currentNode = parentNode = this.xmlBaseNode;
        if (expression != null && !expression.isEmpty()) {
            String[] nodeNames = expression.split(XPATH_EXPRESSION_SEPARATOR);
            String partialExpression = XPATH_EXPRESSION_CURRENT_NODE;
            for (int i = 0; i < nodeNames.length; ++i) {
                currentNode = this.getXmlNode(partialExpression = partialExpression + XPATH_EXPRESSION_SEPARATOR + nodeNames[i]);
                if (currentNode == null) {
                    currentNode = this.xmlDocument.createElement(nodeNames[i]);
                    parentNode.appendChild(currentNode);
                }
                parentNode = currentNode;
            }
        }
        return currentNode;
    }

    @Override
    public void setXmlElement(String expression, Node child) {
        Node node = this.createXmlElement(expression);
        if (child != null) {
            node.appendChild(child);
        }
    }

    @Override
    public String getXmlElementValue(String expression) {
        Element node = this.getXmlElement(expression);
        if (node != null) {
            return node.getTextContent();
        }
        return null;
    }

    @Override
    public void setXmlElementValue(String expression, String value) {
        Node node = this.createXmlElement(expression);
        node.setTextContent(value);
    }

    @Override
    public void removeXmlElement(String expression) {
        Element node = this.getXmlElement(expression);
        if (node != null) {
            node.getParentNode().removeChild(node);
        }
    }

    @Override
    public void removeXmlElementChilds(String expression) {
        Element node = this.getXmlElement(expression);
        if (node != null) {
            NodeList childs = node.getChildNodes();
            while (childs.getLength() > 0) {
                Node child = childs.item(0);
                node.removeChild(child);
            }
        }
    }

    @Override
    public String getXmlElementAttributeValue(String expression, String attributeName) {
        Element node = this.getXmlElement(expression);
        if (node == null) {
            return null;
        }
        Node attribute = node.getAttributes().getNamedItem(attributeName);
        if (attribute == null) {
            return null;
        }
        return attribute.getNodeValue();
    }

    @Override
    public void setXmlElementAttributeValue(String expression, String attributeName, String value) {
        Node node = this.createXmlElement(expression);
        Node attribute = node.getAttributes().getNamedItem(attributeName);
        if (attribute == null) {
            Element element = (Element)Element.class.cast(node);
            element.setAttribute(attributeName, value);
        } else {
            attribute.setNodeValue(value);
        }
    }

    @Override
    public void removeXmlElementAttribute(String expression, String attributeName) {
        Node attribute;
        Element node = this.getXmlElement(expression);
        if (node != null && (attribute = node.getAttributes().getNamedItem(attributeName)) != null) {
            node.getAttributes().removeNamedItem(attribute.getNodeName());
        }
    }

    @Override
    public void removeXmlElementAttributes(String expression) {
        Element node = this.getXmlElement(expression);
        if (node != null) {
            for (int i = 0; i < node.getAttributes().getLength(); ++i) {
                Node attribute = node.getAttributes().item(0);
                node.getAttributes().removeNamedItem(attribute.getNodeName());
            }
        }
    }

    @Override
    public void fromXmlNode(Node xmlNode) {
        this.setXmlBaseNode(xmlNode);
    }

    @Override
    public Node toXmlNode() {
        return this.getXmlBaseNode();
    }
}

