/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.libvirt.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.openslx.libvirt.xml.LibvirtXmlSchemaResourceResolver;
import org.openslx.libvirt.xml.LibvirtXmlValidationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class LibvirtXmlSchemaValidator {
    private Validator rngSchemaValidator;

    public LibvirtXmlSchemaValidator(InputStream rngSchema) throws SAXException {
        this.createValidationContext(rngSchema);
    }

    private void createValidationContext(InputStream rngSchema) throws SAXException {
        System.setProperty(SchemaFactory.class.getName() + ":" + "http://relaxng.org/ns/structure/1.0", "com.thaiopensource.relaxng.jaxp.XMLSyntaxSchemaFactory");
        LibvirtXmlSchemaResourceResolver schemaResolver = new LibvirtXmlSchemaResourceResolver();
        SchemaFactory factory = SchemaFactory.newInstance("http://relaxng.org/ns/structure/1.0");
        factory.setResourceResolver(schemaResolver);
        Schema schema = factory.newSchema(new StreamSource(rngSchema));
        this.rngSchemaValidator = schema.newValidator();
        this.rngSchemaValidator.setResourceResolver(schemaResolver);
    }

    private static StreamSource toStreamSource(DOMSource domSource) throws TransformerException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(outputStream);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.transform(domSource, result);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        return new StreamSource(inputStream);
    }

    public void validate(Document xmlDocument) throws LibvirtXmlValidationException {
        if (xmlDocument != null) {
            try {
                DOMSource domSource = new DOMSource(xmlDocument);
                StreamSource source = LibvirtXmlSchemaValidator.toStreamSource(domSource);
                this.rngSchemaValidator.validate(source);
            }
            catch (IOException | TransformerException | SAXException e) {
                throw new LibvirtXmlValidationException(e);
            }
        }
    }
}

