/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.thrifthelper;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import javax.net.ssl.SSLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.layered.TLayeredTransport;
import org.openslx.thrifthelper.ThriftHandler;

public class TBinaryProtocolSafe
extends TBinaryProtocol {
    private static final Logger LOGGER = LogManager.getLogger(ThriftHandler.class);
    private static final int maxLen = 0xC00000;

    public TBinaryProtocolSafe(TTransport trans) {
        this(trans, false, true);
    }

    public TBinaryProtocolSafe(TTransport trans, boolean strictRead, boolean strictWrite) {
        super(trans, 0xC00000L, 0xC00000L, strictRead, strictWrite);
    }

    public TMessage readMessageBegin() throws TException {
        int size;
        try {
            size = this.readI32();
        }
        catch (TTransportException e) {
            if (e.getCause() instanceof SSLException) {
                String m = e.getCause().getMessage();
                if (!m.contains("Remote host terminated the handshake") && !m.contains("Unsupported or unrecognized SSL message")) {
                    LOGGER.warn(this.getIp() + m);
                }
                throw new TTransportException(4);
            }
            if (e.getCause() instanceof SocketException && (e.getCause().getMessage().contains(" timed out") || e.getCause().getMessage().contains("Connection reset") || e.getCause().getMessage().contains("Connection or inbound"))) {
                throw new TTransportException(4);
            }
            if (e.getMessage().contains("larger than max length") || e.getMessage().contains("Read a negative frame size")) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
                throw new TTransportException(4);
            }
            throw e;
        }
        if (size > 0xC00000) {
            throw new TProtocolException(3, this.getIp() + "Payload too big.");
        }
        if (size < 0) {
            int version = size & 0xFFFF0000;
            if (version != -2147418112) {
                LOGGER.warn(this.getIp() + "Bad version (" + version + ") in readMessageBegin");
                throw new TTransportException(4);
            }
            return new TMessage(this.readString(), (byte)(size & 0xFF), this.readI32());
        }
        if (this.strictRead_) {
            throw new TProtocolException(4, "Missing version in readMessageBegin, old client?");
        }
        return new TMessage(this.readStringBody(size), this.readByte(), this.readI32());
    }

    private String getIp() {
        TTransport t = this.trans_;
        while (t instanceof TLayeredTransport) {
            t = ((TLayeredTransport)t).getInnerTransport();
        }
        InetAddress ia = null;
        if (t instanceof TSocket) {
            SocketAddress sa = ((TSocket)t).getSocket().getRemoteSocketAddress();
            if (sa != null && sa instanceof InetSocketAddress) {
                ia = ((InetSocketAddress)sa).getAddress();
            }
            if (ia == null) {
                ia = ((TSocket)t).getSocket().getInetAddress();
            }
        } else {
            LOGGER.debug("getIp(" + t.getClass().getSimpleName() + ")");
        }
        if (ia == null) {
            return "";
        }
        return ia.getHostAddress() + ": ";
    }

    public String readString() throws TException {
        int size = this.readI32();
        if (size > 0xC00000) {
            throw new TProtocolException(3, "Payload too big.");
        }
        if (this.trans_.getBytesRemainingInBuffer() >= size) {
            String s = new String(this.trans_.getBuffer(), this.trans_.getBufferPosition(), size, StandardCharsets.UTF_8);
            this.trans_.consumeBuffer(size);
            return s;
        }
        return this.readStringBody(size);
    }

    public ByteBuffer readBinary() throws TException {
        int size = this.readI32();
        if (size > 0xC00000) {
            throw new TProtocolException(3, "Payload too big.");
        }
        if (this.trans_.getBytesRemainingInBuffer() >= size) {
            ByteBuffer bb = ByteBuffer.wrap(this.trans_.getBuffer(), this.trans_.getBufferPosition(), size);
            this.trans_.consumeBuffer(size);
            return bb;
        }
        byte[] buf = new byte[size];
        this.trans_.readAll(buf, 0, size);
        return ByteBuffer.wrap(buf);
    }

    public static class Factory
    implements TProtocolFactory {
        private static final long serialVersionUID = 6896537370338823740L;
        protected boolean strictRead_ = false;
        protected boolean strictWrite_ = true;

        public Factory() {
            this(false, true);
        }

        public Factory(boolean strictRead, boolean strictWrite) {
            this.strictRead_ = strictRead;
            this.strictWrite_ = strictWrite;
        }

        public TProtocol getProtocol(TTransport trans) {
            return new TBinaryProtocolSafe(trans, this.strictRead_, this.strictWrite_);
        }
    }
}

