/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.thrifthelper;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.TException;
import org.apache.thrift.TServiceClient;
import org.openslx.thrifthelper.ThriftManager;
import org.openslx.util.QuickTimer;

class ThriftHandler<T extends TServiceClient>
implements InvocationHandler {
    private static final Logger LOGGER = LogManager.getLogger(ThriftHandler.class);
    private static final long MAX_IDLE_MS = 110000L;
    private final Deque<TWrap<T>> pool = new ArrayDeque<TWrap<T>>();
    private Deque<TWrap<T>> trash = new ArrayDeque<TWrap<T>>();
    private final WantClientCallback<? extends T> clientFactory;
    private final ThriftManager.ErrorCallback errorCallback;
    private final Set<String> thriftMethods;

    public ThriftHandler(Class<? extends T> clazz, WantClientCallback<? extends T> clientFactory, ThriftManager.ErrorCallback errCb) {
        this.errorCallback = errCb;
        this.clientFactory = clientFactory;
        HashSet<String> tmpset = new HashSet<String>();
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            boolean thrift = false;
            Class<?>[] type = methods[i].getExceptionTypes();
            for (int e = 0; e < type.length; ++e) {
                if (!TException.class.isAssignableFrom(type[e])) continue;
                thrift = true;
                break;
            }
            String name = methods[i].getName();
            if (!thrift || name.startsWith("send_") || name.startsWith("recv_")) continue;
            tmpset.add(name);
        }
        this.thriftMethods = Collections.unmodifiableSet(tmpset);
        QuickTimer.scheduleAtFixedDelay(new QuickTimer.Task(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void fire() {
                Deque list;
                ArrayDeque newTrash = new ArrayDeque();
                long now = System.currentTimeMillis();
                Deque deque = ThriftHandler.this.pool;
                synchronized (deque) {
                    list = ThriftHandler.this.trash;
                    ThriftHandler.this.trash = newTrash;
                    Iterator it = ThriftHandler.this.pool.iterator();
                    while (it.hasNext()) {
                        TWrap client = (TWrap)it.next();
                        if (client.deadline >= now) continue;
                        list.add(client);
                        it.remove();
                    }
                }
                for (TWrap client : list) {
                    ThriftHandler.this.freeClient(client);
                }
            }
        }, 550000L, 550000L);
    }

    /*
     * Exception decompiling
     */
    @Override
    public Object invoke(Object tproxy, Method method, Object[] args) throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void freeClient(TWrap<T> client) {
        try {
            ((TServiceClient)((TWrap)client).client).getInputProtocol().getTransport().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((TServiceClient)((TWrap)client).client).getOutputProtocol().getTransport().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TWrap<T> getClient() {
        long now = System.currentTimeMillis();
        Deque<TWrap<T>> deque = this.pool;
        synchronized (deque) {
            TWrap<T> client;
            while ((client = this.pool.poll()) != null) {
                if (((TWrap)client).deadline >= now) {
                    return client;
                }
                this.trash.add(client);
            }
        }
        LOGGER.debug("Creating new thrift client");
        TServiceClient client = (TServiceClient)this.clientFactory.getNewClient();
        if (client == null) {
            return null;
        }
        return new TWrap<TServiceClient>(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnClient(TWrap<T> client) {
        if (client == null) {
            return;
        }
        ((TWrap)client).deadline = System.currentTimeMillis() + 110000L;
        Deque<TWrap<T>> deque = this.pool;
        synchronized (deque) {
            this.pool.push(client);
        }
    }

    private static class TWrap<T> {
        private final T client;
        private long deadline;

        public TWrap(T client) {
            this.client = client;
        }
    }

    protected static interface WantClientCallback<T> {
        public T getNewClient();
    }
}

