/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.util;

import java.io.InputStream;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.util.Util;

public class AppUtil {
    private static final Logger LOGGER = LogManager.getLogger(AppUtil.class);
    private static final int PROPERTY_MAX_WIDTH = 30;
    private static final String MANIFEST_REVISION_VERSION = "Revision-Version";
    private static final String MANIFEST_REVISION_BRANCH = "Revision-Branch";
    private static final String MANIFEST_BUILD_TIMESTAMP = "Build-Timestamp";
    private static final String MANIFEST_BUILD_JDK = "Build-Jdk";
    private static final String PROPERTY_APP_NAME = "app.name";
    private static final String PROPERTY_APP_VERSION = "app.version";
    private static final String PROPERTY_APP_REVISION_VERSION = "app.revision.version";
    private static final String PROPERTY_APP_REVISION_BRANCH = "app.revision.branch";
    private static final String PROPERTY_APP_BUILD_DATE = "app.build.date";
    private static final String PROPERTY_APP_BUILD_JDK = "app.build.jdk";
    private static final String PROPERTY_JAVA_OS_NAME = "os.name";
    private static final String PROPERTY_JAVA_OS_ARCH = "os.arch";
    private static final String PROPERTY_JAVA_SPEC_VENDOR = "java.specification.vendor";
    private static final String PROPERTY_JAVA_SPEC_NAME = "java.specification.name";
    private static final String PROPERTY_JAVA_SPEC_VERSION = "java.specification.version";
    private static final String PROPERTY_JAVA_VERSION = "java.version";
    private static final String PROPERTY_JAVA_VERSION_VM = "java.vm.version";
    private static final String PROPERTY_JAVA_VERSION_RUNTIME = "java.runtime.version";
    private static final String PROPERTY_JAVA_MEMORY_LIMIT = "java.runtime.memory";
    private static final String PROPERTY_JAVA_BITNESS = "sun.arch.data.model";
    private static Attributes manifestAttributes = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getManifestValue(String entry) {
        if (manifestAttributes == null) {
            JarInputStream jarStream;
            InputStream jarFileStream;
            block5: {
                jarFileStream = null;
                jarStream = null;
                manifestAttributes = new Attributes();
                try {
                    jarFileStream = AppUtil.class.getProtectionDomain().getCodeSource().getLocation().openStream();
                    jarStream = new JarInputStream(jarFileStream);
                    Manifest mf = jarStream.getManifest();
                    if (mf == null) break block5;
                    manifestAttributes = mf.getMainAttributes();
                }
                catch (Exception e) {
                    try {
                        LOGGER.warn("Cannot read jar/manifest attributes", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        Util.safeClose(jarStream, jarFileStream);
                        throw throwable;
                    }
                    Util.safeClose(jarStream, jarFileStream);
                }
            }
            Util.safeClose(jarStream, jarFileStream);
        }
        return manifestAttributes.getValue(entry);
    }

    public static String getRevisionVersion() {
        return AppUtil.getManifestValue(MANIFEST_REVISION_VERSION);
    }

    public static String getRevisionBranch() {
        return AppUtil.getManifestValue(MANIFEST_REVISION_BRANCH);
    }

    public static long getBuildTimestamp() {
        String timestampRaw = AppUtil.getManifestValue(MANIFEST_BUILD_TIMESTAMP);
        long timestamp = 0L;
        try {
            timestamp = Long.valueOf(timestampRaw);
            timestamp /= 1000L;
        }
        catch (NumberFormatException e) {
            timestamp = 0L;
        }
        return timestamp;
    }

    public static String getBuildTime() {
        String buildTime;
        long timestamp = AppUtil.getBuildTimestamp();
        if (timestamp > 0L) {
            Instant time = Instant.ofEpochSecond(timestamp);
            buildTime = DateTimeFormatter.RFC_1123_DATE_TIME.withZone(ZoneId.systemDefault()).format(time);
        } else {
            buildTime = null;
        }
        return buildTime;
    }

    public static String getBuildJdk() {
        return AppUtil.getManifestValue(MANIFEST_BUILD_JDK);
    }

    private static String formatProperty(String property) {
        return String.format("%-30s", property);
    }

    public static void logProperty(Logger logger, String propertyName, String propertyValue) {
        logger.info(AppUtil.formatProperty(propertyName) + propertyValue);
    }

    public static void logJavaProperty(Logger logger, String javaProperty) {
        AppUtil.logProperty(logger, javaProperty, System.getProperty(javaProperty));
    }

    public static void logHeader(Logger logger, String appName, String appVersion) {
        long limit = Runtime.getRuntime().maxMemory() / 0x100000L;
        String mem = limit > 99999999L ? "-" : (limit >= 2048L ? String.format("%.1fG", Float.valueOf((float)limit / 1024.0f)) : limit + "M");
        logger.info("-------------------------------------------------------------------------------");
        logger.info(appName);
        logger.info("-------------------------------------------------------------------------------");
        AppUtil.logProperty(logger, PROPERTY_APP_NAME, appName);
        AppUtil.logProperty(logger, PROPERTY_APP_VERSION, appVersion);
        AppUtil.logProperty(logger, PROPERTY_APP_REVISION_VERSION, AppUtil.getRevisionVersion());
        AppUtil.logProperty(logger, PROPERTY_APP_REVISION_BRANCH, AppUtil.getRevisionBranch());
        AppUtil.logProperty(logger, PROPERTY_APP_BUILD_DATE, AppUtil.getBuildTime());
        AppUtil.logProperty(logger, PROPERTY_APP_BUILD_JDK, AppUtil.getBuildJdk());
        AppUtil.logJavaProperty(logger, PROPERTY_JAVA_OS_NAME);
        AppUtil.logJavaProperty(logger, PROPERTY_JAVA_SPEC_VENDOR);
        AppUtil.logJavaProperty(logger, PROPERTY_JAVA_SPEC_NAME);
        AppUtil.logJavaProperty(logger, PROPERTY_JAVA_SPEC_VERSION);
        AppUtil.logJavaProperty(logger, PROPERTY_JAVA_VERSION);
        AppUtil.logJavaProperty(logger, PROPERTY_JAVA_VERSION_VM);
        AppUtil.logJavaProperty(logger, PROPERTY_JAVA_VERSION_RUNTIME);
        AppUtil.logJavaProperty(logger, PROPERTY_JAVA_BITNESS);
        AppUtil.logJavaProperty(logger, PROPERTY_JAVA_OS_ARCH);
        AppUtil.logProperty(logger, PROPERTY_JAVA_MEMORY_LIMIT, mem);
        logger.info("-------------------------------------------------------------------------------");
    }
}

