/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.virtualization;

import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openslx.util.Util;

public class Version
implements Comparable<Version> {
    private static final Pattern VERSION_NUMBER_REGEX = Pattern.compile("^(\\d+)(?:\\.(\\d+)(?:\\.(\\d+))?)?$");
    private final short major;
    private final short minor;
    private final String name;

    public Version(short major) {
        this(major, Short.valueOf("0"), null);
    }

    public Version(short major, String name) {
        this(major, Short.valueOf("0"), name);
    }

    public Version(short major, short minor) {
        this(major, minor, null);
    }

    public Version(short major, short minor, String name) {
        this.major = major;
        this.minor = minor;
        this.name = name;
    }

    public short getMajor() {
        return this.major;
    }

    public short getMinor() {
        return this.minor;
    }

    public int getVersion() {
        short major = this.major;
        short minor = this.minor;
        return major << 16 | minor;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSupported(List<Version> supportedVersions) {
        return supportedVersions.contains(this);
    }

    private static Version getInstanceByPredicateFromVersions(Predicate<Version> byFilter, List<Version> supportedVersions) {
        return supportedVersions.stream().filter(byFilter).findFirst().orElse(null);
    }

    public static Version getInstanceByMajorFromVersions(short major, List<Version> supportedVersions) {
        Predicate<Version> byMajor = version -> major == version.getMajor();
        return Version.getInstanceByPredicateFromVersions(byMajor, supportedVersions);
    }

    public static Version getInstanceByMajorMinorFromVersions(short major, short minor, List<Version> supportedVersions) {
        Predicate<Version> byMajorMinor = version -> major == version.getMajor() && minor == version.getMinor();
        return supportedVersions.stream().filter(byMajorMinor).findFirst().orElse(null);
    }

    public boolean isSmallerThan(Version version) {
        return this.compareTo(version) < 0;
    }

    public boolean isGreaterThan(Version version) {
        return this.compareTo(version) > 0;
    }

    public static Version valueOf(String version) {
        Version parsedVersion;
        if (Util.isEmptyString(version)) {
            parsedVersion = null;
        } else {
            Matcher versionMatcher = VERSION_NUMBER_REGEX.matcher(version);
            if (versionMatcher.find()) {
                String majorStr = versionMatcher.group(1);
                String minorStr = versionMatcher.group(2);
                short major = majorStr != null ? Short.valueOf(majorStr) : (short)0;
                short minor = minorStr != null ? Short.valueOf(minorStr) : (short)0;
                parsedVersion = new Version(major, minor);
            } else {
                parsedVersion = null;
            }
        }
        return parsedVersion;
    }

    public String toString() {
        if (Util.isEmptyString(this.getName())) {
            return String.format("%d.%d", this.getMajor(), this.getMinor());
        }
        return String.format("%d.%d %s", this.getMajor(), this.getMinor(), this.getName());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.compareTo((Version)Version.class.cast(obj)) == 0;
    }

    @Override
    public int compareTo(Version v) {
        if (this.getMajor() < v.getMajor()) {
            return -1;
        }
        if (this.getMajor() > v.getMajor()) {
            return 1;
        }
        if (this.getMinor() < v.getMinor()) {
            return -1;
        }
        if (this.getMinor() > v.getMinor()) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return Short.valueOf(this.getMajor()).hashCode() ^ Short.valueOf(this.getMinor()).hashCode();
    }
}

