/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.virtualization.configuration;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openslx.util.Util;
import org.openslx.util.XmlHelper;
import org.openslx.virtualization.Version;
import org.openslx.virtualization.configuration.VirtualizationConfiguration;
import org.openslx.virtualization.configuration.VirtualizationConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class VirtualizationConfigurationVirtualboxFileFormat {
    private static final Logger LOGGER = LogManager.getLogger(VirtualizationConfigurationVirtualboxFileFormat.class);
    private String osName = "";
    private ArrayList<VirtualizationConfiguration.HardDisk> hddsArray = new ArrayList();
    private Document doc = null;
    private Version version = null;
    private static final HashMap<Version, String> FILE_FORMAT_SCHEMA_VERSIONS = new HashMap<Version, String>(){
        private static final long serialVersionUID = -3163681758191475625L;
        {
            this.put(Version.valueOf("1.15"), "VirtualBox-settings_v1-15.xsd");
            this.put(Version.valueOf("1.16"), "VirtualBox-settings_v1-16.xsd");
            this.put(Version.valueOf("1.17"), "VirtualBox-settings_v1-17.xsd");
            this.put(Version.valueOf("1.18"), "VirtualBox-settings_v1-18.xsd");
            this.put(Version.valueOf("1.19"), "VirtualBox-settings_v1-21.xsd");
            this.put(Version.valueOf("1.20"), "VirtualBox-settings_v1-21.xsd");
            this.put(Version.valueOf("1.21"), "VirtualBox-settings_v1-21.xsd");
        }
    };
    private static final String FILE_FORMAT_SCHEMA_PREFIX_PATH = "/virtualbox/xsd";
    public static final String DUMMY_VALUE = "[dummy]";
    private static final String[] BLACKLIST = new String[]{"/VirtualBox/Machine/Hardware/GuestProperties", "/VirtualBox/Machine/Hardware/VideoCapture", "/VirtualBox/Machine/Hardware/HID", "/VirtualBox/Machine/Hardware/LPT", "/VirtualBox/Machine/Hardware/SharedFolders", "/VirtualBox/Machine/Hardware/Network/Adapter[@slot='0']/*", "/VirtualBox/Machine/ExtraData", "/VirtualBox/Machine/StorageControllers/StorageController/AttachedDevice[not(@type='HardDisk')]", "/VirtualBox/Machine/Hardware/StorageControllers/StorageController/AttachedDevice[not(@type='HardDisk')]", "/VirtualBox/Machine/MediaRegistry/FloppyImages", "/VirtualBox/Machine/MediaRegistry/DVDImages"};

    public VirtualizationConfigurationVirtualboxFileFormat(File file) throws IOException, VirtualizationConfigurationException {
        this.doc = XmlHelper.parseDocumentFromStream(new FileInputStream(file));
        this.doc = XmlHelper.removeFormattingNodes(this.doc);
        if (this.doc == null) {
            throw new VirtualizationConfigurationException("Could not parse given VirtualBox machine configuration file!");
        }
        this.parseConfigurationVersion();
        this.init();
    }

    public VirtualizationConfigurationVirtualboxFileFormat(byte[] machineDescription, int length) throws VirtualizationConfigurationException {
        ByteArrayInputStream is = new ByteArrayInputStream(machineDescription);
        this.doc = XmlHelper.parseDocumentFromStream(is);
        if (this.doc == null) {
            String errorMsg = "Could not parse given VirtualBox machine description from byte array!";
            LOGGER.debug("Could not parse given VirtualBox machine description from byte array!");
            throw new VirtualizationConfigurationException("Could not parse given VirtualBox machine description from byte array!");
        }
        this.parseConfigurationVersion();
        this.init();
    }

    public void validate() throws VirtualizationConfigurationException {
        this.validateFileFormatVersion(this.getVersion());
    }

    public void validateFileFormatVersion(Version version) throws VirtualizationConfigurationException {
        if (this.getVersion() != null && this.doc != null) {
            String fileName = FILE_FORMAT_SCHEMA_VERSIONS.get(version);
            if (fileName == null) {
                String errorMsg = "File format version " + version.toString() + " is not supported!";
                LOGGER.debug(errorMsg);
                throw new VirtualizationConfigurationException(errorMsg);
            }
            InputStream schemaResource = VirtualizationConfigurationVirtualboxFileFormat.getSchemaResource(fileName);
            if (schemaResource != null) {
                try {
                    SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                    Schema schema = factory.newSchema(new StreamSource(schemaResource));
                    Validator validator = schema.newValidator();
                    validator.validate(new DOMSource(this.doc));
                }
                catch (IOException | SAXException e) {
                    String errorMsg = "XML configuration is not a valid VirtualBox v" + version.toString() + " configuration: " + e.getLocalizedMessage();
                    LOGGER.debug(errorMsg);
                    throw new VirtualizationConfigurationException(errorMsg);
                }
            }
        }
    }

    private static InputStream getSchemaResource(String fileName) {
        String schemaFilePath = FILE_FORMAT_SCHEMA_PREFIX_PATH + File.separator + fileName;
        return VirtualizationConfigurationVirtualboxFileFormat.class.getResourceAsStream(schemaFilePath);
    }

    private void init() throws VirtualizationConfigurationException {
        block6: {
            try {
                this.validate();
            }
            catch (VirtualizationConfigurationException e) {
                if (this.checkForPlaceholders()) break block6;
                String errorMsg = "XML configuration is not a valid VirtualBox v" + this.version.toString() + " configuration: " + e.getLocalizedMessage();
                LOGGER.debug(errorMsg);
            }
        }
        if (Util.isEmptyString(this.getDisplayName())) {
            throw new VirtualizationConfigurationException("Machine doesn't have a name");
        }
        try {
            this.ensureHardwareUuid();
            this.setOsType();
            this.fixUsb();
            this.removeUnusedHdds();
            if (this.checkForPlaceholders()) {
                return;
            }
            this.setHdds();
            this.removeBlacklistedElements();
            this.addPlaceHolders();
        }
        catch (XPathExpressionException e) {
            LOGGER.debug("Could not initialize VBoxConfig", (Throwable)e);
            return;
        }
    }

    private void parseConfigurationVersion() throws VirtualizationConfigurationException {
        String versionText;
        try {
            versionText = XmlHelper.compileXPath("/VirtualBox/@version").evaluate(this.doc);
        }
        catch (XPathExpressionException e) {
            throw new VirtualizationConfigurationException("Failed to parse the version number of the configuration file");
        }
        if (versionText == null || versionText.isEmpty()) {
            throw new VirtualizationConfigurationException("Configuration file does not contain any version number!");
        }
        Pattern versionPattern = Pattern.compile("^(\\d+\\.\\d+).*$");
        Matcher versionMatcher = versionPattern.matcher(versionText);
        if (versionMatcher.find()) {
            this.version = Version.valueOf(versionMatcher.group(1));
        }
        if (this.version == null) {
            throw new VirtualizationConfigurationException("Configuration file version number is not valid!");
        }
    }

    private void fixUsb() {
        NodeList list = this.findNodes("/VirtualBox/Machine/Hardware/USB/Controllers/Controller");
        if (list != null && list.getLength() != 0) {
            LOGGER.info("USB present, not fixing anything");
            return;
        }
        list = this.findNodes("/VirtualBox/OpenSLX/USB[@disabled]");
        if (list != null && list.getLength() != 0) {
            LOGGER.info("USB explicitly disabled");
            return;
        }
        LOGGER.info("Fixing USB: Adding USB 2.0");
        Element node = this.createNodeRecursive("/VirtualBox/Machine/Hardware/USB/Controllers");
        Element controller = this.addNewNode(node, "Controller");
        controller.setAttribute("name", "OHCI");
        controller.setAttribute("type", "OHCI");
        controller = this.addNewNode(node, "Controller");
        controller.setAttribute("name", "EHCI");
        controller.setAttribute("type", "EHCI");
    }

    private void removeUnusedHdds() {
        Element e;
        String uuid;
        Node item;
        int i;
        HashSet<String> existing = new HashSet<String>();
        NodeList list = this.findNodes(this.storageControllersPath() + "/StorageController/AttachedDevice/Image");
        if (list != null && list.getLength() != 0) {
            for (i = 0; i < list.getLength(); ++i) {
                item = list.item(i);
                if (!(item instanceof Element) || Util.isEmptyString(uuid = (e = (Element)item).getAttribute("uuid"))) continue;
                existing.add(uuid);
            }
        }
        if ((list = this.findNodes("/VirtualBox/Machine/MediaRegistry/HardDisks/HardDisk")) != null && list.getLength() != 0) {
            for (i = 0; i < list.getLength(); ++i) {
                item = list.item(i);
                if (!(item instanceof Element) || existing.contains(uuid = (e = (Element)item).getAttribute("uuid"))) continue;
                LOGGER.info("Removing unused HDD " + uuid + " from MediaRegistry");
                e.getParentNode().removeChild(e);
            }
        }
    }

    public String storageControllersPath() {
        if (this.getVersion().isSmallerThan(Version.valueOf("1.17"))) {
            return "/VirtualBox/Machine/StorageControllers";
        }
        return "/VirtualBox/Machine/Hardware/StorageControllers";
    }

    private void ensureHardwareUuid() throws XPathExpressionException, VirtualizationConfigurationException {
        String machineUuid = XmlHelper.compileXPath("/VirtualBox/Machine/@uuid").evaluate(this.doc);
        if (machineUuid.isEmpty()) {
            LOGGER.error("Machine UUID empty, should never happen!");
            throw new VirtualizationConfigurationException("XML doesn't contain a machine uuid");
        }
        NodeList hwNodes = this.findNodes("/VirtualBox/Machine/Hardware");
        int count = hwNodes.getLength();
        if (count != 1) {
            throw new VirtualizationConfigurationException("Zero or > 1 '/VirtualBox/Machine/Hardware' node were found, should never happen!");
        }
        Element hw = (Element)hwNodes.item(0);
        String hwUuid = hw.getAttribute("uuid");
        if (!hwUuid.isEmpty()) {
            LOGGER.info("Found hardware uuid: " + hwUuid);
            return;
        }
        if (!this.addAttributeToNode(hw, "uuid", machineUuid)) {
            LOGGER.error("Failed to set machine UUID '" + machineUuid + "' as hardware UUID.");
            return;
        }
        LOGGER.info("Saved machine UUID as hardware UUID.");
    }

    public Version getVersion() {
        return this.version;
    }

    public void addPlaceHolders() {
        this.changeAttribute("/VirtualBox/Machine/MediaRegistry/HardDisks/HardDisk", "location", DUMMY_VALUE, MatchMode.MULTIPLE);
        this.changeAttribute("/VirtualBox/Machine/MediaRegistry/HardDisks/HardDisk/HardDisk", "location", DUMMY_VALUE, MatchMode.MULTIPLE);
        this.changeAttribute("/VirtualBox/Machine", "snapshotFolder", DUMMY_VALUE, MatchMode.FIRST_ONLY);
    }

    private boolean checkForPlaceholders() {
        NodeList hdds = this.findNodes("/VirtualBox/Machine/MediaRegistry/HardDisks/HardDisk");
        for (int i = 0; i < hdds.getLength(); ++i) {
            Element hdd = (Element)hdds.item(i);
            if (hdd == null || !hdd.getAttribute("location").equals(DUMMY_VALUE)) continue;
            return true;
        }
        return false;
    }

    private void removeBlacklistedElements() throws XPathExpressionException {
        for (String blackedTag : BLACKLIST) {
            XPathExpression blackedExpr = XmlHelper.compileXPath(blackedTag);
            NodeList blackedNodes = (NodeList)blackedExpr.evaluate(this.doc, XPathConstants.NODESET);
            for (int i = 0; i < blackedNodes.getLength(); ++i) {
                Element child = (Element)blackedNodes.item(i);
                this.removeNode(child);
            }
        }
    }

    public String getDisplayName() {
        try {
            return XmlHelper.compileXPath("/VirtualBox/Machine/@name").evaluate(this.doc);
        }
        catch (XPathExpressionException e) {
            return "";
        }
    }

    public void setOsType() throws XPathExpressionException {
        String os = XmlHelper.compileXPath("/VirtualBox/Machine/@OSType").evaluate(this.doc);
        if (os != null && !os.isEmpty()) {
            this.osName = os;
        }
    }

    public String getOsName() {
        return this.osName;
    }

    public void setHdds() throws XPathExpressionException {
        XPathExpression hddsExpr = XmlHelper.compileXPath(this.storageControllersPath() + "/StorageController/AttachedDevice[@type='HardDisk']/Image");
        NodeList nodes = (NodeList)hddsExpr.evaluate(this.doc, XPathConstants.NODESET);
        if (nodes == null) {
            LOGGER.error("Failed to find attached hard drives.");
            return;
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node hddDevice;
            String uuid;
            Element hddElement = (Element)nodes.item(i);
            if (hddElement == null || (uuid = hddElement.getAttribute("uuid")).isEmpty()) continue;
            XPathExpression hddsRegistered = XmlHelper.compileXPath("/VirtualBox/Machine/MediaRegistry/HardDisks/HardDisk[@uuid='" + uuid + "']");
            NodeList hddsRegisteredNodes = (NodeList)hddsRegistered.evaluate(this.doc, XPathConstants.NODESET);
            if (hddsRegisteredNodes == null || hddsRegisteredNodes.getLength() != 1) {
                LOGGER.error("Found hard disk with uuid '" + uuid + "' which does not appear (unique) in the Media Registry. Skipping.");
                continue;
            }
            Element hddElementReg = (Element)hddsRegisteredNodes.item(0);
            if (hddElementReg == null) continue;
            String fileName = hddElementReg.getAttribute("location");
            String type = hddElementReg.getAttribute("type");
            if (!type.equals("Normal") && !type.equals("Writethrough")) {
                LOGGER.warn("Type of the disk file is neither 'Normal' nor 'Writethrough' but: " + type);
                LOGGER.warn("This makes the image not directly modificable, which might lead to problems when editing it locally.");
            }
            if ((hddDevice = hddElement.getParentNode()) == null) {
                LOGGER.error("HDD node had a null parent, shouldn't happen");
                continue;
            }
            Element hddController = (Element)hddDevice.getParentNode();
            if (hddController == null) {
                LOGGER.error("HDD node had a null parent, shouldn't happen");
                continue;
            }
            String controllerType = hddController.getAttribute("type");
            VirtualizationConfiguration.DriveBusType busType = this.controllerToBus(controllerType);
            if (busType == null) {
                LOGGER.warn("Skipping unknown or unsupported HDD controller type '" + controllerType + "'");
                continue;
            }
            LOGGER.info("Adding hard disk with controller: " + (Object)((Object)busType) + " from file '" + fileName + "'.");
            this.hddsArray.add(new VirtualizationConfiguration.HardDisk(controllerType, busType, fileName));
        }
    }

    private VirtualizationConfiguration.DriveBusType controllerToBus(String controller) {
        switch (controller) {
            case "AHCI": {
                return VirtualizationConfiguration.DriveBusType.SATA;
            }
            case "LsiLogic": 
            case "BusLogic": 
            case "LsiLogicSas": 
            case "VirtioSCSI": {
                return VirtualizationConfiguration.DriveBusType.SCSI;
            }
            case "PIIX3": 
            case "PIIX4": 
            case "ICH6": {
                return VirtualizationConfiguration.DriveBusType.IDE;
            }
            case "I82078": {
                return null;
            }
            case "USB": {
                return null;
            }
            case "NVMe": {
                return VirtualizationConfiguration.DriveBusType.NVME;
            }
        }
        return null;
    }

    public ArrayList<VirtualizationConfiguration.HardDisk> getHdds() {
        return this.hddsArray;
    }

    public boolean isMachineSnapshot() {
        NodeList machineSnapshots = this.findNodes("/VirtualBox/Machine/Snapshot");
        return machineSnapshots != null && machineSnapshots.getLength() > 0;
    }

    public NodeList findNodes(String xpath) {
        NodeList nodes = null;
        try {
            XPathExpression expr = XmlHelper.compileXPath(xpath);
            Object nodesObject = expr.evaluate(this.doc, XPathConstants.NODESET);
            nodes = (NodeList)nodesObject;
        }
        catch (XPathExpressionException e) {
            LOGGER.error("Could not build path", (Throwable)e);
        }
        return nodes;
    }

    public boolean changeAttribute(String elementXPath, String attribute, String value, MatchMode mode) {
        NodeList nodes = this.findNodes(elementXPath);
        if (nodes == null || nodes.getLength() == 0) {
            if (mode != MatchMode.MULTIPLE) {
                LOGGER.error("No node could be found for: " + elementXPath);
            }
            return false;
        }
        if (nodes.getLength() != 1 && mode == MatchMode.EXACTLY_ONE) {
            LOGGER.error("Multiple nodes found for: " + elementXPath);
            return false;
        }
        boolean ret = true;
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (!this.addAttributeToNode(nodes.item(i), attribute, value)) {
                ret = false;
            }
            if (mode == MatchMode.FIRST_ONLY) break;
        }
        return ret;
    }

    public boolean addAttributeToNode(Node node, String attribute, String value) {
        if (node == null || node.getNodeType() != 1) {
            LOGGER.error("Trying to change attribute of a non element node!");
            return false;
        }
        try {
            ((Element)node).setAttribute(attribute, value);
        }
        catch (DOMException e) {
            LOGGER.error("Failed set '" + attribute + "' to '" + value + "' of xml node '" + node.getNodeName() + "': ", (Throwable)e);
            return false;
        }
        return true;
    }

    public Element addNewNode(String parentXPath, String childName) {
        NodeList possibleParents = this.findNodes(parentXPath);
        if (possibleParents == null || possibleParents.getLength() != 1) {
            LOGGER.error("Could not find unique parent node to add new node to: " + parentXPath);
            return null;
        }
        return this.addNewNode(possibleParents.item(0), childName);
    }

    public Element createNodeRecursive(String xPath) {
        String[] nodeNames = xPath.split("/");
        Node parent = this.doc;
        Element latest = null;
        for (int nodeIndex = 0; nodeIndex < nodeNames.length; ++nodeIndex) {
            if (nodeNames[nodeIndex].length() == 0) continue;
            Element node = this.skipNonElementNodes(parent.getFirstChild());
            while (!(node == null || node.getNodeType() == 1 && nodeNames[nodeIndex].equals(node.getNodeName()))) {
                node = this.skipNonElementNodes(node.getNextSibling());
            }
            if (node == null) {
                node = this.doc.createElement(nodeNames[nodeIndex]);
                parent.appendChild(node);
            }
            parent = node;
            latest = node;
        }
        return latest;
    }

    private Element skipNonElementNodes(Node nn) {
        while (nn != null && nn.getNodeType() != 1) {
            nn = nn.getNextSibling();
        }
        return (Element)nn;
    }

    public void setExtraData(String key, String value) {
        NodeList nl = this.findNodes("/VirtualBox/Machine/ExtraData/ExtraDataItem");
        Element e = null;
        if (nl != null) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Element ne;
                String keyValue;
                Node n = nl.item(i);
                if (n.getNodeType() != 1 || (keyValue = (ne = (Element)n).getAttribute("name")) == null || !keyValue.equals(key)) continue;
                e = ne;
                break;
            }
        }
        if (e == null) {
            Element p = this.createNodeRecursive("/VirtualBox/Machine/ExtraData");
            e = this.addNewNode(p, "ExtraDataItem");
            e.setAttribute("name", key);
        }
        e.setAttribute("value", value);
    }

    public Element addNewNode(Node parent, String childName) {
        if (parent == null || parent.getNodeType() != 1) {
            return null;
        }
        Element newNode = null;
        try {
            newNode = this.doc.createElement(childName);
            parent.appendChild(newNode);
        }
        catch (DOMException e) {
            LOGGER.error("Failed to add '" + childName + "' to '" + parent.getNodeName() + "'.");
        }
        return newNode;
    }

    private void removeNode(Node node) {
        if (node == null) {
            return;
        }
        Node parent = node.getParentNode();
        if (parent != null) {
            parent.removeChild(node);
        }
    }

    public String toString(boolean prettyPrint) {
        return XmlHelper.getXmlFromDocument(this.doc, prettyPrint);
    }

    public void removeNodes(String parentPath, String childName) {
        NodeList parentNodes = this.findNodes(parentPath);
        for (int i = 0; i < parentNodes.getLength(); ++i) {
            Node parent = parentNodes.item(i);
            ArrayList<Node> delList = new ArrayList<Node>(0);
            for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!childName.equals(child.getNodeName())) continue;
                delList.add(child);
            }
            for (Node child : delList) {
                parent.removeChild(child);
            }
        }
    }

    public static enum MatchMode {
        EXACTLY_ONE,
        MULTIPLE,
        FIRST_ONLY;

    }
}

